/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.dto;

import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.dto.SemanticVersionDTO;
import dev.ikm.tinkar.dto.StampDTO;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.collections.api.list.ImmutableList;

public class SemanticVersionDTOBuilder {
    private PublicId publicId;
    private StampDTO stamp;
    private ImmutableList<Object> fieldValues;

    private SemanticVersionDTOBuilder() {
    }

    private SemanticVersionDTOBuilder(PublicId publicId, StampDTO stamp, ImmutableList<Object> fieldValues) {
        this.publicId = publicId;
        this.stamp = stamp;
        this.fieldValues = fieldValues;
    }

    public static SemanticVersionDTO SemanticVersionDTO(PublicId publicId, StampDTO stamp, ImmutableList<Object> fieldValues) {
        return new SemanticVersionDTO(publicId, stamp, fieldValues);
    }

    public static SemanticVersionDTOBuilder builder() {
        return new SemanticVersionDTOBuilder();
    }

    public static SemanticVersionDTOBuilder builder(SemanticVersionDTO from) {
        return new SemanticVersionDTOBuilder(from.publicId(), from.stamp(), from.fieldValues());
    }

    public static With from(SemanticVersionDTO from) {
        return new _FromWith(from);
    }

    public static Stream<Map.Entry<String, Object>> stream(SemanticVersionDTO record) {
        return Stream.of(new AbstractMap.SimpleImmutableEntry<String, PublicId>("publicId", record.publicId()), new AbstractMap.SimpleImmutableEntry<String, StampDTO>("stamp", record.stamp()), new AbstractMap.SimpleImmutableEntry<String, ImmutableList<Object>>("fieldValues", record.fieldValues()));
    }

    public SemanticVersionDTO build() {
        return new SemanticVersionDTO(this.publicId, this.stamp, this.fieldValues);
    }

    public String toString() {
        return "SemanticVersionDTOBuilder[publicId=" + String.valueOf(this.publicId) + ", stamp=" + String.valueOf(this.stamp) + ", fieldValues=" + String.valueOf(this.fieldValues) + "]";
    }

    public int hashCode() {
        return Objects.hash(this.publicId, this.stamp, this.fieldValues);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof SemanticVersionDTOBuilder)) return false;
        SemanticVersionDTOBuilder r = (SemanticVersionDTOBuilder)o;
        if (!Objects.equals(this.publicId, r.publicId)) return false;
        if (!Objects.equals(this.stamp, r.stamp)) return false;
        if (!Objects.equals(this.fieldValues, r.fieldValues)) return false;
        return true;
    }

    public SemanticVersionDTOBuilder publicId(PublicId publicId) {
        this.publicId = publicId;
        return this;
    }

    public PublicId publicId() {
        return this.publicId;
    }

    public SemanticVersionDTOBuilder stamp(StampDTO stamp) {
        this.stamp = stamp;
        return this;
    }

    public StampDTO stamp() {
        return this.stamp;
    }

    public SemanticVersionDTOBuilder fieldValues(ImmutableList<Object> fieldValues) {
        this.fieldValues = fieldValues;
        return this;
    }

    public ImmutableList<Object> fieldValues() {
        return this.fieldValues;
    }

    private static final class _FromWith
    implements With {
        private final SemanticVersionDTO from;

        private _FromWith(SemanticVersionDTO from) {
            this.from = from;
        }

        @Override
        public PublicId publicId() {
            return this.from.publicId();
        }

        @Override
        public StampDTO stamp() {
            return this.from.stamp();
        }

        @Override
        public ImmutableList<Object> fieldValues() {
            return this.from.fieldValues();
        }
    }

    public static interface With {
        public PublicId publicId();

        public StampDTO stamp();

        public ImmutableList<Object> fieldValues();

        default public SemanticVersionDTOBuilder with() {
            return new SemanticVersionDTOBuilder(this.publicId(), this.stamp(), this.fieldValues());
        }

        default public SemanticVersionDTO with(Consumer<SemanticVersionDTOBuilder> consumer) {
            SemanticVersionDTOBuilder builder = this.with();
            consumer.accept(builder);
            return builder.build();
        }

        default public SemanticVersionDTO withPublicId(PublicId publicId) {
            return new SemanticVersionDTO(publicId, this.stamp(), this.fieldValues());
        }

        default public SemanticVersionDTO withStamp(StampDTO stamp) {
            return new SemanticVersionDTO(this.publicId(), stamp, this.fieldValues());
        }

        default public SemanticVersionDTO withFieldValues(ImmutableList<Object> fieldValues) {
            return new SemanticVersionDTO(this.publicId(), this.stamp(), fieldValues);
        }
    }
}

