/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.dto;

import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.component.Concept;
import dev.ikm.tinkar.component.Stamp;
import dev.ikm.tinkar.dto.ConceptDTO;
import dev.ikm.tinkar.dto.DTO;
import dev.ikm.tinkar.dto.binary.Marshalable;
import dev.ikm.tinkar.dto.binary.Marshaler;
import dev.ikm.tinkar.dto.binary.TinkarInput;
import dev.ikm.tinkar.dto.binary.TinkarOutput;
import dev.ikm.tinkar.dto.binary.Unmarshaler;

public record StampDTO(PublicId publicId, PublicId statusPublicId, long time, PublicId authorPublicId, PublicId modulePublicId, PublicId pathPublicId) implements Marshalable,
Stamp,
DTO
{
    private static final int localMarshalVersion = 3;

    public static StampDTO make(Stamp stamp) {
        return new StampDTO(stamp.publicId(), stamp.state().publicId(), stamp.time(), stamp.author().publicId(), stamp.module().publicId(), stamp.path().publicId());
    }

    @Unmarshaler
    public static StampDTO make(TinkarInput in) {
        if (3 == in.getTinkerFormatVersion()) {
            return new StampDTO(in.getPublicId(), in.getPublicId(), in.getLong(), in.getPublicId(), in.getPublicId(), in.getPublicId());
        }
        throw new UnsupportedOperationException("Unsupported version: 3");
    }

    public Concept state() {
        return new ConceptDTO(this.statusPublicId);
    }

    public Concept author() {
        return new ConceptDTO(this.authorPublicId);
    }

    public Concept module() {
        return new ConceptDTO(this.modulePublicId);
    }

    public Concept path() {
        return new ConceptDTO(this.pathPublicId);
    }

    @Override
    @Marshaler
    public void marshal(TinkarOutput out) {
        out.putPublicId(this.publicId());
        out.putPublicId(this.statusPublicId);
        out.putLong(this.time);
        out.putPublicId(this.authorPublicId);
        out.putPublicId(this.modulePublicId);
        out.putPublicId(this.pathPublicId);
    }
}

