/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.dto;

import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.dto.StampDTO;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class StampDTOBuilder {
    private PublicId publicId;
    private PublicId statusPublicId;
    private long time;
    private PublicId authorPublicId;
    private PublicId modulePublicId;
    private PublicId pathPublicId;

    private StampDTOBuilder() {
    }

    private StampDTOBuilder(PublicId publicId, PublicId statusPublicId, long time, PublicId authorPublicId, PublicId modulePublicId, PublicId pathPublicId) {
        this.publicId = publicId;
        this.statusPublicId = statusPublicId;
        this.time = time;
        this.authorPublicId = authorPublicId;
        this.modulePublicId = modulePublicId;
        this.pathPublicId = pathPublicId;
    }

    public static StampDTO StampDTO(PublicId publicId, PublicId statusPublicId, long time, PublicId authorPublicId, PublicId modulePublicId, PublicId pathPublicId) {
        return new StampDTO(publicId, statusPublicId, time, authorPublicId, modulePublicId, pathPublicId);
    }

    public static StampDTOBuilder builder() {
        return new StampDTOBuilder();
    }

    public static StampDTOBuilder builder(StampDTO from) {
        return new StampDTOBuilder(from.publicId(), from.statusPublicId(), from.time(), from.authorPublicId(), from.modulePublicId(), from.pathPublicId());
    }

    public static With from(StampDTO from) {
        return new _FromWith(from);
    }

    public static Stream<Map.Entry<String, Object>> stream(StampDTO record) {
        return Stream.of(new AbstractMap.SimpleImmutableEntry<String, PublicId>("publicId", record.publicId()), new AbstractMap.SimpleImmutableEntry<String, PublicId>("statusPublicId", record.statusPublicId()), new AbstractMap.SimpleImmutableEntry<String, Long>("time", record.time()), new AbstractMap.SimpleImmutableEntry<String, PublicId>("authorPublicId", record.authorPublicId()), new AbstractMap.SimpleImmutableEntry<String, PublicId>("modulePublicId", record.modulePublicId()), new AbstractMap.SimpleImmutableEntry<String, PublicId>("pathPublicId", record.pathPublicId()));
    }

    public StampDTO build() {
        return new StampDTO(this.publicId, this.statusPublicId, this.time, this.authorPublicId, this.modulePublicId, this.pathPublicId);
    }

    public String toString() {
        return "StampDTOBuilder[publicId=" + String.valueOf(this.publicId) + ", statusPublicId=" + String.valueOf(this.statusPublicId) + ", time=" + this.time + ", authorPublicId=" + String.valueOf(this.authorPublicId) + ", modulePublicId=" + String.valueOf(this.modulePublicId) + ", pathPublicId=" + String.valueOf(this.pathPublicId) + "]";
    }

    public int hashCode() {
        return Objects.hash(this.publicId, this.statusPublicId, this.time, this.authorPublicId, this.modulePublicId, this.pathPublicId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof StampDTOBuilder)) return false;
        StampDTOBuilder r = (StampDTOBuilder)o;
        if (!Objects.equals(this.publicId, r.publicId)) return false;
        if (!Objects.equals(this.statusPublicId, r.statusPublicId)) return false;
        if (this.time != r.time) return false;
        if (!Objects.equals(this.authorPublicId, r.authorPublicId)) return false;
        if (!Objects.equals(this.modulePublicId, r.modulePublicId)) return false;
        if (!Objects.equals(this.pathPublicId, r.pathPublicId)) return false;
        return true;
    }

    public StampDTOBuilder publicId(PublicId publicId) {
        this.publicId = publicId;
        return this;
    }

    public PublicId publicId() {
        return this.publicId;
    }

    public StampDTOBuilder statusPublicId(PublicId statusPublicId) {
        this.statusPublicId = statusPublicId;
        return this;
    }

    public PublicId statusPublicId() {
        return this.statusPublicId;
    }

    public StampDTOBuilder time(long time) {
        this.time = time;
        return this;
    }

    public long time() {
        return this.time;
    }

    public StampDTOBuilder authorPublicId(PublicId authorPublicId) {
        this.authorPublicId = authorPublicId;
        return this;
    }

    public PublicId authorPublicId() {
        return this.authorPublicId;
    }

    public StampDTOBuilder modulePublicId(PublicId modulePublicId) {
        this.modulePublicId = modulePublicId;
        return this;
    }

    public PublicId modulePublicId() {
        return this.modulePublicId;
    }

    public StampDTOBuilder pathPublicId(PublicId pathPublicId) {
        this.pathPublicId = pathPublicId;
        return this;
    }

    public PublicId pathPublicId() {
        return this.pathPublicId;
    }

    private static final class _FromWith
    implements With {
        private final StampDTO from;

        private _FromWith(StampDTO from) {
            this.from = from;
        }

        @Override
        public PublicId publicId() {
            return this.from.publicId();
        }

        @Override
        public PublicId statusPublicId() {
            return this.from.statusPublicId();
        }

        @Override
        public long time() {
            return this.from.time();
        }

        @Override
        public PublicId authorPublicId() {
            return this.from.authorPublicId();
        }

        @Override
        public PublicId modulePublicId() {
            return this.from.modulePublicId();
        }

        @Override
        public PublicId pathPublicId() {
            return this.from.pathPublicId();
        }
    }

    public static interface With {
        public PublicId publicId();

        public PublicId statusPublicId();

        public long time();

        public PublicId authorPublicId();

        public PublicId modulePublicId();

        public PublicId pathPublicId();

        default public StampDTOBuilder with() {
            return new StampDTOBuilder(this.publicId(), this.statusPublicId(), this.time(), this.authorPublicId(), this.modulePublicId(), this.pathPublicId());
        }

        default public StampDTO with(Consumer<StampDTOBuilder> consumer) {
            StampDTOBuilder builder = this.with();
            consumer.accept(builder);
            return builder.build();
        }

        default public StampDTO withPublicId(PublicId publicId) {
            return new StampDTO(publicId, this.statusPublicId(), this.time(), this.authorPublicId(), this.modulePublicId(), this.pathPublicId());
        }

        default public StampDTO withStatusPublicId(PublicId statusPublicId) {
            return new StampDTO(this.publicId(), statusPublicId, this.time(), this.authorPublicId(), this.modulePublicId(), this.pathPublicId());
        }

        default public StampDTO withTime(long time) {
            return new StampDTO(this.publicId(), this.statusPublicId(), time, this.authorPublicId(), this.modulePublicId(), this.pathPublicId());
        }

        default public StampDTO withAuthorPublicId(PublicId authorPublicId) {
            return new StampDTO(this.publicId(), this.statusPublicId(), this.time(), authorPublicId, this.modulePublicId(), this.pathPublicId());
        }

        default public StampDTO withModulePublicId(PublicId modulePublicId) {
            return new StampDTO(this.publicId(), this.statusPublicId(), this.time(), this.authorPublicId(), modulePublicId, this.pathPublicId());
        }

        default public StampDTO withPathPublicId(PublicId pathPublicId) {
            return new StampDTO(this.publicId(), this.statusPublicId(), this.time(), this.authorPublicId(), this.modulePublicId(), pathPublicId);
        }
    }
}

