/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.dto.binary;

import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.dto.binary.MarshalExceptionUnchecked;
import dev.ikm.tinkar.dto.binary.Marshaler;
import dev.ikm.tinkar.dto.binary.SemanticVersionUnmarshaler;
import dev.ikm.tinkar.dto.binary.TinkarByteArrayOutput;
import dev.ikm.tinkar.dto.binary.TinkarInput;
import dev.ikm.tinkar.dto.binary.TinkarOutput;
import dev.ikm.tinkar.dto.binary.Unmarshaler;
import dev.ikm.tinkar.dto.binary.VersionUnmarshaler;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public interface Marshalable {
    public static final int marshalVersion = 3;

    @Marshaler
    public void marshal(TinkarOutput var1);

    default public TinkarByteArrayOutput marshal() {
        TinkarByteArrayOutput byteArrayOutput = TinkarByteArrayOutput.make();
        this.marshal(byteArrayOutput);
        return byteArrayOutput;
    }

    public static <T> T makeVersion(Class<T> objectClass, TinkarByteArrayOutput output, PublicId componentPublicId) {
        return Marshalable.makeVersion(objectClass, output.getBytes(), componentPublicId);
    }

    public static <T> T makeVersion(Class<T> objectClass, byte[] input, PublicId componentPublicId) {
        return Marshalable.makeVersion(objectClass, TinkarInput.make(input), componentPublicId);
    }

    public static <T> T makeSemanticVersion(Class<T> objectClass, TinkarInput input, PublicId publicId) {
        try {
            return Marshalable.unmarshal(objectClass, SemanticVersionUnmarshaler.class, new Object[]{input, publicId});
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new MarshalExceptionUnchecked(ex);
        }
    }

    public static <T> T makeVersion(Class<T> objectClass, TinkarInput input, PublicId componentPublicId) {
        try {
            return Marshalable.unmarshal(objectClass, VersionUnmarshaler.class, new Object[]{input, componentPublicId});
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new MarshalExceptionUnchecked(ex);
        }
    }

    public static <T> T make(Class<T> objectClass, TinkarInput input) {
        try {
            return Marshalable.unmarshal(objectClass, Unmarshaler.class, new Object[]{input});
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new MarshalExceptionUnchecked(ex);
        }
    }

    public static <T> T make(Class<T> objectClass, byte[] input, int tinkarFormatVersion) {
        return Marshalable.make(objectClass, TinkarInput.make(input, tinkarFormatVersion));
    }

    public static <T> T make(Class<T> objectClass, byte[] input) {
        return Marshalable.make(objectClass, TinkarInput.make(input));
    }

    public static <T> T make(Class<T> objectClass, TinkarByteArrayOutput output) {
        return Marshalable.make(objectClass, TinkarInput.make(output));
    }

    public static <T> T unmarshal(Class<T> objectClass, Class<? extends Annotation> annotationClass, Object[] parameters) throws IllegalAccessException, InvocationTargetException {
        ArrayList<Method> unmarshalMethodList = Marshalable.getUnmarshalMethods(objectClass, annotationClass);
        if (unmarshalMethodList.isEmpty()) {
            throw new MarshalExceptionUnchecked("No " + annotationClass.getSimpleName() + " method for class: " + String.valueOf(objectClass));
        }
        if (unmarshalMethodList.size() == 1) {
            Method unmarshalMethod = unmarshalMethodList.get(0);
            return (T)unmarshalMethod.invoke(null, parameters);
        }
        throw new MarshalExceptionUnchecked("More than one unmarshal method for class: " + String.valueOf(objectClass) + " methods: " + String.valueOf(unmarshalMethodList));
    }

    public static <T> ArrayList<Method> getUnmarshalMethods(Class<T> objectClass, Class<? extends Annotation> annotationClass) {
        ArrayList<Method> unmarshalMethodList = new ArrayList<Method>();
        for (Method method : objectClass.getDeclaredMethods()) {
            for (Annotation annotation : method.getAnnotations()) {
                if (!annotation.annotationType().equals(annotationClass)) continue;
                if (Modifier.isStatic(method.getModifiers())) {
                    unmarshalMethodList.add(method);
                    continue;
                }
                throw new MarshalExceptionUnchecked(annotationClass.getSimpleName() + " method for class: " + String.valueOf(objectClass) + " is not static: " + String.valueOf(method));
            }
        }
        return unmarshalMethodList;
    }
}

