/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.dto.binary;

import dev.ikm.tinkar.dto.binary.TinkarInput;
import dev.ikm.tinkar.dto.binary.TinkarOutput;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class TinkarByteArrayOutput
extends TinkarOutput {
    final ByteArrayOutputStream byteArrayOutputStream;

    private TinkarByteArrayOutput(ByteArrayOutputStream byteArrayOutputStream) {
        super(byteArrayOutputStream);
        this.byteArrayOutputStream = byteArrayOutputStream;
    }

    private TinkarByteArrayOutput(ByteArrayOutputStream byteArrayOutputStream, int tinkerFormatVersion) {
        super(byteArrayOutputStream);
        this.byteArrayOutputStream = byteArrayOutputStream;
    }

    public byte[] getBytes() {
        return this.byteArrayOutputStream.toByteArray();
    }

    public static TinkarByteArrayOutput make() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        return new TinkarByteArrayOutput(baos);
    }

    public static TinkarByteArrayOutput make(int tinkerFormatVersion) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        return new TinkarByteArrayOutput(baos, tinkerFormatVersion);
    }

    public TinkarInput toInput() {
        ByteArrayInputStream bais = new ByteArrayInputStream(this.getBytes());
        return new TinkarInput(bais);
    }
}

