/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.dto.binary;

import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.common.id.PublicIdList;
import dev.ikm.tinkar.common.id.PublicIdSet;
import dev.ikm.tinkar.common.id.PublicIds;
import dev.ikm.tinkar.common.id.VertexId;
import dev.ikm.tinkar.common.id.VertexIds;
import dev.ikm.tinkar.component.FieldDataType;
import dev.ikm.tinkar.component.location.PlanarPoint;
import dev.ikm.tinkar.component.location.SpatialPoint;
import dev.ikm.tinkar.dto.ComponentDTO;
import dev.ikm.tinkar.dto.ConceptChronologyDTO;
import dev.ikm.tinkar.dto.ConceptDTO;
import dev.ikm.tinkar.dto.ConceptVersionDTO;
import dev.ikm.tinkar.dto.FieldDefinitionDTO;
import dev.ikm.tinkar.dto.PatternChronologyDTO;
import dev.ikm.tinkar.dto.PatternDTO;
import dev.ikm.tinkar.dto.PatternVersionDTO;
import dev.ikm.tinkar.dto.SemanticChronologyDTO;
import dev.ikm.tinkar.dto.SemanticDTO;
import dev.ikm.tinkar.dto.SemanticVersionDTO;
import dev.ikm.tinkar.dto.binary.TinkarByteArrayOutput;
import dev.ikm.tinkar.dto.graph.DiGraphDTO;
import dev.ikm.tinkar.dto.graph.DiTreeDTO;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.util.UUID;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.ImmutableList;

public class TinkarInput
extends DataInputStream {
    private int tinkerFormatVersion = 3;

    public final int getTinkerFormatVersion() {
        return this.tinkerFormatVersion;
    }

    public final void setTinkerFormatVersion(int tinkerFormatVersion) {
        this.tinkerFormatVersion = tinkerFormatVersion;
    }

    public TinkarInput(InputStream in) {
        super(in);
        try {
            this.tinkerFormatVersion = this.readInt();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public TinkarInput(InputStream in, int tinkerFormatVersion) {
        super(in);
        this.tinkerFormatVersion = tinkerFormatVersion;
    }

    public ImmutableList<UUID> readImmutableUuidList() {
        return Lists.immutable.of((Object[])this.readUuidArray());
    }

    public UUID[] readUuidArray() {
        try {
            int length = this.readInt();
            if (length > 256) {
                throw new IllegalStateException("UUID list of size > 256: " + length);
            }
            UUID[] array = new UUID[length];
            for (int i = 0; i < length; ++i) {
                array[i] = new UUID(this.readLong(), this.readLong());
            }
            return array;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public UUID getUuid() {
        try {
            return new UUID(this.readLong(), this.readLong());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public Instant readInstant() {
        try {
            long time = this.readLong();
            if (time == Long.MAX_VALUE) {
                return Instant.MAX;
            }
            if (time == Long.MIN_VALUE) {
                return Instant.MIN;
            }
            return Instant.ofEpochMilli(time);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static TinkarInput make(byte[] buf, int tinkerFormatVersion) {
        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
        return new TinkarInput(bais, tinkerFormatVersion);
    }

    public static TinkarInput make(byte[] buf) {
        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
        return new TinkarInput(bais);
    }

    public static TinkarInput make(TinkarByteArrayOutput tinkarOut) {
        ByteArrayInputStream bais = new ByteArrayInputStream(tinkarOut.getBytes());
        return new TinkarInput(bais);
    }

    public ImmutableList<FieldDefinitionDTO> readFieldDefinitionList() {
        try {
            int length = this.readInt();
            Object[] array = new FieldDefinitionDTO[length];
            for (int i = 0; i < length; ++i) {
                array[i] = FieldDefinitionDTO.make(this);
            }
            return Lists.immutable.of(array);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public ImmutableList<ConceptVersionDTO> readConceptVersionList(PublicId publicId) {
        try {
            int length = this.readInt();
            Object[] array = new ConceptVersionDTO[length];
            for (int i = 0; i < length; ++i) {
                array[i] = ConceptVersionDTO.make(this, publicId);
            }
            return Lists.immutable.of(array);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public ImmutableList<PatternVersionDTO> readPatternVersionList(PublicId componentPublicId) {
        try {
            int length = this.readInt();
            Object[] array = new PatternVersionDTO[length];
            for (int i = 0; i < length; ++i) {
                array[i] = PatternVersionDTO.make(this, componentPublicId);
            }
            return Lists.immutable.of(array);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public ImmutableList<SemanticVersionDTO> readSemanticVersionList(PublicId componentPublicId, PublicId patternPublicId, PublicId referencedComponentPublicId) {
        try {
            int length = this.readInt();
            Object[] array = new SemanticVersionDTO[length];
            for (int i = 0; i < length; ++i) {
                array[i] = SemanticVersionDTO.make(this, componentPublicId);
            }
            return Lists.immutable.of(array);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public ImmutableList<Object> readImmutableObjectList() {
        return Lists.immutable.of(this.readObjectArray());
    }

    public Object[] readObjectArray() {
        try {
            int fieldCount = this.readInt();
            Object[] array = new Object[fieldCount];
            for (int i = 0; i < array.length; ++i) {
                this.readObject(array, i);
            }
            return array;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void readObject(Object[] array, int i) {
        try {
            byte token = this.readByte();
            FieldDataType dataType = FieldDataType.fromToken((byte)token);
            array[i] = this.unmarshal(dataType);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Object getTinkarNativeObject() {
        try {
            byte token = this.readByte();
            FieldDataType dataType = FieldDataType.fromToken((byte)token);
            return this.unmarshal(dataType);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public VertexId readVertexId() {
        try {
            return VertexIds.of((long)this.readLong(), (long)this.readLong());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public PublicId getPublicId() {
        try {
            int uuidCount = this.readInt();
            if (uuidCount == 1) {
                return PublicIds.of((long)this.readLong(), (long)this.readLong());
            }
            if (uuidCount == 2) {
                return PublicIds.of((long)this.readLong(), (long)this.readLong(), (long)this.readLong(), (long)this.readLong());
            }
            if (uuidCount == 3) {
                return PublicIds.of((long)this.readLong(), (long)this.readLong(), (long)this.readLong(), (long)this.readLong(), (long)this.readLong(), (long)this.readLong());
            }
            long[] uuidParts = new long[uuidCount * 2];
            for (int i = 0; i < uuidCount; ++i) {
                uuidParts[i * 2] = this.readLong();
                uuidParts[i * 2 + 1] = this.readLong();
            }
            return PublicIds.of((long[])uuidParts);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Object unmarshal(FieldDataType dataType) {
        try {
            switch (dataType) {
                case STRING: {
                    return this.readUTF();
                }
                case FLOAT: {
                    return Float.valueOf(this.readFloat());
                }
                case BOOLEAN: {
                    return this.readBoolean();
                }
                case BYTE_ARRAY: {
                    return this.readByteArray();
                }
                case IDENTIFIED_THING: {
                    return new ComponentDTO(this.getPublicId());
                }
                case INTEGER: {
                    return this.readInt();
                }
                case OBJECT_ARRAY: {
                    return this.readEmbeddedObjectArray();
                }
                case INSTANT: {
                    return this.readInstant();
                }
                case CONCEPT_CHRONOLOGY: {
                    return ConceptChronologyDTO.make(this);
                }
                case CONCEPT: {
                    return ConceptDTO.make(this);
                }
                case PATTERN_CHRONOLOGY: {
                    return PatternChronologyDTO.make(this);
                }
                case PATTERN: {
                    return PatternDTO.make(this);
                }
                case SEMANTIC_CHRONOLOGY: {
                    return SemanticChronologyDTO.make(this);
                }
                case SEMANTIC: {
                    return SemanticDTO.make(this);
                }
                case DITREE: {
                    return DiTreeDTO.make(this);
                }
                case DIGRAPH: {
                    return DiGraphDTO.make(this);
                }
                case SPATIAL_POINT: {
                    return new SpatialPoint((float)this.readInt(), (float)this.readInt(), (float)this.readInt());
                }
                case PLANAR_POINT: {
                    return new PlanarPoint((float)this.readInt(), (float)this.readInt());
                }
                case COMPONENT_ID_LIST: {
                    return this.readIdList();
                }
                case COMPONENT_ID_SET: {
                    return this.readIdSet();
                }
            }
            throw new UnsupportedOperationException("TinkarInput does know how to unmarshal: " + String.valueOf(dataType));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private PublicIdList<PublicId> readIdList() throws IOException {
        PublicId[] publicIds = this.getPublicIds();
        return PublicIds.list.ofArray(publicIds);
    }

    private PublicIdSet<PublicId> readIdSet() throws IOException {
        PublicId[] publicIds = this.getPublicIds();
        return PublicIds.set.ofArray(publicIds);
    }

    private PublicId[] getPublicIds() throws IOException {
        int size = this.getInt();
        PublicId[] publicIds = new PublicId[size];
        for (int publicIdCount = 0; publicIdCount < size; ++publicIdCount) {
            UUID[] uuidArray = new UUID[this.getInt()];
            if (uuidArray.length == 0) {
                throw new IllegalStateException("UUID array with size 0");
            }
            for (int uuidCount = 0; uuidCount < uuidArray.length; ++uuidCount) {
                uuidArray[uuidCount] = new UUID(this.readLong(), this.readLong());
            }
            publicIds[publicIdCount] = PublicIds.of((UUID[])uuidArray);
        }
        return publicIds;
    }

    private Object[] readEmbeddedObjectArray() throws IOException {
        int size = this.readInt();
        Object[] objects = new Object[size];
        for (int j = 0; j < size; ++j) {
            this.readObject(objects, j);
        }
        return objects;
    }

    private byte[] readByteArray() throws IOException {
        int size = this.readInt();
        return this.readNBytes(size);
    }

    public int getInt() {
        try {
            return this.readInt();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public long getLong() {
        try {
            return this.readLong();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

