/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.dto.binary;

import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.common.id.PublicIdList;
import dev.ikm.tinkar.common.id.PublicIdSet;
import dev.ikm.tinkar.common.id.VertexId;
import dev.ikm.tinkar.component.Component;
import dev.ikm.tinkar.component.FieldDataType;
import dev.ikm.tinkar.dto.ConceptVersionDTO;
import dev.ikm.tinkar.dto.FieldDefinitionDTO;
import dev.ikm.tinkar.dto.PatternVersionDTO;
import dev.ikm.tinkar.dto.SemanticVersionDTO;
import dev.ikm.tinkar.dto.binary.Marshalable;
import dev.ikm.tinkar.dto.graph.DiGraphDTO;
import dev.ikm.tinkar.dto.graph.DiTreeDTO;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;

public class TinkarOutput
extends DataOutputStream {
    private int tinkerFormatVersion = 3;

    public final int getTinkerFormatVersion() {
        return this.tinkerFormatVersion;
    }

    public final void setTinkerFormatVersion(int tinkerFormatVersion) {
        this.tinkerFormatVersion = tinkerFormatVersion;
    }

    public TinkarOutput(OutputStream out) {
        super(out);
        try {
            this.writeInt(3);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public TinkarOutput(OutputStream out, int tinkerFormatVersion) {
        super(out);
        this.tinkerFormatVersion = tinkerFormatVersion;
    }

    public void writeUuidArray(UUID[] array) {
        try {
            this.writeInt(array.length);
            for (UUID uuid : array) {
                this.writeLong(uuid.getMostSignificantBits());
                this.writeLong(uuid.getLeastSignificantBits());
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public void writeUuid(UUID uuid) {
        try {
            this.writeLong(uuid.getMostSignificantBits());
            this.writeLong(uuid.getLeastSignificantBits());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public void writeInstant(Instant instant) {
        try {
            this.writeLong(instant.toEpochMilli());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public void writeFieldDefinitionList(ImmutableList<FieldDefinitionDTO> fieldDefinitions) {
        try {
            this.writeInt(fieldDefinitions.size());
            for (FieldDefinitionDTO fieldDefinition : fieldDefinitions) {
                fieldDefinition.marshal(this);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public void writeConceptVersionList(ImmutableList<ConceptVersionDTO> versions) {
        try {
            this.writeInt(versions.size());
            for (ConceptVersionDTO version : versions) {
                version.marshal(this);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public void writePatternVersionList(ImmutableList<PatternVersionDTO> versions) {
        try {
            this.writeInt(versions.size());
            for (PatternVersionDTO version : versions) {
                version.marshal(this);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public void writeSemanticVersionList(ImmutableList<SemanticVersionDTO> versions) {
        try {
            this.writeInt(versions.size());
            for (SemanticVersionDTO version : versions) {
                version.marshal(this);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public void putTinkarNativeObject(Object object) {
        this.writeField(object);
    }

    private void writeField(Object object) {
        FieldDataType fieldDataType = FieldDataType.getFieldDataType((Object)object);
        try {
            switch (fieldDataType) {
                case BOOLEAN: {
                    this.writeBoolean((Boolean)object, fieldDataType);
                    break;
                }
                case BYTE_ARRAY: {
                    if (object instanceof ByteArrayList) {
                        ByteArrayList bal = (ByteArrayList)object;
                        object = bal.toArray();
                    }
                    this.writeByteArray((byte[])object, fieldDataType);
                    break;
                }
                case DIGRAPH: {
                    this.writeDigraph((DiGraphDTO)object);
                    break;
                }
                case DITREE: {
                    this.writeDitree((DiTreeDTO)object);
                    break;
                }
                case FLOAT: {
                    this.writeFloat((Number)object, fieldDataType);
                    break;
                }
                case INTEGER: {
                    this.writeInteger((Number)object, fieldDataType);
                    break;
                }
                case OBJECT_ARRAY: {
                    this.writeObjectArray((Object[])object, fieldDataType);
                    break;
                }
                case STRING: {
                    this.writeString((String)object, fieldDataType);
                    break;
                }
                case INSTANT: {
                    this.writeInstant((Instant)object, fieldDataType);
                    break;
                }
                case IDENTIFIED_THING: {
                    this.writeIdentifiedThing((Component)object, fieldDataType);
                    break;
                }
                case COMPONENT_ID_LIST: {
                    this.writeIdList((PublicIdList<PublicId>)((PublicIdList)object), fieldDataType);
                    break;
                }
                case COMPONENT_ID_SET: {
                    this.writeIdSet((PublicIdSet<PublicId>)((PublicIdSet)object), fieldDataType);
                    break;
                }
                case CONCEPT: 
                case CONCEPT_CHRONOLOGY: 
                case PATTERN: 
                case PATTERN_CHRONOLOGY: 
                case SEMANTIC: 
                case SEMANTIC_CHRONOLOGY: {
                    this.writeMarshalableObject((Marshalable)object);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("writeField can't handle: " + String.valueOf(object) + " " + String.valueOf(fieldDataType));
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeIdList(PublicIdList<PublicId> idList, FieldDataType fieldDataType) throws IOException {
        this.writeInt(idList.size());
        idList.forEach(publicId -> {
            this.putInt(publicId.uuidCount());
            publicId.forEach(longValue -> this.putLong(longValue));
        });
    }

    private void writeIdSet(PublicIdSet<PublicId> idSet, FieldDataType fieldDataType) throws IOException {
        this.writeInt(idSet.size());
        idSet.forEach(publicId -> {
            this.putInt(publicId.uuidCount());
            publicId.forEach(longValue -> this.putLong(longValue));
        });
    }

    private void writeInstant(Instant instant, FieldDataType fieldDataType) throws IOException {
        this.writeByte(fieldDataType.token);
        this.writeInstant(instant);
    }

    private void writeIdentifiedThing(Component object, FieldDataType fieldDataType) throws IOException {
        this.writeByte(fieldDataType.token);
        this.putPublicId(object.publicId());
    }

    private void writeMarshalableObject(Marshalable object) throws IOException {
        FieldDataType dataType = FieldDataType.getFieldDataType((Object)object);
        this.writeByte(dataType.token);
        object.marshal(this);
    }

    private void writeString(String object, FieldDataType fieldDataType) throws IOException {
        this.writeByte(fieldDataType.token);
        this.writeUTF(object);
    }

    private void writeObjectArray(Object[] object, FieldDataType fieldDataType) throws IOException {
        this.writeByte(fieldDataType.token);
        Object[] objects = object;
        this.writeInt(objects.length);
        for (int i = 0; i < objects.length; ++i) {
            this.writeField(objects[i]);
        }
    }

    private void writeInteger(Number object, FieldDataType fieldDataType) throws IOException {
        this.writeByte(fieldDataType.token);
        this.writeInt(object.intValue());
    }

    private void writeFloat(Number object, FieldDataType fieldDataType) throws IOException {
        this.writeByte(fieldDataType.token);
        this.writeFloat(object.floatValue());
    }

    private void writeDigraph(DiGraphDTO digraph) throws IOException {
        this.writeByte(FieldDataType.DIGRAPH.token);
        digraph.marshal(this);
    }

    private void writeDitree(DiTreeDTO digree) throws IOException {
        this.writeByte(FieldDataType.DITREE.token);
        digree.marshal(this);
    }

    private void writeByteArray(byte[] object, FieldDataType fieldDataType) throws IOException {
        this.writeByte(fieldDataType.token);
        this.writeInt(object.length);
        this.write(object);
    }

    private void writeBoolean(boolean object, FieldDataType fieldDataType) throws IOException {
        this.writeByte(fieldDataType.token);
        this.writeBoolean(object);
    }

    public void writeUuidList(ImmutableList<UUID> statusUuids) {
        this.writeUuidArray((UUID[])statusUuids.toArray((Object[])new UUID[statusUuids.size()]));
    }

    public void writeVertexId(VertexId vertexId) {
        try {
            this.writeLong(vertexId.mostSignificantBits());
            this.writeLong(vertexId.leastSignificantBits());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void putPublicId(PublicId publicId) {
        try {
            this.writeInt(publicId.uuidCount());
            publicId.forEach(uuidPart -> {
                try {
                    this.writeLong(uuidPart);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void putPublicId(Component component) {
        this.putPublicId(component.publicId());
    }

    public void writeObjectArray(Object[] fields) {
        try {
            this.writeInt(fields.length);
            for (Object object : fields) {
                this.writeField(object);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public void writeObjectList(ImmutableList<Object> fields) {
        this.writeObjectList(fields.castToList());
    }

    public void writeObjectList(List<Object> fields) {
        this.writeObjectArray(fields.toArray());
    }

    public void putInt(int v) {
        try {
            this.writeInt(v);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void putLong(long v) {
        try {
            this.writeLong(v);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

