/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.dto.graph;

import dev.ikm.tinkar.component.graph.DiGraph;
import dev.ikm.tinkar.component.graph.GraphAdaptorFactory;
import dev.ikm.tinkar.dto.binary.Marshalable;
import dev.ikm.tinkar.dto.binary.Marshaler;
import dev.ikm.tinkar.dto.binary.TinkarInput;
import dev.ikm.tinkar.dto.binary.TinkarOutput;
import dev.ikm.tinkar.dto.binary.Unmarshaler;
import dev.ikm.tinkar.dto.graph.GraphDefaults;
import dev.ikm.tinkar.dto.graph.VertexDTO;
import java.io.Serializable;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.procedure.primitive.IntObjectProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.ImmutableIntList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.ImmutableIntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;

public record DiGraphDTO(ImmutableIntList rootSequences, ImmutableIntObjectMap<ImmutableIntList> predecessorMap, ImmutableList<VertexDTO> vertexMap, ImmutableIntObjectMap<ImmutableIntList> successorMap) implements DiGraph<VertexDTO>,
GraphDefaults,
Marshalable
{
    private static final int LOCAL_MARSHAL_VERSION = 3;

    public DiGraph.VertexType vertexType(VertexDTO vertex) {
        throw new UnsupportedOperationException();
    }

    @Unmarshaler
    public static DiGraphDTO make(TinkarInput in) {
        if (3 == in.getTinkerFormatVersion()) {
            ImmutableList<VertexDTO> vertexMap = GraphDefaults.unmarshalVertexMap(in);
            ImmutableIntObjectMap<ImmutableIntList> successorMap = GraphDefaults.unmarshalSuccessorMap(in, vertexMap);
            int rootCount = in.getInt();
            MutableIntList roots = IntLists.mutable.empty();
            for (int i = 0; i < rootCount; ++i) {
                roots.add(in.getInt());
            }
            int predecessorMapSize = in.getInt();
            MutableIntObjectMap predecessorMap = IntObjectMaps.mutable.ofInitialCapacity(predecessorMapSize);
            for (int i = 0; i < predecessorMapSize; ++i) {
                int vertexIndex = in.getInt();
                int predecessorCount = in.getInt();
                MutableIntList predecessorList = IntLists.mutable.empty();
                for (int j = 0; j < predecessorCount; ++j) {
                    predecessorList.add(in.getInt());
                }
                predecessorMap.put(vertexIndex, (Object)predecessorList.toImmutable());
            }
            return new DiGraphDTO(roots.toImmutable(), (ImmutableIntObjectMap<ImmutableIntList>)predecessorMap.toImmutable(), vertexMap, successorMap);
        }
        throw new UnsupportedOperationException("Unsupported version: 3");
    }

    public static Builder builder() {
        return new Builder();
    }

    public <A> A adapt(GraphAdaptorFactory<A> adaptorFactory) {
        throw new UnsupportedOperationException("Adaptors are ephemeral, and are not transfer objects");
    }

    public ImmutableList<VertexDTO> roots() {
        MutableList roots = Lists.mutable.ofInitialCapacity(this.rootSequences.size());
        this.rootSequences.forEach((IntProcedure & Serializable)rootSequence -> roots.add((Object)this.vertex(rootSequence)));
        return roots.toImmutable();
    }

    public ImmutableList<VertexDTO> predecessors(VertexDTO vertex) {
        ImmutableIntList predecessorIntList = (ImmutableIntList)this.predecessorMap.getIfAbsent(vertex.vertexIndex(), (Function0 & Serializable)() -> IntLists.immutable.empty());
        if (predecessorIntList.isEmpty()) {
            return Lists.immutable.empty();
        }
        MutableList predecessorList = Lists.mutable.ofInitialCapacity(predecessorIntList.size());
        predecessorIntList.forEach((IntProcedure & Serializable)vertexSequence -> predecessorList.add((Object)((VertexDTO)this.vertexMap().get(vertexSequence))));
        return predecessorList.toImmutable();
    }

    @Override
    @Marshaler
    public void marshal(TinkarOutput out) {
        this.marshalVertexMap(out);
        this.marshalSuccessorMap(out);
        out.putInt(this.rootSequences.size());
        this.rootSequences.forEach((IntProcedure & Serializable)root -> out.putInt(root));
        out.putInt(this.predecessorMap.size());
        this.predecessorMap.forEachKeyValue((IntObjectProcedure & Serializable)(vertex, predecessorList) -> {
            out.putInt(vertex);
            out.putInt(predecessorList.size());
            predecessorList.forEach((IntProcedure & Serializable)predecessorSequence -> out.putInt(predecessorSequence));
        });
    }

    public static class Builder {
        private final MutableList<VertexDTO> vertexMap = Lists.mutable.empty();
        private final MutableIntObjectMap<MutableIntList> successorMap = IntObjectMaps.mutable.empty();
        private final MutableIntObjectMap<MutableIntList> predecessorMap = IntObjectMaps.mutable.empty();
        private final MutableIntList roots = IntLists.mutable.empty();

        protected Builder() {
        }

        public Builder addRoot(VertexDTO root) {
            this.vertexMap.add(root.vertexIndex(), (Object)root);
            this.roots.add(root.vertexIndex());
            return this;
        }

        public Builder add(VertexDTO child, VertexDTO parent) {
            this.vertexMap.add(child.vertexIndex(), (Object)child);
            ((MutableIntList)this.successorMap.getIfAbsentPut(parent.vertexIndex(), (Object)IntLists.mutable.empty())).add(child.vertexIndex());
            ((MutableIntList)this.predecessorMap.getIfAbsentPut(child.vertexIndex(), (Object)IntLists.mutable.empty())).add(parent.vertexIndex());
            return this;
        }

        public DiGraphDTO build() {
            MutableIntObjectMap intermediateSuccessorMap = IntObjectMaps.mutable.ofInitialCapacity(this.successorMap.size());
            this.successorMap.forEachKeyValue((IntObjectProcedure & Serializable)(vertex, successorList) -> intermediateSuccessorMap.put(vertex, (Object)successorList.toImmutable()));
            MutableIntObjectMap intermediatePredecessorMap = IntObjectMaps.mutable.ofInitialCapacity(this.predecessorMap.size());
            this.predecessorMap.forEachKeyValue((IntObjectProcedure & Serializable)(vertex, predecessorList) -> intermediatePredecessorMap.put(vertex, (Object)predecessorList.toImmutable()));
            return new DiGraphDTO(this.roots.toImmutable(), (ImmutableIntObjectMap<ImmutableIntList>)intermediatePredecessorMap.toImmutable(), (ImmutableList<VertexDTO>)this.vertexMap.toImmutable(), (ImmutableIntObjectMap<ImmutableIntList>)intermediateSuccessorMap.toImmutable());
        }
    }
}

