/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.dto.graph;

import dev.ikm.tinkar.component.graph.DiTree;
import dev.ikm.tinkar.component.graph.GraphAdaptorFactory;
import dev.ikm.tinkar.dto.binary.Marshalable;
import dev.ikm.tinkar.dto.binary.Marshaler;
import dev.ikm.tinkar.dto.binary.TinkarInput;
import dev.ikm.tinkar.dto.binary.TinkarOutput;
import dev.ikm.tinkar.dto.binary.Unmarshaler;
import dev.ikm.tinkar.dto.graph.GraphDefaults;
import dev.ikm.tinkar.dto.graph.VertexDTO;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import org.eclipse.collections.api.block.procedure.primitive.IntIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntObjectProcedure;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.ImmutableIntList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.ImmutableIntIntMap;
import org.eclipse.collections.api.map.primitive.ImmutableIntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntIntMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.factory.primitive.IntIntMaps;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;

public final class DiTreeDTO
extends Record
implements DiTree<VertexDTO>,
GraphDefaults,
Marshalable {
    private final VertexDTO root;
    private final ImmutableIntIntMap predecessorMap;
    private final ImmutableList<VertexDTO> vertexMap;
    private final ImmutableIntObjectMap<ImmutableIntList> successorMap;

    public DiTreeDTO(VertexDTO root, ImmutableIntIntMap predecessorMap, ImmutableList<VertexDTO> vertexMap, ImmutableIntObjectMap<ImmutableIntList> successorMap) {
        this.root = root;
        this.predecessorMap = predecessorMap;
        this.vertexMap = vertexMap;
        this.successorMap = successorMap;
    }

    @Unmarshaler
    public static DiTreeDTO make(TinkarInput in) {
        try {
            if (3 == in.getTinkerFormatVersion()) {
                ImmutableList<VertexDTO> vertexMap = GraphDefaults.unmarshalVertexMap(in);
                ImmutableIntObjectMap<ImmutableIntList> successorMap = GraphDefaults.unmarshalSuccessorMap(in, vertexMap);
                VertexDTO root = (VertexDTO)vertexMap.get(in.getInt());
                int predecessorMapSize = in.readInt();
                MutableIntIntMap predecessorMap = IntIntMaps.mutable.ofInitialCapacity(predecessorMapSize);
                for (int i = 0; i < predecessorMapSize; ++i) {
                    predecessorMap.put(in.getInt(), in.getInt());
                }
                return new DiTreeDTO(root, predecessorMap.toImmutable(), vertexMap, successorMap);
            }
            throw new UnsupportedOperationException("Unsupported version: 3");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Builder builder(VertexDTO root) {
        return new Builder(root);
    }

    public <A> A adapt(GraphAdaptorFactory<A> adaptorFactory) {
        throw new UnsupportedOperationException("Adaptors are ephemeral, and are not transfer objects");
    }

    public Optional<VertexDTO> predecessor(VertexDTO vertex) {
        return Optional.ofNullable((VertexDTO)this.vertexMap().get(this.predecessorMap.get(vertex.vertexIndex())));
    }

    @Override
    @Marshaler
    public void marshal(TinkarOutput out) {
        this.marshalVertexMap(out);
        this.marshalSuccessorMap(out);
        out.putInt(this.root.vertexIndex());
        out.putInt(this.predecessorMap.size());
        this.predecessorMap.forEachKeyValue((IntIntProcedure & Serializable)(vertex, predecessor) -> {
            out.putInt(vertex);
            out.putInt(predecessor);
        });
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{DiTreeDTO.class, "root;predecessorMap;vertexMap;successorMap", "root", "predecessorMap", "vertexMap", "successorMap"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DiTreeDTO.class, "root;predecessorMap;vertexMap;successorMap", "root", "predecessorMap", "vertexMap", "successorMap"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DiTreeDTO.class, "root;predecessorMap;vertexMap;successorMap", "root", "predecessorMap", "vertexMap", "successorMap"}, this, o);
    }

    public VertexDTO root() {
        return this.root;
    }

    public ImmutableIntIntMap predecessorMap() {
        return this.predecessorMap;
    }

    public ImmutableList<VertexDTO> vertexMap() {
        return this.vertexMap;
    }

    public ImmutableIntObjectMap<ImmutableIntList> successorMap() {
        return this.successorMap;
    }

    public static class Builder {
        private final MutableList<VertexDTO> vertexMap = Lists.mutable.empty();
        private final MutableIntObjectMap<MutableIntList> successorMap = IntObjectMaps.mutable.empty();
        private final MutableIntIntMap predecessorMap = IntIntMaps.mutable.empty();
        private final VertexDTO root;

        private Builder(VertexDTO root) {
            this.root = root;
            this.vertexMap.add(this.root.vertexIndex(), (Object)this.root);
        }

        public Builder add(VertexDTO child, VertexDTO parent) {
            this.vertexMap.add(child.vertexIndex(), (Object)child);
            if (!this.successorMap.containsKey(parent.vertexIndex())) {
                this.successorMap.put(parent.vertexIndex(), (Object)IntLists.mutable.empty());
            }
            ((MutableIntList)this.successorMap.get(parent.vertexIndex())).add(child.vertexIndex());
            this.predecessorMap.put(child.vertexIndex(), parent.vertexIndex());
            return this;
        }

        public DiTreeDTO build() {
            MutableIntObjectMap intermediateSuccessorMap = IntObjectMaps.mutable.ofInitialCapacity(this.successorMap.size());
            this.successorMap.forEachKeyValue((IntObjectProcedure & Serializable)(vertex, successorList) -> intermediateSuccessorMap.put(vertex, (Object)successorList.toImmutable()));
            return new DiTreeDTO(this.root, this.predecessorMap.toImmutable(), (ImmutableList<VertexDTO>)this.vertexMap.toImmutable(), (ImmutableIntObjectMap<ImmutableIntList>)intermediateSuccessorMap.toImmutable());
        }
    }
}

