/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.dto.graph;

import dev.ikm.tinkar.component.graph.Graph;
import dev.ikm.tinkar.dto.binary.TinkarInput;
import dev.ikm.tinkar.dto.binary.TinkarOutput;
import dev.ikm.tinkar.dto.graph.VertexDTO;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.procedure.primitive.IntObjectProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.ImmutableIntList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.ImmutableIntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;

public interface GraphDefaults
extends Graph<VertexDTO> {
    public static final int LOCAL_MARSHAL_VERSION = 3;

    public static ImmutableList<VertexDTO> unmarshalVertexMap(TinkarInput in) {
        if (3 == in.getTinkerFormatVersion()) {
            int mapSize = in.getInt();
            MutableList vertexMap = Lists.mutable.ofInitialCapacity(mapSize);
            for (int i = 0; i < mapSize; ++i) {
                VertexDTO vertexDTO = VertexDTO.make(in);
                vertexMap.add((Object)vertexDTO);
            }
            return vertexMap.toImmutable();
        }
        throw new UnsupportedOperationException("Unsupported version: " + in.getTinkerFormatVersion());
    }

    public static ImmutableIntObjectMap<ImmutableIntList> unmarshalSuccessorMap(TinkarInput in, ImmutableList<VertexDTO> vertexMap) {
        if (3 == in.getTinkerFormatVersion()) {
            int mapSize = in.getInt();
            MutableIntObjectMap successorMap = IntObjectMaps.mutable.ofInitialCapacity(mapSize);
            for (int i = 0; i < mapSize; ++i) {
                int vertexSequence = in.getInt();
                int successorListSize = in.getInt();
                MutableIntList successorList = IntLists.mutable.empty();
                for (int j = 0; j < successorListSize; ++j) {
                    successorList.add(in.getInt());
                }
                successorMap.put(vertexSequence, (Object)successorList.toImmutable());
            }
            return successorMap.toImmutable();
        }
        throw new UnsupportedOperationException("Unsupported version: " + in.getTinkerFormatVersion());
    }

    default public VertexDTO vertex(UUID vertexId) {
        for (VertexDTO vertexDTO : this.vertexMap()) {
            if (!vertexDTO.vertexId().asUuid().equals(vertexId)) continue;
            return vertexDTO;
        }
        throw new NoSuchElementException("No vertex for: " + String.valueOf(vertexId));
    }

    default public VertexDTO vertex(int vertexIndex) {
        return (VertexDTO)this.vertexMap().get(vertexIndex);
    }

    default public ImmutableList<VertexDTO> successors(VertexDTO vertex) {
        ImmutableIntList successorIntList = (ImmutableIntList)this.successorMap().getIfAbsent(vertex.vertexIndex(), (Function0 & Serializable)() -> IntLists.immutable.empty());
        if (successorIntList.isEmpty()) {
            return Lists.immutable.empty();
        }
        MutableList successorList = Lists.mutable.ofInitialCapacity(successorIntList.size());
        successorIntList.forEach((IntProcedure & Serializable)vertexSequence -> successorList.add((Object)((VertexDTO)this.vertexMap().get(vertexSequence))));
        return successorList.toImmutable();
    }

    default public void marshalVertexMap(TinkarOutput out) {
        try {
            out.writeInt(this.vertexMap().size());
            for (VertexDTO vertexDTO : this.vertexMap()) {
                vertexDTO.marshal(out);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    default public void marshalSuccessorMap(TinkarOutput out) {
        out.putInt(this.successorMap().size());
        this.successorMap().forEachKeyValue((IntObjectProcedure & Serializable)(vertexSequence, successors) -> {
            out.putInt(vertexSequence);
            out.putInt(successors.size());
            successors.forEach((IntProcedure & Serializable)successorSequence -> out.putInt(successorSequence));
        });
    }
}

