/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.dto.graph;

import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.common.id.VertexId;
import dev.ikm.tinkar.common.id.VertexIds;
import dev.ikm.tinkar.component.Component;
import dev.ikm.tinkar.component.Concept;
import dev.ikm.tinkar.component.Pattern;
import dev.ikm.tinkar.component.Semantic;
import dev.ikm.tinkar.component.Stamp;
import dev.ikm.tinkar.component.graph.Vertex;
import dev.ikm.tinkar.dto.ConceptChronologyDTO;
import dev.ikm.tinkar.dto.ConceptDTO;
import dev.ikm.tinkar.dto.ConceptDTOBuilder;
import dev.ikm.tinkar.dto.PatternChronologyDTO;
import dev.ikm.tinkar.dto.PatternDTO;
import dev.ikm.tinkar.dto.PatternDTOBuilder;
import dev.ikm.tinkar.dto.SemanticChronologyDTO;
import dev.ikm.tinkar.dto.SemanticDTO;
import dev.ikm.tinkar.dto.SemanticDTOBuilder;
import dev.ikm.tinkar.dto.StampDTO;
import dev.ikm.tinkar.dto.StampDTOBuilder;
import dev.ikm.tinkar.dto.binary.Marshalable;
import dev.ikm.tinkar.dto.binary.Marshaler;
import dev.ikm.tinkar.dto.binary.TinkarInput;
import dev.ikm.tinkar.dto.binary.TinkarOutput;
import dev.ikm.tinkar.dto.binary.Unmarshaler;
import dev.ikm.tinkar.dto.graph.VertexDTOBuilder;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;

public final class VertexDTO
extends Record
implements Vertex,
Marshalable {
    private final long vertexIdMsb;
    private final long vertexIdLsb;
    private final int vertexIndex;
    private final ConceptDTO meaning;
    private final ImmutableMap<ConceptDTO, Object> properties;
    private static final int localMarshalVersion = 3;

    public VertexDTO(long vertexIdMsb, long vertexIdLsb, int vertexIndex, ConceptDTO meaning, ImmutableMap<ConceptDTO, Object> properties) {
        this.vertexIdMsb = vertexIdMsb;
        this.vertexIdLsb = vertexIdLsb;
        this.vertexIndex = vertexIndex;
        this.meaning = meaning;
        this.properties = properties;
    }

    public static <T> T abstractObject(Object object) {
        if (object instanceof Concept) {
            Concept conceptValue = (Concept)object;
            if (object instanceof ConceptDTO & !(object instanceof ConceptChronologyDTO)) {
                return (T)object;
            }
            return (T)ConceptDTOBuilder.builder().publicId(conceptValue.publicId()).build();
        }
        if (object instanceof Semantic) {
            Semantic semanticValue = (Semantic)object;
            if (object instanceof SemanticDTO & !(object instanceof SemanticChronologyDTO)) {
                return (T)object;
            }
            return (T)SemanticDTOBuilder.builder().publicId(semanticValue.publicId()).build();
        }
        if (object instanceof Pattern) {
            Pattern patternValue = (Pattern)object;
            if (object instanceof PatternDTO & !(object instanceof PatternChronologyDTO)) {
                return (T)object;
            }
            return (T)PatternDTOBuilder.builder().publicId(patternValue.publicId()).build();
        }
        if (object instanceof Stamp & !(object instanceof StampDTO)) {
            Stamp stampValue = (Stamp)object;
            return (T)StampDTOBuilder.builder().publicId(stampValue.publicId()).statusPublicId(stampValue.state().publicId()).time(stampValue.time()).authorPublicId(stampValue.author().publicId()).modulePublicId(stampValue.module().publicId()).pathPublicId(stampValue.path().publicId()).build();
        }
        if (object instanceof Double) {
            object = Float.valueOf(((Double)object).floatValue());
        } else if (object instanceof Integer) {
            object = ((Integer)object).longValue();
        } else if (object instanceof byte[]) {
            byte[] byteArray = (byte[])object;
            object = new ByteArrayList(byteArray);
        }
        return (T)object;
    }

    public Optional<Concept> propertyAsConcept(Concept propertyConcept) {
        return this.property(propertyConcept);
    }

    public static ImmutableMap<ConceptDTO, Object> abstractProperties(ImmutableMap<ConceptDTO, Object> incoming) {
        MutableMap outgoing = Maps.mutable.ofInitialCapacity(incoming.size());
        incoming.forEachKeyValue((Procedure2 & Serializable)(key, value) -> outgoing.put((Object)((ConceptDTO)VertexDTO.abstractObject(key)), VertexDTO.abstractObject(value)));
        return outgoing.toImmutable();
    }

    public <T> Optional<T> property(Concept propertyConcept) {
        return Optional.ofNullable(this.properties.get((Object)propertyConcept));
    }

    public <T> T propertyFast(Concept propertyConcept) {
        return (T)this.properties.get((Object)propertyConcept);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VertexDTO)) {
            return false;
        }
        VertexDTO vertexDTO = (VertexDTO)o;
        if (this.vertexIdLsb == vertexDTO.vertexIdLsb && this.vertexIdMsb == vertexDTO.vertexIdMsb && this.meaning.equals(vertexDTO.meaning) && this.properties.size() == vertexDTO.properties.size()) {
            for (Concept concept : this.properties.keysView()) {
                Object value1 = this.properties.get((Object)concept);
                Object value2 = this.properties.get((Object)concept);
                if (value1.getClass().equals(value2.getClass())) {
                    if (!(value1.getClass().isArray() ? !VertexDTO.arrayEquals(value1, value2) : !value1.equals(value2))) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean arrayEquals(Object arr1, Object arr2) {
        try {
            Class<Object> c = arr1.getClass();
            if (!c.getComponentType().isPrimitive()) {
                c = Object[].class;
            }
            Method m = Arrays.class.getMethod("equals", c, c);
            return (Boolean)m.invoke(null, arr1, arr2);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.vertexIdMsb, this.vertexIdLsb, this.meaning);
    }

    @Unmarshaler
    public static VertexDTO make(TinkarInput in) {
        if (3 == in.getTinkerFormatVersion()) {
            ImmutableMap immutableProperties;
            UUID vertexUuid = in.getUuid();
            int vertexSequence = in.getInt();
            PublicId meaningId = in.getPublicId();
            int propertyCount = in.getInt();
            if (propertyCount > 0) {
                MutableMap mutableProperties = Maps.mutable.ofInitialCapacity(propertyCount);
                for (int i = 0; i < propertyCount; ++i) {
                    ConceptDTO conceptKey = new ConceptDTO(in.getPublicId());
                    Object object = in.getTinkarNativeObject();
                    mutableProperties.put((Object)conceptKey, object);
                }
                immutableProperties = mutableProperties.toImmutable();
            } else {
                immutableProperties = Maps.immutable.empty();
            }
            return VertexDTOBuilder.builder().vertexIdMsb(vertexUuid.getMostSignificantBits()).vertexIdLsb(vertexUuid.getLeastSignificantBits()).vertexIndex(vertexSequence).meaning(new ConceptDTO(meaningId)).properties((ImmutableMap<ConceptDTO, Object>)immutableProperties).build();
        }
        throw new UnsupportedOperationException("Unsupported version: 3");
    }

    public RichIterable<ConceptDTO> propertyKeys() {
        return this.properties.keysView();
    }

    @Override
    @Marshaler
    public void marshal(TinkarOutput out) {
        out.putLong(this.vertexIdMsb);
        out.putLong(this.vertexIdLsb);
        out.putInt(this.vertexIndex);
        out.putPublicId(this.meaning.publicId());
        out.putInt(this.properties.size());
        this.properties.forEachKeyValue((Procedure2 & Serializable)(conceptKey, object) -> {
            out.putPublicId((Component)conceptKey);
            out.putTinkarNativeObject(object);
        });
    }

    public VertexId vertexId() {
        return VertexIds.of((long)this.vertexIdMsb, (long)this.vertexIdLsb);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{VertexDTO.class, "vertexIdMsb;vertexIdLsb;vertexIndex;meaning;properties", "vertexIdMsb", "vertexIdLsb", "vertexIndex", "meaning", "properties"}, this);
    }

    public long vertexIdMsb() {
        return this.vertexIdMsb;
    }

    public long vertexIdLsb() {
        return this.vertexIdLsb;
    }

    public int vertexIndex() {
        return this.vertexIndex;
    }

    public ConceptDTO meaning() {
        return this.meaning;
    }

    public ImmutableMap<ConceptDTO, Object> properties() {
        return this.properties;
    }
}

