/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.dto.graph;

import dev.ikm.tinkar.dto.ConceptDTO;
import dev.ikm.tinkar.dto.graph.VertexDTO;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.collections.api.map.ImmutableMap;

public class VertexDTOBuilder {
    private long vertexIdMsb;
    private long vertexIdLsb;
    private int vertexIndex;
    private ConceptDTO meaning;
    private ImmutableMap<ConceptDTO, Object> properties;

    private VertexDTOBuilder() {
    }

    private VertexDTOBuilder(long vertexIdMsb, long vertexIdLsb, int vertexIndex, ConceptDTO meaning, ImmutableMap<ConceptDTO, Object> properties) {
        this.vertexIdMsb = vertexIdMsb;
        this.vertexIdLsb = vertexIdLsb;
        this.vertexIndex = vertexIndex;
        this.meaning = meaning;
        this.properties = properties;
    }

    public static VertexDTO VertexDTO(long vertexIdMsb, long vertexIdLsb, int vertexIndex, ConceptDTO meaning, ImmutableMap<ConceptDTO, Object> properties) {
        return new VertexDTO(vertexIdMsb, vertexIdLsb, vertexIndex, meaning, properties);
    }

    public static VertexDTOBuilder builder() {
        return new VertexDTOBuilder();
    }

    public static VertexDTOBuilder builder(VertexDTO from) {
        return new VertexDTOBuilder(from.vertexIdMsb(), from.vertexIdLsb(), from.vertexIndex(), from.meaning(), from.properties());
    }

    public static With from(VertexDTO from) {
        return new _FromWith(from);
    }

    public static Stream<Map.Entry<String, Object>> stream(VertexDTO record) {
        return Stream.of(new AbstractMap.SimpleImmutableEntry<String, Long>("vertexIdMsb", record.vertexIdMsb()), new AbstractMap.SimpleImmutableEntry<String, Long>("vertexIdLsb", record.vertexIdLsb()), new AbstractMap.SimpleImmutableEntry<String, Integer>("vertexIndex", record.vertexIndex()), new AbstractMap.SimpleImmutableEntry<String, ConceptDTO>("meaning", record.meaning()), new AbstractMap.SimpleImmutableEntry<String, ImmutableMap<ConceptDTO, Object>>("properties", record.properties()));
    }

    public VertexDTO build() {
        return new VertexDTO(this.vertexIdMsb, this.vertexIdLsb, this.vertexIndex, this.meaning, this.properties);
    }

    public String toString() {
        return "VertexDTOBuilder[vertexIdMsb=" + this.vertexIdMsb + ", vertexIdLsb=" + this.vertexIdLsb + ", vertexIndex=" + this.vertexIndex + ", meaning=" + String.valueOf(this.meaning) + ", properties=" + String.valueOf(this.properties) + "]";
    }

    public int hashCode() {
        return Objects.hash(this.vertexIdMsb, this.vertexIdLsb, this.vertexIndex, this.meaning, this.properties);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof VertexDTOBuilder)) return false;
        VertexDTOBuilder r = (VertexDTOBuilder)o;
        if (this.vertexIdMsb != r.vertexIdMsb) return false;
        if (this.vertexIdLsb != r.vertexIdLsb) return false;
        if (this.vertexIndex != r.vertexIndex) return false;
        if (!Objects.equals(this.meaning, r.meaning)) return false;
        if (!Objects.equals(this.properties, r.properties)) return false;
        return true;
    }

    public VertexDTOBuilder vertexIdMsb(long vertexIdMsb) {
        this.vertexIdMsb = vertexIdMsb;
        return this;
    }

    public long vertexIdMsb() {
        return this.vertexIdMsb;
    }

    public VertexDTOBuilder vertexIdLsb(long vertexIdLsb) {
        this.vertexIdLsb = vertexIdLsb;
        return this;
    }

    public long vertexIdLsb() {
        return this.vertexIdLsb;
    }

    public VertexDTOBuilder vertexIndex(int vertexIndex) {
        this.vertexIndex = vertexIndex;
        return this;
    }

    public int vertexIndex() {
        return this.vertexIndex;
    }

    public VertexDTOBuilder meaning(ConceptDTO meaning) {
        this.meaning = meaning;
        return this;
    }

    public ConceptDTO meaning() {
        return this.meaning;
    }

    public VertexDTOBuilder properties(ImmutableMap<ConceptDTO, Object> properties) {
        this.properties = properties;
        return this;
    }

    public ImmutableMap<ConceptDTO, Object> properties() {
        return this.properties;
    }

    private static final class _FromWith
    implements With {
        private final VertexDTO from;

        private _FromWith(VertexDTO from) {
            this.from = from;
        }

        @Override
        public long vertexIdMsb() {
            return this.from.vertexIdMsb();
        }

        @Override
        public long vertexIdLsb() {
            return this.from.vertexIdLsb();
        }

        @Override
        public int vertexIndex() {
            return this.from.vertexIndex();
        }

        @Override
        public ConceptDTO meaning() {
            return this.from.meaning();
        }

        @Override
        public ImmutableMap<ConceptDTO, Object> properties() {
            return this.from.properties();
        }
    }

    public static interface With {
        public long vertexIdMsb();

        public long vertexIdLsb();

        public int vertexIndex();

        public ConceptDTO meaning();

        public ImmutableMap<ConceptDTO, Object> properties();

        default public VertexDTOBuilder with() {
            return new VertexDTOBuilder(this.vertexIdMsb(), this.vertexIdLsb(), this.vertexIndex(), this.meaning(), this.properties());
        }

        default public VertexDTO with(Consumer<VertexDTOBuilder> consumer) {
            VertexDTOBuilder builder = this.with();
            consumer.accept(builder);
            return builder.build();
        }

        default public VertexDTO withVertexIdMsb(long vertexIdMsb) {
            return new VertexDTO(vertexIdMsb, this.vertexIdLsb(), this.vertexIndex(), this.meaning(), this.properties());
        }

        default public VertexDTO withVertexIdLsb(long vertexIdLsb) {
            return new VertexDTO(this.vertexIdMsb(), vertexIdLsb, this.vertexIndex(), this.meaning(), this.properties());
        }

        default public VertexDTO withVertexIndex(int vertexIndex) {
            return new VertexDTO(this.vertexIdMsb(), this.vertexIdLsb(), vertexIndex, this.meaning(), this.properties());
        }

        default public VertexDTO withMeaning(ConceptDTO meaning) {
            return new VertexDTO(this.vertexIdMsb(), this.vertexIdLsb(), this.vertexIndex(), meaning, this.properties());
        }

        default public VertexDTO withProperties(ImmutableMap<ConceptDTO, Object> properties) {
            return new VertexDTO(this.vertexIdMsb(), this.vertexIdLsb(), this.vertexIndex(), this.meaning(), properties);
        }
    }
}

