/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.provider.entity;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.auto.service.AutoService;
import dev.ikm.tinkar.common.alert.AlertObject;
import dev.ikm.tinkar.common.alert.AlertStreams;
import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.common.service.CachingService;
import dev.ikm.tinkar.common.service.DefaultDescriptionForNidService;
import dev.ikm.tinkar.common.service.PrimitiveData;
import dev.ikm.tinkar.common.service.PrimitiveDataRepair;
import dev.ikm.tinkar.common.service.PrimitiveDataService;
import dev.ikm.tinkar.common.service.PublicIdService;
import dev.ikm.tinkar.common.service.TinkExecutor;
import dev.ikm.tinkar.common.util.broadcast.Broadcaster;
import dev.ikm.tinkar.common.util.broadcast.SimpleBroadcaster;
import dev.ikm.tinkar.common.util.broadcast.Subscriber;
import dev.ikm.tinkar.common.util.uuid.UuidUtil;
import dev.ikm.tinkar.component.Chronology;
import dev.ikm.tinkar.component.Stamp;
import dev.ikm.tinkar.component.Version;
import dev.ikm.tinkar.entity.ConceptEntity;
import dev.ikm.tinkar.entity.ConceptRecord;
import dev.ikm.tinkar.entity.ConceptRecordBuilder;
import dev.ikm.tinkar.entity.Entity;
import dev.ikm.tinkar.entity.EntityDataRepair;
import dev.ikm.tinkar.entity.EntityMergeServiceFinder;
import dev.ikm.tinkar.entity.EntityRecordFactory;
import dev.ikm.tinkar.entity.EntityService;
import dev.ikm.tinkar.entity.EntityVersion;
import dev.ikm.tinkar.entity.PatternEntity;
import dev.ikm.tinkar.entity.PatternEntityVersion;
import dev.ikm.tinkar.entity.PatternRecord;
import dev.ikm.tinkar.entity.PatternRecordBuilder;
import dev.ikm.tinkar.entity.RecordListBuilder;
import dev.ikm.tinkar.entity.SemanticEntity;
import dev.ikm.tinkar.entity.SemanticEntityVersion;
import dev.ikm.tinkar.entity.SemanticRecord;
import dev.ikm.tinkar.entity.SemanticRecordBuilder;
import dev.ikm.tinkar.entity.StampEntity;
import dev.ikm.tinkar.entity.StampRecord;
import dev.ikm.tinkar.entity.transaction.Transaction;
import dev.ikm.tinkar.terms.ConceptFacade;
import dev.ikm.tinkar.terms.EntityFacade;
import dev.ikm.tinkar.terms.State;
import dev.ikm.tinkar.terms.TinkarTerm;
import java.io.Serializable;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.function.Consumer;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.factory.primitive.IntSets;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.ImmutableIntSet;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityProvider
implements EntityService,
PublicIdService,
DefaultDescriptionForNidService,
EntityDataRepair {
    private static final Logger LOG = LoggerFactory.getLogger(EntityProvider.class);
    private static final Cache<Integer, String> STRING_CACHE = Caffeine.newBuilder().maximumSize(1024L).build();
    private static final Cache<Integer, Entity> ENTITY_CACHE = Caffeine.newBuilder().maximumSize(10240L).build();
    private static final Cache<Integer, StampEntity> STAMP_CACHE = Caffeine.newBuilder().maximumSize(1024L).build();
    final Broadcaster<Integer> processor;

    public EntityProvider() {
        LOG.info("Constructing EntityProvider");
        this.processor = new SimpleBroadcaster();
        this.putEntity((Entity)StampRecord.nonExistentStamp());
    }

    public void addSubscriberWithWeakReference(Subscriber<Integer> subscriber) {
        this.processor.addSubscriberWithWeakReference(subscriber);
    }

    public String textFast(int nid) {
        return (String)STRING_CACHE.get((Object)nid, integer -> {
            int[] semanticNids = PrimitiveData.get().semanticNidsForComponentOfPattern(nid, TinkarTerm.DESCRIPTION_PATTERN.nid());
            Object anyString = null;
            String fqnString = null;
            for (int semanticNid : semanticNids) {
                Entity descriptionSemanticEntity = Entity.getFast((int)semanticNid);
                if (descriptionSemanticEntity instanceof SemanticEntity) {
                    SemanticEntity descriptionSemantic = (SemanticEntity)descriptionSemanticEntity;
                    Entity entity = Entity.getFast((int)descriptionSemantic.patternNid());
                    if (entity instanceof PatternEntity) {
                        PatternEntity pattern = (PatternEntity)entity;
                        PatternEntityVersion patternEntityVersion = (PatternEntityVersion)pattern.versions().get(0);
                        SemanticEntityVersion version = (SemanticEntityVersion)descriptionSemantic.versions().get(0);
                        int indexForMeaning = patternEntityVersion.indexForMeaning((ConceptFacade)TinkarTerm.DESCRIPTION_TYPE);
                        int indexForText = patternEntityVersion.indexForMeaning((ConceptFacade)TinkarTerm.TEXT_FOR_DESCRIPTION);
                        if (version.fieldValues().get(indexForMeaning).equals(TinkarTerm.REGULAR_NAME_DESCRIPTION_TYPE)) {
                            return (String)version.fieldValues().get(indexForText);
                        }
                        if (version.fieldValues().get(indexForMeaning).equals(TinkarTerm.FULLY_QUALIFIED_NAME_DESCRIPTION_TYPE)) {
                            fqnString = (String)version.fieldValues().get(indexForText);
                        }
                        anyString = (String)version.fieldValues().get(indexForText);
                        continue;
                    }
                    anyString = " <" + entity.nid() + ">" + entity.asUuidList().toString();
                    AlertStreams.getRoot().dispatch((Object)AlertObject.makeError((Throwable)new IllegalStateException("Expecting a pattern entity. Found entity with id:  " + (String)anyString)));
                    AlertStreams.getRoot().dispatch((Object)AlertObject.makeError((Throwable)new IllegalStateException("Expecting a pattern entity. Found: " + String.valueOf(entity))));
                    continue;
                }
                anyString = " <" + descriptionSemanticEntity.nid() + "> " + descriptionSemanticEntity.asUuidList().toString();
                LOG.error("ERROR getting string for nid: " + (String)anyString);
                LOG.error("ERROR Nid - 2: <" + (nid - 2) + "> " + String.valueOf(this.getChronology(nid - 2)));
                LOG.error("ERROR Nid - 1: <" + (nid - 1) + "> " + String.valueOf(this.getChronology(nid - 1)));
                LOG.error("ERROR Nid: <" + nid + "> " + String.valueOf(this.getChronology(nid - 1)));
                LOG.error("ERROR Nid + 1: <" + (nid + 1) + "> " + String.valueOf(this.getChronology(nid + 1)));
                LOG.error("ERROR Nid + 2: <" + (nid + 2) + "> " + String.valueOf(this.getChronology(nid + 2)));
                AlertStreams.getRoot().dispatch((Object)AlertObject.makeError((Throwable)new IllegalStateException("Expecting a description semantic entity from list: " + Arrays.toString(semanticNids) + "\n Found entity with id:  " + (String)anyString)));
                AlertStreams.getRoot().dispatch((Object)AlertObject.makeError((Throwable)new IllegalStateException("Expecting a description semantic. Found: " + String.valueOf(descriptionSemanticEntity))));
            }
            if (fqnString != null) {
                return fqnString;
            }
            return anyString;
        });
    }

    public <T extends Chronology<V>, V extends Version> Optional<T> getChronology(int nid) {
        T entity = this.getEntityFast(nid);
        if (entity == null || entity.canceled()) {
            return Optional.empty();
        }
        return Optional.of(entity);
    }

    public int nidForUuids(UUID ... uuids) {
        return PrimitiveData.get().nidForUuids(uuids);
    }

    public int nidForPublicId(PublicId publicId) {
        return PrimitiveData.get().nidForUuids(publicId.asUuidArray());
    }

    public <T extends Entity<V>, V extends EntityVersion> T getEntityFast(int nid) {
        return (T)((Entity)ENTITY_CACHE.get((Object)nid, entityNid -> {
            byte[] bytes = PrimitiveData.get().getBytes(nid);
            if (bytes == null) {
                return null;
            }
            return EntityRecordFactory.make((byte[])bytes);
        }));
    }

    public int nidForUuids(ImmutableList<UUID> uuidList) {
        return PrimitiveData.get().nidForUuids(uuidList);
    }

    public StampEntity getStampFast(int nid) {
        return (StampEntity)STAMP_CACHE.get((Object)nid, stampNid -> {
            byte[] bytes = PrimitiveData.get().getBytes(nid);
            if (bytes == null) {
                return null;
            }
            return (StampEntity)EntityRecordFactory.make((byte[])bytes);
        });
    }

    public void putEntity(Entity entity) {
        SemanticEntity semanticEntity;
        this.invalidateCaches(entity);
        ENTITY_CACHE.put((Object)entity.nid(), (Object)entity);
        if (entity instanceof StampEntity) {
            StampEntity stampEntity = (StampEntity)entity;
            STAMP_CACHE.put((Object)stampEntity.nid(), (Object)stampEntity);
            if (stampEntity.lastVersion().stateNid() == State.CANCELED.nid()) {
                PrimitiveData.get().addCanceledStampNid(stampEntity.nid());
            }
        }
        if (entity instanceof SemanticEntity) {
            semanticEntity = (SemanticEntity)entity;
            PrimitiveData.get().merge(entity.nid(), semanticEntity.patternNid(), semanticEntity.referencedComponentNid(), entity.getBytes(), (Object)entity);
        } else {
            PrimitiveData.get().merge(entity.nid(), Integer.MAX_VALUE, Integer.MAX_VALUE, entity.getBytes(), (Object)entity);
        }
        this.processor.dispatch((Object)entity.nid());
        if (entity instanceof SemanticEntity) {
            semanticEntity = (SemanticEntity)entity;
            this.processor.dispatch((Object)semanticEntity.referencedComponentNid());
        }
    }

    public void putEntityQuietly(Entity entity) {
        this.invalidateCaches(entity);
        ENTITY_CACHE.put((Object)entity.nid(), (Object)entity);
        if (entity instanceof StampEntity) {
            StampEntity stampEntity = (StampEntity)entity;
            STAMP_CACHE.put((Object)stampEntity.nid(), (Object)stampEntity);
            if (stampEntity.lastVersion().stateNid() == State.CANCELED.nid()) {
                PrimitiveData.get().addCanceledStampNid(stampEntity.nid());
            }
        }
        if (entity instanceof SemanticEntity) {
            SemanticEntity semanticEntity = (SemanticEntity)entity;
            PrimitiveData.get().merge(entity.nid(), semanticEntity.patternNid(), semanticEntity.referencedComponentNid(), entity.getBytes(), (Object)entity);
        } else {
            PrimitiveData.get().merge(entity.nid(), Integer.MAX_VALUE, Integer.MAX_VALUE, entity.getBytes(), (Object)entity);
        }
    }

    public void putStamp(StampEntity stampEntity) {
        this.putEntity((Entity)stampEntity);
    }

    public void invalidateCaches(Entity entity) {
        this.invalidateCaches(entity.nid());
        if (entity instanceof SemanticEntity) {
            SemanticEntity semanticEntity = (SemanticEntity)entity;
            this.invalidateCaches(semanticEntity.referencedComponentNid(), semanticEntity.patternNid());
            Object parent = this.getEntityFast(semanticEntity.referencedComponentNid());
            block5: while (parent != null) {
                Object t;
                Objects.requireNonNull(parent);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConceptEntity.class, PatternEntity.class, SemanticEntity.class}, t, n)) {
                    case 0: {
                        ConceptEntity conceptEntity = (ConceptEntity)t;
                        parent = null;
                        STRING_CACHE.invalidate((Object)conceptEntity.nid());
                        continue block5;
                    }
                    case 1: {
                        PatternEntity patternEntity = (PatternEntity)t;
                        parent = null;
                        STRING_CACHE.invalidate((Object)patternEntity.nid());
                        continue block5;
                    }
                    case 2: {
                        SemanticEntity semantic = (SemanticEntity)t;
                        parent = this.getEntityFast(semantic.referencedComponentNid());
                        STRING_CACHE.invalidate((Object)semantic.nid());
                        continue block5;
                    }
                }
                throw new IllegalStateException("Unexpected value: " + String.valueOf(parent));
            }
        }
    }

    public void invalidateCaches(int ... nids) {
        for (int nid : nids) {
            STRING_CACHE.invalidate((Object)nid);
            ENTITY_CACHE.invalidate((Object)nid);
            STAMP_CACHE.invalidate((Object)nid);
        }
    }

    public Entity unmarshalChronology(byte[] bytes) {
        return EntityRecordFactory.make((byte[])bytes);
    }

    public void forEachSemanticOfPattern(int patternNid, Consumer<SemanticEntity<SemanticEntityVersion>> procedure) {
        PrimitiveData.get().forEachSemanticNidOfPattern(patternNid, (IntProcedure & Serializable)nid -> procedure.accept((SemanticEntity)this.getEntityFast(nid)));
    }

    public int[] semanticNidsOfPattern(int patternNid) {
        return PrimitiveData.get().semanticNidsOfPattern(patternNid);
    }

    public void forEachSemanticForComponent(int componentNid, Consumer<SemanticEntity<SemanticEntityVersion>> procedure) {
        PrimitiveData.get().forEachSemanticNidForComponent(componentNid, (IntProcedure & Serializable)nid -> procedure.accept((SemanticEntity)this.getEntityFast(nid)));
    }

    public int[] semanticNidsForComponent(int componentNid) {
        return PrimitiveData.get().semanticNidsForComponent(componentNid);
    }

    public void forEachSemanticForComponentOfPattern(int componentNid, int patternNid, Consumer<SemanticEntity<SemanticEntityVersion>> procedure) {
        PrimitiveData.get().forEachSemanticNidForComponentOfPattern(componentNid, patternNid, (IntProcedure & Serializable)nid -> procedure.accept((SemanticEntity)this.getEntityFast(nid)));
    }

    public int[] semanticNidsForComponentOfPattern(int componentNid, int patternNid) {
        return PrimitiveData.get().semanticNidsForComponentOfPattern(componentNid, patternNid);
    }

    public void notifyRefreshRequired(Transaction transaction) {
        transaction.forEachComponentInTransaction(nid -> {
            Entity.get((int)nid).ifPresent(entity -> this.invalidateCaches((Entity)entity));
            this.processor.dispatch(nid);
        });
    }

    public PublicId publicId(int nid) {
        return this.getEntityFast(nid).publicId();
    }

    public <T extends Chronology<V>, V extends Version> Optional<T> getChronology(PublicId publicId) {
        T entity;
        if (publicId instanceof EntityFacade) {
            EntityFacade entityFacade = (EntityFacade)publicId;
            entity = this.getEntityFast(entityFacade.nid());
        } else {
            entity = this.getEntityFast(this.nidForPublicId(publicId));
        }
        if (entity == null || entity.canceled()) {
            return Optional.empty();
        }
        return Optional.of(entity);
    }

    public <T extends Chronology<V>, V extends Version> void putChronology(T chronology) {
        if (chronology instanceof Entity) {
            Entity entity = (Entity)chronology;
            this.putEntity(entity);
        } else {
            this.putEntity(EntityRecordFactory.make(chronology));
            for (Version version : chronology.versions()) {
                Stamp stamp = version.stamp();
                int nid = PrimitiveData.get().nidForUuids(stamp.publicId().asUuidArray());
                if (PrimitiveData.get().getBytes(nid) != null) continue;
                this.putEntity(EntityRecordFactory.make((Chronology)stamp));
            }
        }
    }

    public void dispatch(Integer item) {
        this.processor.dispatch((Object)item);
    }

    public void removeSubscriber(Subscriber<Integer> subscriber) {
        this.processor.removeSubscriber(subscriber);
    }

    public void erase(Entity entity) {
        PrimitiveDataService primitiveDataService = PrimitiveData.get();
        if (!(primitiveDataService instanceof PrimitiveDataRepair)) {
            throw new UnsupportedOperationException("PrimitiveDataRepair is not supported by: " + PrimitiveData.get().getClass().getName());
        }
        PrimitiveDataRepair primitiveDataRepair = (PrimitiveDataRepair)primitiveDataService;
        primitiveDataRepair.erase(entity.nid());
    }

    public Future<Entity> mergeThenErase(Entity entityToMergeInto, Entity entityToErase) {
        if (entityToMergeInto.getClass().equals(entityToMergeInto.getClass())) {
            PrimitiveDataService primitiveDataService = PrimitiveData.get();
            if (primitiveDataService instanceof PrimitiveDataRepair) {
                PrimitiveDataRepair primitiveDataRepair = (PrimitiveDataRepair)primitiveDataService;
                FutureTask<Entity> mergeThenEraseTask = new FutureTask<Entity>(() -> {
                    Future<Entity> mergedEntity = EntityProvider.mergeEntities(entityToMergeInto, entityToErase);
                    Entity entityToKeep = mergedEntity.get();
                    this.erase(entityToErase);
                    primitiveDataRepair.put(entityToMergeInto.nid(), mergedEntity.get().getBytes());
                    return entityToKeep;
                });
                return TinkExecutor.threadPool().submit(mergeThenEraseTask);
            }
            throw new UnsupportedOperationException("PrimitiveDataRepair is not supported by: " + PrimitiveData.get().getClass().getName());
        }
        throw new IllegalStateException("Cannot merge entities of different types: \n" + String.valueOf(entityToErase) + "\n\n" + String.valueOf(entityToMergeInto));
    }

    private static Future<Entity> mergeEntities(Entity<?> entityToMergeInto, Entity<?> entityToMergeFrom) {
        Future<Entity> future;
        ImmutableIntSet entityOneStampNidSet = IntSets.immutable.ofAll(entityToMergeInto.versions().stream().mapToInt(version -> version.stampNid()));
        ImmutableIntSet entityTwoStampNidSet = IntSets.immutable.ofAll(entityToMergeFrom.versions().stream().mapToInt(version -> version.stampNid()));
        ImmutableIntSet stampDifferenceNids = entityOneStampNidSet.difference((IntSet)entityTwoStampNidSet);
        ImmutableIntSet stampUnionNids = entityOneStampNidSet.intersect((IntSet)entityTwoStampNidSet);
        ImmutableIntSet allStampNids = stampDifferenceNids.newWithAll((IntIterable)stampUnionNids);
        for (int unionStamp : stampUnionNids.toArray()) {
            if (entityToMergeInto.getVersion(unionStamp).equals(entityToMergeFrom.getVersion(unionStamp))) continue;
            return EntityMergeServiceFinder.adjudicatedMerge(entityToMergeInto, (Entity[])new Entity[]{entityToMergeFrom});
        }
        if (stampDifferenceNids.isEmpty()) {
            return new FutureTask<Entity>(() -> entityToMergeInto);
        }
        for (int differenceStampNid : stampDifferenceNids.toArray()) {
            StampEntity differenceStamp = EntityService.get().getStampFast(differenceStampNid);
            for (int anyStampNid : allStampNids.toArray()) {
                if (differenceStampNid == anyStampNid) continue;
                StampEntity anyStamp = EntityService.get().getStampFast(anyStampNid);
                if (differenceStamp.time() != anyStamp.time() || differenceStamp.moduleNid() != anyStamp.moduleNid() || differenceStamp.pathNid() != anyStamp.pathNid()) continue;
                return EntityMergeServiceFinder.adjudicatedMerge(entityToMergeInto, (Entity[])new Entity[]{entityToMergeFrom});
            }
        }
        Entity<?> entity = entityToMergeInto;
        Objects.requireNonNull(entity);
        Entity<?> entity2 = entity;
        int n = 0;
        block8: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConceptRecord.class, PatternRecord.class, SemanticRecord.class}, entity2, n)) {
                case 0: {
                    ConceptRecord conceptOneRecord = (ConceptRecord)entity2;
                    if (!(entityToMergeFrom instanceof ConceptRecord)) {
                        n = 1;
                        continue block8;
                    }
                    ConceptRecord conceptTwoRecord = (ConceptRecord)entityToMergeFrom;
                    future = EntityProvider.mergeAllConceptVersions(conceptOneRecord, conceptTwoRecord);
                    break block8;
                }
                case 1: {
                    PatternRecord patternOneRecord = (PatternRecord)entity2;
                    if (!(entityToMergeFrom instanceof PatternRecord)) {
                        n = 2;
                        continue block8;
                    }
                    PatternRecord patternTwoRecord = (PatternRecord)entityToMergeFrom;
                    future = EntityProvider.mergeAllPatternVersions(patternOneRecord, patternTwoRecord);
                    break block8;
                }
                case 2: {
                    SemanticRecord semanticOneRecord = (SemanticRecord)entity2;
                    if (!(entityToMergeFrom instanceof SemanticRecord)) {
                        n = 3;
                        continue block8;
                    }
                    SemanticRecord semanticTwoRecord = (SemanticRecord)entityToMergeFrom;
                    future = EntityProvider.mergeAllSemanticVersions(semanticOneRecord, semanticTwoRecord);
                    break block8;
                }
                default: {
                    throw new IllegalStateException("Can't merge:\n" + String.valueOf(entityToMergeInto) + "\nand:\n" + String.valueOf(entityToMergeFrom));
                }
            }
            break;
        }
        return future;
    }

    private static Future<Entity> mergeAllPatternVersions(PatternRecord patternOneRecord, PatternRecord patternTwoRecord) {
        RecordListBuilder versionList = RecordListBuilder.make();
        patternOneRecord.versions().forEach((Procedure & Serializable)versionRecord -> versionList.add(versionRecord));
        patternTwoRecord.versions().forEach((Procedure & Serializable)versionRecord -> versionList.add(versionRecord));
        MutableSet additionalUuids = Sets.mutable.ofAll((Iterable)patternOneRecord.asUuidList());
        additionalUuids.addAll((Collection)patternTwoRecord.asUuidList().castToList());
        additionalUuids.remove((Object)new UUID(patternOneRecord.mostSignificantBits(), patternOneRecord.leastSignificantBits()));
        long[] additionalUuidLongs = null;
        if (additionalUuids.notEmpty()) {
            additionalUuidLongs = UuidUtil.asArray((UUID[])((UUID[])additionalUuids.toArray((Object[])new UUID[additionalUuids.size()])));
        }
        PatternRecordBuilder builder = patternOneRecord.with().versions((ImmutableList)versionList).additionalUuidLongs(additionalUuidLongs);
        return new FutureTask<Entity>(() -> builder.build());
    }

    private static Future<Entity> mergeAllSemanticVersions(SemanticRecord semanticOneRecord, SemanticRecord semanticTwoRecord) {
        RecordListBuilder versionList = RecordListBuilder.make();
        semanticOneRecord.versions().forEach((Procedure & Serializable)versionRecord -> versionList.add(versionRecord));
        semanticTwoRecord.versions().forEach((Procedure & Serializable)versionRecord -> versionList.add(versionRecord));
        MutableSet additionalUuids = Sets.mutable.ofAll((Iterable)semanticOneRecord.asUuidList());
        additionalUuids.addAll((Collection)semanticTwoRecord.asUuidList().castToList());
        additionalUuids.remove((Object)new UUID(semanticOneRecord.mostSignificantBits(), semanticOneRecord.leastSignificantBits()));
        long[] additionalUuidLongs = null;
        if (additionalUuids.notEmpty()) {
            additionalUuidLongs = UuidUtil.asArray((UUID[])((UUID[])additionalUuids.toArray((Object[])new UUID[additionalUuids.size()])));
        }
        SemanticRecordBuilder builder = semanticOneRecord.with().versions((ImmutableList)versionList).additionalUuidLongs(additionalUuidLongs);
        return new FutureTask<Entity>(() -> builder.build());
    }

    private static FutureTask<Entity> mergeAllConceptVersions(ConceptRecord conceptOneRecord, ConceptRecord conceptTwoRecord) {
        RecordListBuilder versionList = RecordListBuilder.make();
        conceptOneRecord.versions().forEach((Procedure & Serializable)conceptVersionRecord -> versionList.add(conceptVersionRecord));
        conceptTwoRecord.versions().forEach((Procedure & Serializable)conceptVersionRecord -> versionList.add(conceptVersionRecord));
        MutableSet additionalUuids = Sets.mutable.ofAll((Iterable)conceptOneRecord.asUuidList());
        additionalUuids.addAll((Collection)conceptTwoRecord.asUuidList().castToList());
        additionalUuids.remove((Object)new UUID(conceptOneRecord.mostSignificantBits(), conceptOneRecord.leastSignificantBits()));
        long[] additionalUuidLongs = null;
        if (additionalUuids.notEmpty()) {
            additionalUuidLongs = UuidUtil.asArray((UUID[])((UUID[])additionalUuids.toArray((Object[])new UUID[additionalUuids.size()])));
        }
        ConceptRecordBuilder builder = conceptOneRecord.with().versions((ImmutableList)versionList).additionalUuidLongs(additionalUuidLongs);
        return new FutureTask<Entity>(() -> builder.build());
    }

    @AutoService(value={CachingService.class})
    public static class CacheProvider
    implements CachingService {
        public void reset() {
            LOG.info("Resetting Entity Caches");
            STRING_CACHE.invalidateAll();
            ENTITY_CACHE.invalidateAll();
            STAMP_CACHE.invalidateAll();
        }
    }
}

