/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.provider.entity;

import com.google.auto.service.AutoService;
import dev.ikm.tinkar.common.id.IntIdSet;
import dev.ikm.tinkar.common.id.IntIds;
import dev.ikm.tinkar.common.service.PrimitiveData;
import dev.ikm.tinkar.common.util.broadcast.Subscriber;
import dev.ikm.tinkar.component.FieldDataType;
import dev.ikm.tinkar.entity.Entity;
import dev.ikm.tinkar.entity.EntityRecordFactory;
import dev.ikm.tinkar.entity.EntityService;
import dev.ikm.tinkar.entity.StampEntity;
import dev.ikm.tinkar.entity.StampService;
import dev.ikm.tinkar.entity.util.EntityProcessor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.ObjIntConsumer;
import org.eclipse.collections.api.list.primitive.ImmutableLongList;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={StampService.class})
public class StampProvider
extends EntityProcessor
implements StampService,
Subscriber<Integer> {
    private static final Logger LOG = LoggerFactory.getLogger(StampProvider.class);
    final ConcurrentHashMap<Integer, StampEntity> stamps = new ConcurrentHashMap();
    final ConcurrentSkipListSet<Long> times = new ConcurrentSkipListSet();
    final ConcurrentSkipListSet<Integer> authors = new ConcurrentSkipListSet();
    final ConcurrentSkipListSet<Integer> modules = new ConcurrentSkipListSet();
    final ConcurrentSkipListSet<Integer> paths = new ConcurrentSkipListSet();
    final ConcurrentSkipListSet<Integer> stampNids = new ConcurrentSkipListSet();

    public StampProvider() {
        EntityService.get().addSubscriberWithWeakReference((Subscriber)this);
        PrimitiveData.get().forEachParallel((ObjIntConsumer)((Object)this));
    }

    public void processBytesForType(FieldDataType componentType, byte[] bytes) {
        if (componentType == FieldDataType.STAMP) {
            StampEntity stampEntity = (StampEntity)EntityRecordFactory.make((byte[])bytes);
            this.stamps.put(stampEntity.nid(), stampEntity);
            this.times.add(stampEntity.time());
            this.authors.add(stampEntity.authorNid());
            this.modules.add(stampEntity.moduleNid());
            this.paths.add(stampEntity.pathNid());
            this.stampNids.add(stampEntity.nid());
        }
    }

    public IntIdSet stampNids() {
        return IntIds.set.of(this.stampNids.stream().mapToInt(wrappedPath -> wrappedPath).toArray());
    }

    public ImmutableLongList timesInUse() {
        return LongLists.immutable.of(this.times.stream().mapToLong(wrappedTime -> wrappedTime).toArray());
    }

    public IntIdSet getAuthorNidsInUse() {
        return IntIds.set.of(this.authors, nid -> nid);
    }

    public IntIdSet getModuleNidsInUse() {
        return IntIds.set.of(this.modules, nid -> nid);
    }

    public IntIdSet getPathNidsInUse() {
        return IntIds.set.of(this.paths, nid -> nid);
    }

    public ImmutableLongList getTimesInUse() {
        return LongLists.immutable.ofAll(this.times);
    }

    public void onNext(Integer nid) {
        Entity entity = Entity.provider().getEntityFast(nid.intValue());
        if (entity instanceof StampEntity) {
            StampEntity stampEntity = (StampEntity)entity;
            this.stamps.put(stampEntity.nid(), stampEntity);
            this.times.add(stampEntity.time());
            this.authors.add(stampEntity.authorNid());
            this.modules.add(stampEntity.moduleNid());
            this.paths.add(stampEntity.pathNid());
            this.stampNids.add(stampEntity.nid());
        }
    }
}

