/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.reasoner.elksnomed;

import dev.ikm.elk.snomed.model.Concept;
import dev.ikm.elk.snomed.model.RoleType;
import dev.ikm.tinkar.common.service.PrimitiveData;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.eclipse.collections.api.list.primitive.ImmutableIntList;
import org.eclipse.collections.impl.factory.primitive.IntLists;

public class ElkSnomedData {
    private final ConcurrentHashMap<Integer, Concept> nidConceptMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, RoleType> nidRoleTypeMap = new ConcurrentHashMap();
    private final AtomicInteger activeConceptCount = new AtomicInteger();
    private final AtomicInteger inactiveConceptCount = new AtomicInteger();
    private ImmutableIntList reasonerConceptSet;

    public Collection<Concept> getConcepts() {
        return Collections.unmodifiableCollection(this.nidConceptMap.values());
    }

    public Collection<RoleType> getRoleTypes() {
        return Collections.unmodifiableCollection(this.nidRoleTypeMap.values());
    }

    public RoleType getOrCreateRoleType(int roleNid) {
        return this.nidRoleTypeMap.computeIfAbsent(roleNid, RoleType::new);
    }

    public Concept getOrCreateConcept(int conceptNid) {
        return this.nidConceptMap.computeIfAbsent(conceptNid, Concept::new);
    }

    public int getActiveConceptCount() {
        return this.activeConceptCount.get();
    }

    public int incrementActiveConceptCount() {
        return this.activeConceptCount.incrementAndGet();
    }

    public int getInactiveConceptCount() {
        return this.inactiveConceptCount.get();
    }

    public int incrementInactiveConceptCount() {
        return this.inactiveConceptCount.incrementAndGet();
    }

    public ImmutableIntList getReasonerConceptSet() {
        return this.reasonerConceptSet;
    }

    public void initializeReasonerConceptSet() {
        IntStream conceptNids = this.nidConceptMap.entrySet().stream().mapToInt(es -> (Integer)es.getKey()).sorted();
        this.reasonerConceptSet = IntLists.immutable.ofAll(conceptNids);
    }

    public void writeConcepts(Path path) throws Exception {
        Files.write(path, this.nidConceptMap.keySet().stream().map(key -> String.valueOf(PrimitiveData.publicId((int)key).asUuidArray()[0]) + "\t" + PrimitiveData.text((int)key)).sorted().toList(), new OpenOption[0]);
    }

    public void writeRoleTypes(Path path) throws Exception {
        Files.write(path, this.nidRoleTypeMap.keySet().stream().map(key -> String.valueOf(PrimitiveData.publicId((int)key).asUuidArray()[0]) + "\t" + PrimitiveData.text((int)key)).sorted().toList(), new OpenOption[0]);
    }
}

