/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.reasoner.elksnomed;

import dev.ikm.elk.snomed.model.Concept;
import dev.ikm.elk.snomed.model.Definition;
import dev.ikm.elk.snomed.model.DefinitionType;
import dev.ikm.elk.snomed.model.Role;
import dev.ikm.elk.snomed.model.RoleGroup;
import dev.ikm.elk.snomed.model.RoleType;
import dev.ikm.tinkar.common.id.IntIdList;
import dev.ikm.tinkar.common.service.PrimitiveData;
import dev.ikm.tinkar.common.service.TrackingCallable;
import dev.ikm.tinkar.coordinate.logic.LogicCoordinateRecord;
import dev.ikm.tinkar.coordinate.view.calculator.ViewCalculator;
import dev.ikm.tinkar.entity.graph.DiTreeEntity;
import dev.ikm.tinkar.entity.graph.EntityVertex;
import dev.ikm.tinkar.entity.graph.adaptor.axiom.LogicalAxiomSemantic;
import dev.ikm.tinkar.reasoner.elksnomed.ElkSnomedData;
import dev.ikm.tinkar.terms.ConceptFacade;
import dev.ikm.tinkar.terms.EntityProxy;
import dev.ikm.tinkar.terms.PatternFacade;
import dev.ikm.tinkar.terms.TinkarTerm;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.list.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElkSnomedDataBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ElkSnomedDataBuilder.class);
    private final ViewCalculator viewCalculator;
    private final PatternFacade statedAxiomPattern;
    private final ElkSnomedData data;
    private TrackingCallable<?> progressUpdater = null;

    public ElkSnomedDataBuilder(ViewCalculator viewCalculator, PatternFacade statedAxiomPattern, ElkSnomedData data) {
        this.viewCalculator = viewCalculator;
        this.statedAxiomPattern = statedAxiomPattern;
        this.data = data;
    }

    public void setProgressUpdater(TrackingCallable<?> progressUpdater) {
        this.progressUpdater = progressUpdater;
    }

    private void updateProgress(int count, int total) {
        if (this.progressUpdater != null && count % 100 == 0) {
            this.progressUpdater.updateProgress((long)count, (long)total);
        }
    }

    private int computeTotalCount() {
        AtomicInteger totalCounter = new AtomicInteger();
        PrimitiveData.get().forEachSemanticNidOfPattern(this.statedAxiomPattern.nid(), (IntProcedure & Serializable)i -> totalCounter.incrementAndGet());
        return totalCounter.get();
    }

    public void build() throws Exception {
        int totalCount = this.computeTotalCount();
        LOG.info("Total axioms: " + totalCount);
        this.updateProgress(0, totalCount);
        AtomicInteger processedCount = new AtomicInteger();
        LogicCoordinateRecord logicCoordinate = this.viewCalculator.logicCalculator().logicCoordinateRecord();
        this.viewCalculator.forEachSemanticVersionOfPatternParallel(logicCoordinate.statedAxiomsPatternNid(), (semanticEntityVersion, patternEntityVersion) -> {
            int conceptNid = semanticEntityVersion.referencedComponentNid();
            if (this.viewCalculator.latestIsActive(conceptNid)) {
                DiTreeEntity definition = (DiTreeEntity)semanticEntityVersion.fieldValues().get(0);
                this.processDefinition(definition, conceptNid);
                this.data.incrementActiveConceptCount();
            } else {
                this.data.incrementInactiveConceptCount();
            }
            this.updateProgress(processedCount.incrementAndGet(), totalCount);
        });
        this.data.initializeReasonerConceptSet();
        for (Concept con : this.data.getConcepts()) {
            if (!con.getDefinitions().isEmpty()) continue;
            LOG.warn("No definitions: " + con.getId() + " " + PrimitiveData.text((int)((int)con.getId())));
        }
        this.updateProgress(totalCount, totalCount);
        LOG.info("Total processed: " + totalCount + " " + processedCount.get());
        LOG.info("Active concepts: " + this.data.getActiveConceptCount());
        LOG.info("Inactive concepts: " + this.data.getInactiveConceptCount());
    }

    public Concept processIncremental(DiTreeEntity definition, int conceptNid) {
        Concept concept = this.data.getOrCreateConcept(conceptNid);
        concept.removeAllDefinitions();
        concept.removeAllGciDefinitions();
        this.processDefinition(definition, conceptNid);
        return concept;
    }

    private LogicalAxiomSemantic getMeaning(EntityVertex node) {
        return LogicalAxiomSemantic.get((int)node.getMeaningNid());
    }

    private int getNid(EntityVertex node, EntityProxy.Concept concept) {
        ConceptFacade cf = (ConceptFacade)node.propertyFast((ConceptFacade)concept);
        return cf.nid();
    }

    private void processDefinition(DiTreeEntity definition, int conceptNid) throws IllegalStateException {
        EntityVertex root = definition.root();
        block5: for (EntityVertex child : definition.successors(root)) {
            switch (this.getMeaning(child)) {
                case SUFFICIENT_SET: {
                    Concept concept = this.data.getOrCreateConcept(conceptNid);
                    Definition def = new Definition();
                    def.setDefinitionType(DefinitionType.EquivalentConcept);
                    this.processDefinition(def, child, definition);
                    concept.addDefinition(def);
                    continue block5;
                }
                case NECESSARY_SET: {
                    Concept concept = this.data.getOrCreateConcept(conceptNid);
                    Definition def = new Definition();
                    def.setDefinitionType(DefinitionType.SubConcept);
                    this.processDefinition(def, child, definition);
                    concept.addDefinition(def);
                    continue block5;
                }
                case PROPERTY_SET: {
                    this.processPropertySet(child, conceptNid, definition);
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Unexpected value: " + String.valueOf(this.getMeaning(child)));
        }
    }

    private void processDefinition(Definition def, EntityVertex node, DiTreeEntity definition) {
        ImmutableList children = definition.successors(node);
        if (children.size() != 1) {
            throw new IllegalStateException("Definitions require a single child: " + String.valueOf(definition));
        }
        EntityVertex child = (EntityVertex)children.getFirst();
        switch (this.getMeaning(child)) {
            case AND: {
                this.processAnd(def, child, definition);
                break;
            }
            case CONCEPT: {
                int nid = this.getNid(child, TinkarTerm.CONCEPT_REFERENCE);
                def.addSuperConcept(this.data.getOrCreateConcept(nid));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + String.valueOf(this.getMeaning(child)));
            }
        }
    }

    private void processPropertySet(EntityVertex propertySetNode, int conceptNid, DiTreeEntity definition) {
        LOG.info("PropertySet: " + String.valueOf(propertySetNode) + " " + String.valueOf(definition));
        ImmutableList children = definition.successors(propertySetNode);
        if (children.size() != 1) {
            throw new IllegalStateException("PropertySetNode can only have one child. Concept: " + conceptNid + " definition: " + String.valueOf(definition));
        }
        EntityVertex child = (EntityVertex)children.getFirst();
        if (child.getMeaningNid() != TinkarTerm.AND.nid()) {
            throw new IllegalStateException("PropertySetNode can only have AND for a child. Concept: " + conceptNid + " definition: " + String.valueOf(definition));
        }
        block4: for (EntityVertex node : definition.successors(child)) {
            switch (this.getMeaning(node)) {
                case CONCEPT: {
                    ConceptFacade nodeConcept = (ConceptFacade)node.propertyFast((ConceptFacade)TinkarTerm.CONCEPT_REFERENCE);
                    this.data.getOrCreateRoleType(conceptNid).addSuperRoleType(this.data.getOrCreateRoleType(nodeConcept.nid()));
                    continue block4;
                }
                case PROPERTY_PATTERN_IMPLICATION: {
                    IntIdList ps = (IntIdList)node.propertyFast((ConceptFacade)TinkarTerm.PROPERTY_SET);
                    List<RoleType> chain = ps.intStream().mapToObj(x -> this.data.getOrCreateRoleType(x)).toList();
                    if (chain.size() != 2) {
                        throw new IllegalStateException("Property chain != 2. Concept: " + conceptNid + " definition: " + String.valueOf(definition));
                    }
                    if (chain.getFirst().getId() != (long)conceptNid) {
                        throw new IllegalStateException("Property chain not supported. Concept: " + conceptNid + " definition: " + String.valueOf(definition));
                    }
                    chain.get(0).setChained(chain.get(1));
                    continue block4;
                }
            }
            throw new UnsupportedOperationException("Can't handle: " + String.valueOf(node) + " in: " + String.valueOf(definition));
        }
    }

    private void processAnd(Definition def, EntityVertex node, DiTreeEntity definition) {
        ImmutableList children = definition.successors(node);
        for (EntityVertex child : children) {
            switch (this.getMeaning(child)) {
                case CONCEPT: {
                    int concept_nid = this.getNid(child, TinkarTerm.CONCEPT_REFERENCE);
                    def.addSuperConcept(this.data.getOrCreateConcept(concept_nid));
                    break;
                }
                case ROLE: {
                    int role_operator_nid = this.getNid(child, TinkarTerm.ROLE_OPERATOR);
                    int role_type_nid = this.getNid(child, TinkarTerm.ROLE_TYPE);
                    if (role_operator_nid == TinkarTerm.EXISTENTIAL_RESTRICTION.nid()) {
                        if (role_type_nid == TinkarTerm.ROLE_GROUP.nid()) {
                            this.data.getOrCreateRoleType(role_type_nid);
                            this.processRoleGroup(def, child, definition);
                            break;
                        }
                        Role role = this.makeRole(child, definition);
                        def.addUngroupedRole(role);
                        break;
                    }
                    throw new UnsupportedOperationException("Role: " + PrimitiveData.text((int)role_operator_nid) + " not supported. ");
                }
                default: {
                    throw new IllegalArgumentException("Unexpected value: " + String.valueOf(this.getMeaning(child)));
                }
            }
        }
    }

    private Role makeRole(EntityVertex node, DiTreeEntity definition) {
        int role_type_nid = this.getNid(node, TinkarTerm.ROLE_TYPE);
        RoleType role_type = this.data.getOrCreateRoleType(role_type_nid);
        ImmutableList children = definition.successors(node);
        if (children.size() != 1) {
            throw new IllegalStateException("Role can only have one child. Role: " + String.valueOf(node) + " definition: " + String.valueOf(definition));
        }
        EntityVertex child = (EntityVertex)children.getFirst();
        int concept_nid = this.getNid(child, TinkarTerm.CONCEPT_REFERENCE);
        return new Role(role_type, this.data.getOrCreateConcept(concept_nid));
    }

    private void processRoleGroup(Definition def, EntityVertex node, DiTreeEntity definition) {
        ImmutableList children = definition.successors(node);
        if (children.size() != 1) {
            throw new IllegalStateException("RoleGroup can only have one child. Role: " + String.valueOf(node) + " definition: " + String.valueOf(definition));
        }
        EntityVertex child = (EntityVertex)children.getFirst();
        switch (this.getMeaning(child)) {
            case ROLE: {
                int role_operator_nid = this.getNid(child, TinkarTerm.ROLE_OPERATOR);
                if (role_operator_nid == TinkarTerm.EXISTENTIAL_RESTRICTION.nid()) {
                    RoleGroup rg = new RoleGroup();
                    def.addRoleGroup(rg);
                    Role role = this.makeRole(child, definition);
                    rg.addRole(role);
                    break;
                }
                throw new UnsupportedOperationException("Role: " + PrimitiveData.text((int)role_operator_nid) + " not supported. ");
            }
            case AND: {
                this.processRoleGroupAnd(def, child, definition);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + String.valueOf(this.getMeaning(child)));
            }
        }
    }

    private void processRoleGroupAnd(Definition def, EntityVertex node, DiTreeEntity definition) {
        RoleGroup rg = new RoleGroup();
        def.addRoleGroup(rg);
        ImmutableList children = definition.successors(node);
        for (EntityVertex child : children) {
            switch (this.getMeaning(child)) {
                case ROLE: {
                    int role_operator_nid = this.getNid(child, TinkarTerm.ROLE_OPERATOR);
                    if (role_operator_nid == TinkarTerm.EXISTENTIAL_RESTRICTION.nid()) {
                        Role role = this.makeRole(child, definition);
                        rg.addRole(role);
                        break;
                    }
                    throw new UnsupportedOperationException("Role: " + PrimitiveData.text((int)role_operator_nid) + " not supported. ");
                }
                default: {
                    throw new IllegalArgumentException("Unexpected value: " + String.valueOf(this.getMeaning(child)));
                }
            }
        }
    }
}

