/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.reasoner.elksnomed;

import dev.ikm.elk.snomed.SnomedOntology;
import dev.ikm.elk.snomed.SnomedOntologyReasoner;
import dev.ikm.elk.snomed.model.Concept;
import dev.ikm.tinkar.coordinate.view.calculator.ViewCalculator;
import dev.ikm.tinkar.entity.graph.DiTreeEntity;
import dev.ikm.tinkar.reasoner.elksnomed.ElkSnomedData;
import dev.ikm.tinkar.reasoner.elksnomed.ElkSnomedDataBuilder;
import dev.ikm.tinkar.reasoner.service.ReasonerServiceBase;
import dev.ikm.tinkar.terms.PatternFacade;
import java.util.Set;
import org.eclipse.collections.api.list.primitive.ImmutableIntList;
import org.eclipse.collections.api.set.primitive.ImmutableIntSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElkSnomedReasonerService
extends ReasonerServiceBase {
    private static final Logger LOG = LoggerFactory.getLogger(ElkSnomedReasonerService.class);
    private ElkSnomedData data;
    private ElkSnomedDataBuilder builder;
    private SnomedOntology ontology;
    private SnomedOntologyReasoner reasoner;

    public void init(ViewCalculator viewCalculator, PatternFacade statedAxiomPattern, PatternFacade inferredAxiomPattern) {
        super.init(viewCalculator, statedAxiomPattern, inferredAxiomPattern);
        this.data = null;
        this.reasoner = null;
    }

    public void extractData() throws Exception {
        this.data = new ElkSnomedData();
        this.builder = new ElkSnomedDataBuilder(this.viewCalculator, this.statedAxiomPattern, this.data);
        this.builder.setProgressUpdater(this.progressUpdater);
        this.builder.build();
    }

    public void loadData() throws Exception {
        this.progressUpdater.updateProgress(0L, (long)this.data.getActiveConceptCount());
        LOG.info("Create ontology");
        this.ontology = new SnomedOntology(this.data.getConcepts(), this.data.getRoleTypes());
        LOG.info("Create reasoner");
        this.reasoner = SnomedOntologyReasoner.create((SnomedOntology)this.ontology);
    }

    public void computeInferences() {
    }

    public boolean isIncrementalReady() {
        return this.reasoner != null;
    }

    public void processIncremental(DiTreeEntity definition, int conceptNid) {
        Concept concept = this.builder.processIncremental(definition, conceptNid);
        this.reasoner.process(concept);
        this.reasoner.flush();
    }

    public int getConceptCount() {
        return this.data.getActiveConceptCount();
    }

    public ImmutableIntList getReasonerConceptSet() {
        return this.data.getReasonerConceptSet();
    }

    private ImmutableIntSet toIntSet(Set<Long> classes) {
        if (classes == null) {
            return null;
        }
        MutableIntSet parentNids = IntSets.mutable.withInitialCapacity(classes.size());
        for (long parent : classes) {
            parentNids.add((int)parent);
        }
        return parentNids.toImmutable();
    }

    public ImmutableIntSet getEquivalent(int id) {
        Set eqs = this.reasoner.getEquivalentConcepts((long)id);
        return this.toIntSet(eqs);
    }

    public ImmutableIntSet getParents(int id) {
        Set supers = this.reasoner.getSuperConcepts((long)id);
        return this.toIntSet(supers);
    }

    public ImmutableIntSet getChildren(int id) {
        Set subs = this.reasoner.getSubConcepts((long)id);
        return this.toIntSet(subs);
    }
}

