/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.reasoner.service;

import dev.ikm.tinkar.common.service.TrackingCallable;
import dev.ikm.tinkar.coordinate.view.calculator.ViewCalculator;
import dev.ikm.tinkar.reasoner.service.ReasonerService;
import dev.ikm.tinkar.terms.PatternFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReasonerServiceBase
implements ReasonerService {
    private static final Logger LOG = LoggerFactory.getLogger(ReasonerServiceBase.class);
    protected ViewCalculator viewCalculator;
    protected PatternFacade statedAxiomPattern;
    protected PatternFacade inferredAxiomPattern;
    protected TrackingCallable<?> progressUpdater;

    @Override
    public ViewCalculator getViewCalculator() {
        return this.viewCalculator;
    }

    @Override
    public PatternFacade getStatedAxiomPattern() {
        return this.statedAxiomPattern;
    }

    @Override
    public PatternFacade getInferredAxiomPattern() {
        return this.inferredAxiomPattern;
    }

    @Override
    public TrackingCallable<?> getProgressUpdater() {
        return this.progressUpdater;
    }

    @Override
    public void setProgressUpdater(TrackingCallable<?> progressUpdater) {
        if (progressUpdater == null) {
            progressUpdater = new NoopTrackingCallable();
        }
        this.progressUpdater = progressUpdater;
    }

    @Override
    public void init(ViewCalculator viewCalculator, PatternFacade statedAxiomPattern, PatternFacade inferredAxiomPattern) {
        this.viewCalculator = viewCalculator;
        this.statedAxiomPattern = statedAxiomPattern;
        this.inferredAxiomPattern = inferredAxiomPattern;
        this.progressUpdater = null;
    }

    private static class NoopTrackingCallable
    extends TrackingCallable<Void> {
        private NoopTrackingCallable() {
        }

        protected Void compute() throws Exception {
            return null;
        }
    }
}

