/*
 * Decompiled with CFR 0.152.
 */
package dev.inmo.micro_utils.android.recyclerview;

import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import dev.inmo.micro_utils.android.recyclerview.AbstractViewHolder;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u001e\u0010\u0014\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0016\u001a\u00020\u0013H\u0016R\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR(\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Ldev/inmo/micro_utils/android/recyclerview/RecyclerViewAdapter;", "T", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Ldev/inmo/micro_utils/android/recyclerview/AbstractViewHolder;", "()V", "data", "", "getData", "()Ljava/util/List;", "value", "Landroid/view/View;", "emptyView", "getEmptyView", "()Landroid/view/View;", "setEmptyView", "(Landroid/view/View;)V", "checkEmpty", "", "getItemCount", "", "onBindViewHolder", "holder", "position", "micro_utils.android.recyclerview_debug"})
public abstract class RecyclerViewAdapter<T>
extends RecyclerView.Adapter<AbstractViewHolder<? super T>> {
    @Nullable
    private View emptyView;

    public RecyclerViewAdapter() {
        this.registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(){

            public void onItemRangeChanged(int positionStart, int itemCount) {
                super.onItemRangeChanged(positionStart, itemCount);
                this.checkEmpty();
            }

            public void onItemRangeChanged(int positionStart, int itemCount, @Nullable Object payload) {
                super.onItemRangeChanged(positionStart, itemCount, payload);
                this.checkEmpty();
            }

            public void onChanged() {
                super.onChanged();
                this.checkEmpty();
            }

            public void onItemRangeRemoved(int positionStart, int itemCount) {
                super.onItemRangeRemoved(positionStart, itemCount);
                this.checkEmpty();
            }

            public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
                super.onItemRangeMoved(fromPosition, toPosition, itemCount);
                this.checkEmpty();
            }

            public void onItemRangeInserted(int positionStart, int itemCount) {
                super.onItemRangeInserted(positionStart, itemCount);
                this.checkEmpty();
            }
        });
        this.checkEmpty();
    }

    @NotNull
    protected abstract List<T> getData();

    @Nullable
    public final View getEmptyView() {
        return this.emptyView;
    }

    public final void setEmptyView(@Nullable View value) {
        this.emptyView = value;
        this.checkEmpty();
    }

    public int getItemCount() {
        return this.getData().size();
    }

    public void onBindViewHolder(@NotNull AbstractViewHolder<? super T> holder, int position) {
        Intrinsics.checkNotNullParameter(holder, (String)"holder");
        holder.onBind(this.getData().get(position));
    }

    private final void checkEmpty() {
        View view = this.emptyView;
        if (view != null) {
            View view2 = view;
            boolean bl = false;
            boolean bl2 = false;
            View it = view2;
            boolean bl3 = false;
            if (this.getData().isEmpty()) {
                it.setVisibility(0);
            } else {
                it.setVisibility(8);
            }
        }
    }
}

