/*
 * Decompiled with CFR 0.152.
 */
package dev.instalog.mobile.device;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import androidx.compose.runtime.internal.StabilityInferred;
import dev.instalog.mobile.device.BatteryInfo;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000b\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ldev/instalog/mobile/device/BatteryStatusReceiver;", "Landroid/content/BroadcastReceiver;", "callback", "Lkotlin/Function1;", "Ldev/instalog/mobile/device/BatteryInfo;", "", "(Lkotlin/jvm/functions/Function1;)V", "calculateBatteryPercent", "", "intent", "Landroid/content/Intent;", "onReceive", "context", "Landroid/content/Context;", "instalog_release"})
@StabilityInferred(parameters=0)
public final class BatteryStatusReceiver
extends BroadcastReceiver {
    @NotNull
    private final Function1<BatteryInfo, Unit> callback;
    public static final int $stable;

    public BatteryStatusReceiver(@NotNull Function1<? super BatteryInfo, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.callback = callback;
    }

    public void onReceive(@Nullable Context context, @Nullable Intent intent) {
        Intent intent2 = intent;
        if (Intrinsics.areEqual((Object)(intent2 != null ? intent2.getAction() : null), (Object)"android.intent.action.BATTERY_CHANGED")) {
            float percent = this.calculateBatteryPercent(intent);
            int status = intent.getIntExtra("status", 1);
            this.callback.invoke((Object)new BatteryInfo(percent, status));
        }
    }

    private final float calculateBatteryPercent(Intent intent) {
        int level = intent.getIntExtra("level", -1);
        int scale = intent.getIntExtra("scale", -1);
        return level != -1 && scale != -1 ? (float)level / (float)scale * (float)100 : 0.0f;
    }
}

