/*
 * Decompiled with CFR 0.152.
 */
package dev.instalog.mobile.device;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.BatteryManager;
import android.os.Build;
import androidx.compose.runtime.internal.StabilityInferred;
import dev.instalog.mobile.device.BatteryInfo;
import dev.instalog.mobile.device.BatteryStatusReceiver;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\f\u00a8\u0006\u000e"}, d2={"Ldev/instalog/mobile/device/InstalogBattery;", "", "()V", "convertBatteryStatus", "", "status", "", "getBatteryInfo", "", "context", "Landroid/content/Context;", "callback", "Lkotlin/Function1;", "Ldev/instalog/mobile/device/BatteryInfo;", "instalog_release"})
@StabilityInferred(parameters=0)
public final class InstalogBattery {
    @NotNull
    public static final InstalogBattery INSTANCE = new InstalogBattery();
    public static final int $stable;

    private InstalogBattery() {
    }

    @NotNull
    public final String convertBatteryStatus(int status) {
        String string;
        switch (status) {
            case 2: {
                string = "charging";
                break;
            }
            case 3: {
                string = "discharging";
                break;
            }
            case 4: {
                string = "not_charging";
                break;
            }
            case 5: {
                string = "full";
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        return string;
    }

    public final void getBatteryInfo(@NotNull Context context, @NotNull Function1<? super BatteryInfo, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (Build.VERSION.SDK_INT >= 26) {
            Object object = context.getSystemService("batterymanager");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.os.BatteryManager");
            BatteryManager batteryManager = (BatteryManager)object;
            int batteryStatus = batteryManager.getIntProperty(6);
            float batteryPercent = batteryManager.getIntProperty(4);
            callback.invoke((Object)new BatteryInfo(batteryPercent, batteryStatus));
        } else {
            BatteryStatusReceiver batteryStatusReceiver = new BatteryStatusReceiver(callback);
            IntentFilter filter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            context.registerReceiver((BroadcastReceiver)batteryStatusReceiver, filter);
            context.unregisterReceiver((BroadcastReceiver)batteryStatusReceiver);
        }
    }
}

