/*
 * Decompiled with CFR 0.152.
 */
package dev.instalog.mobile.device;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.os.Build;
import androidx.compose.runtime.internal.StabilityInferred;
import dev.instalog.mobile.Instalog;
import dev.instalog.mobile.device.BatteryInfo;
import dev.instalog.mobile.device.InstalogBattery;
import dev.instalog.mobile.models.InstalogCrashModel;
import dev.instalog.mobile.models.InstalogDeviceModel;
import dev.instalog.mobile.utils.InstalogUtilsKt;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\f\u0010\u0010\u001a\u00020\u0004*\u00020\bH\u0002J\f\u0010\u0011\u001a\u00020\u0012*\u00020\bH\u0002J\f\u0010\u0013\u001a\u00020\u0004*\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ldev/instalog/mobile/device/InstalogDevice;", "", "()V", "PREF_KEY_INSTALOG", "", "PREF_KEY_INSTALOG_UUID", "getFirstInstallTime", "context", "Landroid/content/Context;", "getLastUpdateTime", "isEmulator", "", "prepareCrashModel", "Ldev/instalog/mobile/models/InstalogCrashModel;", "prepareDeviceDetails", "Ldev/instalog/mobile/models/InstalogDeviceModel;", "getUserUUID", "getVersionCode", "", "getVersionName", "instalog_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nInstalogDevice.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstalogDevice.kt\ndev/instalog/mobile/device/InstalogDevice\n+ 2 SharedPreferences.kt\nandroidx/core/content/SharedPreferencesKt\n*L\n1#1,154:1\n39#2,12:155\n*S KotlinDebug\n*F\n+ 1 InstalogDevice.kt\ndev/instalog/mobile/device/InstalogDevice\n*L\n107#1:155,12\n*E\n"})
public final class InstalogDevice {
    @NotNull
    public static final InstalogDevice INSTANCE = new InstalogDevice();
    @NotNull
    private static final String PREF_KEY_INSTALOG_UUID = "InstalogUUID";
    @NotNull
    private static final String PREF_KEY_INSTALOG = "InstalogPref";
    public static final int $stable;

    private InstalogDevice() {
    }

    @NotNull
    public final InstalogCrashModel prepareCrashModel(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        InstalogDeviceModel device = this.prepareDeviceDetails(context);
        String deviceUUID = this.getUserUUID(context);
        String bundleIdentifier = context.getApplicationInfo().packageName;
        String string = Instalog.Companion.getUserId();
        if (string == null) {
            string = deviceUUID;
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)bundleIdentifier);
        return new InstalogCrashModel(deviceUUID, string2, bundleIdentifier, device, null, null, null, 112, null);
    }

    private final InstalogDeviceModel prepareDeviceDetails(Context context) {
        Ref.ObjectRef batteryState = new Ref.ObjectRef();
        batteryState.element = "";
        Ref.ObjectRef batteryLevel = new Ref.ObjectRef();
        long versionCode = this.getVersionCode(context);
        String versionName = this.getVersionName(context);
        CharSequence charSequence = context.getApplicationInfo().loadLabel(context.getPackageManager());
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"loadLabel(...)");
        CharSequence bundleName = charSequence;
        InstalogBattery.INSTANCE.getBatteryInfo(context, (Function1<? super BatteryInfo, Unit>)((Function1)new Function1<BatteryInfo, Unit>((Ref.ObjectRef<String>)batteryState, (Ref.ObjectRef<Float>)batteryLevel){
            final /* synthetic */ Ref.ObjectRef<String> $batteryState;
            final /* synthetic */ Ref.ObjectRef<Float> $batteryLevel;
            {
                this.$batteryState = $batteryState;
                this.$batteryLevel = $batteryLevel;
                super(1);
            }

            public final void invoke(@NotNull BatteryInfo batteryInfo) {
                Intrinsics.checkNotNullParameter((Object)batteryInfo, (String)"batteryInfo");
                this.$batteryState.element = InstalogBattery.INSTANCE.convertBatteryStatus(batteryInfo.getBatteryStatus());
                this.$batteryLevel.element = Float.valueOf(batteryInfo.getBatteryPercent());
            }
        }));
        String string = Build.MODEL;
        String string2 = Build.MANUFACTURER;
        String string3 = Build.BRAND;
        String string4 = Build.PRODUCT;
        String string5 = Build.DEVICE;
        Intrinsics.checkNotNullExpressionValue((Object)Build.SUPPORTED_ABIS, (String)"SUPPORTED_ABIS");
        Object object = Build.SUPPORTED_ABIS;
        List list = CollectionsKt.listOf((Object[])Arrays.copyOf(object, ((String[])object).length));
        object = Build.VERSION.RELEASE;
        int n = Build.VERSION.SDK_INT;
        String string6 = (String)batteryState.element;
        Float f = (Float)batteryLevel.element;
        String string7 = ((Object)bundleName).toString();
        String string8 = this.getFirstInstallTime(context);
        String string9 = this.getLastUpdateTime(context);
        String string10 = Build.TYPE;
        String string11 = Build.TAGS;
        String string12 = Build.FINGERPRINT;
        String string13 = InstalogUtilsKt.toISO8601String(Build.TIME);
        String string14 = Build.VERSION.CODENAME;
        String string15 = Build.VERSION.INCREMENTAL;
        String string16 = Build.BOARD;
        String string17 = Build.BOOTLOADER;
        String string18 = Build.HARDWARE;
        String string19 = Build.HOST;
        String string20 = Build.USER;
        String string21 = Build.VERSION.SDK_INT >= 24 ? Build.VERSION.SECURITY_PATCH : "unknown";
        boolean bl = this.isEmulator();
        Intrinsics.checkNotNull((Object)string);
        Intrinsics.checkNotNull((Object)string2);
        Intrinsics.checkNotNull((Object)string4);
        Intrinsics.checkNotNull((Object)string5);
        Intrinsics.checkNotNull((Object)string3);
        Intrinsics.checkNotNull((Object)object);
        Intrinsics.checkNotNull((Object)string10);
        Intrinsics.checkNotNull((Object)string11);
        Intrinsics.checkNotNull((Object)string12);
        Intrinsics.checkNotNull((Object)string14);
        Intrinsics.checkNotNull((Object)string15);
        Intrinsics.checkNotNull((Object)string16);
        Intrinsics.checkNotNull((Object)string17);
        Intrinsics.checkNotNull((Object)string18);
        Intrinsics.checkNotNull((Object)string19);
        Intrinsics.checkNotNull((Object)string20);
        Intrinsics.checkNotNull((Object)string21);
        return new InstalogDeviceModel("android", string, string2, string4, string5, string3, list, (String)object, n, versionCode, versionName, string7, string6, f, string8, string9, string10, string11, string12, string13, string14, string15, string16, string17, string18, string19, string20, string21, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isEmulator() {
        String string = Build.BRAND;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"BRAND");
        if (StringsKt.startsWith$default((String)string, (String)"generic", (boolean)false, (int)2, null)) {
            String string2 = Build.DEVICE;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DEVICE");
            if (StringsKt.startsWith$default((String)string2, (String)"generic", (boolean)false, (int)2, null)) return true;
        }
        String string3 = Build.FINGERPRINT;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"FINGERPRINT");
        if (StringsKt.startsWith$default((String)string3, (String)"generic", (boolean)false, (int)2, null)) return true;
        String string4 = Build.FINGERPRINT;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"FINGERPRINT");
        if (StringsKt.startsWith$default((String)string4, (String)"unknown", (boolean)false, (int)2, null)) return true;
        String string5 = Build.HARDWARE;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"HARDWARE");
        if (StringsKt.contains$default((CharSequence)string5, (CharSequence)"goldfish", (boolean)false, (int)2, null)) return true;
        String string6 = Build.HARDWARE;
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"HARDWARE");
        if (StringsKt.contains$default((CharSequence)string6, (CharSequence)"ranchu", (boolean)false, (int)2, null)) return true;
        String string7 = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"MODEL");
        if (StringsKt.contains$default((CharSequence)string7, (CharSequence)"google_sdk", (boolean)false, (int)2, null)) return true;
        String string8 = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"MODEL");
        if (StringsKt.contains$default((CharSequence)string8, (CharSequence)"Emulator", (boolean)false, (int)2, null)) return true;
        String string9 = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"MODEL");
        if (StringsKt.contains$default((CharSequence)string9, (CharSequence)"Android SDK built for x86", (boolean)false, (int)2, null)) return true;
        String string10 = Build.MANUFACTURER;
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"MANUFACTURER");
        if (StringsKt.contains$default((CharSequence)string10, (CharSequence)"Genymotion", (boolean)false, (int)2, null)) return true;
        String string11 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"PRODUCT");
        if (StringsKt.contains$default((CharSequence)string11, (CharSequence)"sdk_gphone", (boolean)false, (int)2, null)) return true;
        String string12 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"PRODUCT");
        if (StringsKt.contains$default((CharSequence)string12, (CharSequence)"google_sdk", (boolean)false, (int)2, null)) return true;
        String string13 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"PRODUCT");
        if (StringsKt.contains$default((CharSequence)string13, (CharSequence)"sdk", (boolean)false, (int)2, null)) return true;
        String string14 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"PRODUCT");
        if (StringsKt.contains$default((CharSequence)string14, (CharSequence)"sdk_x86", (boolean)false, (int)2, null)) return true;
        String string15 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"PRODUCT");
        if (StringsKt.contains$default((CharSequence)string15, (CharSequence)"vbox86p", (boolean)false, (int)2, null)) return true;
        String string16 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"PRODUCT");
        if (StringsKt.contains$default((CharSequence)string16, (CharSequence)"emulator", (boolean)false, (int)2, null)) return true;
        String string17 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string17, (String)"PRODUCT");
        if (!StringsKt.contains$default((CharSequence)string17, (CharSequence)"simulator", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private final String getUserUUID(Context $this$getUserUUID) {
        SharedPreferences sharedPreferences = $this$getUserUUID.getSharedPreferences(PREF_KEY_INSTALOG, 0);
        String uuid = null;
        uuid = sharedPreferences.getString(PREF_KEY_INSTALOG_UUID, "");
        CharSequence charSequence = uuid;
        if (charSequence == null || charSequence.length() == 0) {
            SharedPreferences.Editor editor$iv;
            uuid = UUID.randomUUID().toString();
            Intrinsics.checkNotNull((Object)sharedPreferences);
            SharedPreferences $this$edit_u24default$iv = sharedPreferences;
            boolean commit$iv = false;
            boolean $i$f$edit = false;
            SharedPreferences.Editor $this$getUserUUID_u24lambda_u240 = editor$iv = $this$edit_u24default$iv.edit();
            boolean bl = false;
            $this$getUserUUID_u24lambda_u240.putString(PREF_KEY_INSTALOG_UUID, uuid);
            editor$iv.apply();
        }
        return uuid;
    }

    private final String getFirstInstallTime(Context context) {
        String string;
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            string = InstalogUtilsKt.toISO8601String(packageInfo.firstInstallTime);
        }
        catch (Exception e) {
            string = "N/A";
        }
        return string;
    }

    private final String getLastUpdateTime(Context context) {
        String string;
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            string = InstalogUtilsKt.toISO8601String(packageInfo.lastUpdateTime);
        }
        catch (Exception e) {
            string = "N/A";
        }
        return string;
    }

    private final String getVersionName(Context $this$getVersionName) {
        String string;
        try {
            PackageInfo packageInfo = $this$getVersionName.getPackageManager().getPackageInfo($this$getVersionName.getPackageName(), 0);
            string = packageInfo.versionName;
            Intrinsics.checkNotNull((Object)string);
        }
        catch (Exception e) {
            string = "N/A";
        }
        return string;
    }

    private final long getVersionCode(Context $this$getVersionCode) {
        long l;
        try {
            PackageInfo packageInfo = $this$getVersionCode.getPackageManager().getPackageInfo($this$getVersionCode.getPackageName(), 0);
            l = Build.VERSION.SDK_INT >= 28 ? packageInfo.getLongVersionCode() : (long)packageInfo.versionCode;
        }
        catch (Exception e) {
            l = -1L;
        }
        return l;
    }
}

