/*
 * Decompiled with CFR 0.152.
 */
package dev.instalog.mobile.exceptions;

import android.content.Context;
import android.os.Environment;
import androidx.compose.runtime.internal.StabilityInferred;
import com.google.gson.Gson;
import dev.instalog.mobile.device.InstalogDevice;
import dev.instalog.mobile.models.InstalogCrashModel;
import dev.instalog.mobile.models.InstalogStackTraceModel;
import dev.instalog.mobile.utils.InstalogLogger;
import dev.instalog.mobile.utils.InstalogUtilsKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ\u001d\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u000fJ\u001e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0016\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0015"}, d2={"Ldev/instalog/mobile/exceptions/InstalogExceptions;", "", "()V", "crashModelFromString", "Ldev/instalog/mobile/models/InstalogCrashModel;", "error", "", "stack", "context", "Landroid/content/Context;", "createCrashModel", "throwable", "", "getLatestCrashReportPath", "", "Ljava/io/File;", "(Landroid/content/Context;)[Ljava/io/File;", "getStackTraceString", "handleCrashReportFile", "crashFile", "saveStackTraceAsJsonToFile", "instalog_release"})
@StabilityInferred(parameters=0)
public final class InstalogExceptions {
    @NotNull
    public static final InstalogExceptions INSTANCE = new InstalogExceptions();
    public static final int $stable;

    private InstalogExceptions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final File saveStackTraceAsJsonToFile(@NotNull Context context, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.getDefault()).format(new Date());
        String fileName = "insta_crash_" + timeStamp + ".json";
        File directory = new File(context.getExternalFilesDir(Environment.DIRECTORY_DOCUMENTS), ".instalog");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File file = new File(directory, fileName);
        try {
            InstalogCrashModel jsonObject = this.createCrashModel(context, throwable);
            Closeable closeable = new FileWriter(file);
            Throwable throwable2 = null;
            try {
                FileWriter writer = (FileWriter)closeable;
                boolean bl = false;
                new Gson().toJson((Object)jsonObject, (Appendable)writer);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
            }
            InstalogLogger.Companion.debug("Crash saved to file: " + FilesKt.getNameWithoutExtension((File)file));
        }
        catch (IOException e) {
            InstalogLogger.Companion.error("Error writing crash report to file", e);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final File saveStackTraceAsJsonToFile(@NotNull Context context, @NotNull String error, @NotNull String stack) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.getDefault()).format(new Date());
        String fileName = "insta_crash_" + timeStamp + ".json";
        File directory = new File(context.getExternalFilesDir(Environment.DIRECTORY_DOCUMENTS), ".instalog");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File file = new File(directory, fileName);
        try {
            InstalogCrashModel jsonObject = this.crashModelFromString(error, stack, context);
            Closeable closeable = new FileWriter(file);
            Throwable throwable = null;
            try {
                FileWriter writer = (FileWriter)closeable;
                boolean bl = false;
                new Gson().toJson((Object)jsonObject, (Appendable)writer);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            InstalogLogger.Companion.debug("Crash saved to file: " + FilesKt.getNameWithoutExtension((File)file));
        }
        catch (IOException e) {
            InstalogLogger.Companion.error("Error writing crash report to file", e);
        }
        return file;
    }

    @NotNull
    public final InstalogCrashModel createCrashModel(@NotNull Context context, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        InstalogStackTraceModel stackTrace = new InstalogStackTraceModel(null, this.getStackTraceString(throwable), 1, null);
        return InstalogCrashModel.copy$default(InstalogDevice.INSTANCE.prepareCrashModel(context), null, null, null, null, null, null, stackTrace, 63, null);
    }

    @NotNull
    public final InstalogCrashModel crashModelFromString(@NotNull String error, @NotNull String stack, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        InstalogStackTraceModel stackTrace = new InstalogStackTraceModel(null, "Error:\n" + error + "\n\nStack:\n" + stack, 1, null);
        return InstalogCrashModel.copy$default(InstalogDevice.INSTANCE.prepareCrashModel(context), null, null, null, null, null, null, stackTrace, 63, null);
    }

    private final String getStackTraceString(Throwable throwable) {
        return ExceptionsKt.stackTraceToString((Throwable)throwable);
    }

    @Nullable
    public final File[] getLatestCrashReportPath(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        File crashReportsDir = new File(context.getExternalFilesDir(Environment.DIRECTORY_DOCUMENTS), ".instalog");
        if (!crashReportsDir.exists()) {
            return null;
        }
        File[] crashReportFiles = crashReportsDir.listFiles(InstalogExceptions::getLatestCrashReportPath$lambda$2);
        return crashReportFiles;
    }

    @NotNull
    public final InstalogCrashModel handleCrashReportFile(@NotNull File crashFile) {
        Intrinsics.checkNotNullParameter((Object)crashFile, (String)"crashFile");
        String crashReportJson = InstalogUtilsKt.readTextAndClose(crashFile);
        Object object = new Gson().fromJson(crashReportJson, InstalogCrashModel.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
        return (InstalogCrashModel)object;
    }

    private static final boolean getLatestCrashReportPath$lambda$2(File file, String name) {
        Intrinsics.checkNotNull((Object)name);
        return StringsKt.startsWith$default((String)name, (String)"insta_crash", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)name, (String)".json", (boolean)false, (int)2, null);
    }
}

