/*
 * Decompiled with CFR 0.152.
 */
package dev.jbang;

import java.io.File;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessResult;
import org.zeroturnaround.exec.stream.slf4j.Slf4jStream;

@Mojo(name="run", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresProject=false)
public class RunMojo
extends AbstractMojo {
    private static final boolean IS_OS_WINDOWS = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
    private static final int OK_EXIT_CODE = 0;
    @Parameter(property="jbang.script", required=true)
    private String script;
    @Parameter(property="jbang.args")
    private String[] args;
    @Parameter(property="jbang.trusts")
    private String[] trusts;
    @Parameter(property="jbang.version")
    private String jbangVersion = this.getJBangVersion();
    @Parameter(property="jbang.install.dir", defaultValue="${project.basedir}")
    private File jbangInstallDir;
    @Parameter(property="jbang.skip")
    private boolean skip;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}")
    private MavenSession session;
    @Component
    private BuildPluginManager pluginManager;
    private Path jbangHome;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        this.detectJBang();
        this.executeTrust();
        this.executeJBang();
    }

    private void detectJBang() throws MojoExecutionException {
        ProcessResult result = this.version();
        if (result.getExitValue() == 0) {
            this.getLog().info((CharSequence)("Found JBang v." + result.outputString()));
        } else {
            this.getLog().warn((CharSequence)("JBang not found. Downloading version " + this.jbangVersion));
            this.download();
            result = this.version();
            if (result.getExitValue() == 0) {
                this.getLog().info((CharSequence)("Using JBang v." + result.outputString()));
            }
        }
    }

    private String getJBangVersion() {
        return "0.47.1";
    }

    private void download() throws MojoExecutionException {
        String uri = String.format("https://github.com/jbangdev/jbang/releases/download/v%s/jbang-%s.zip", this.jbangVersion, this.jbangVersion);
        Path installDir = this.jbangInstallDir.toPath().resolve(".jbang").toAbsolutePath();
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)"com.googlecode.maven-download-plugin", (String)"download-maven-plugin", (String)"1.6.0"), (String)MojoExecutor.goal((String)"wget"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"uri", (String)uri), MojoExecutor.element((String)"unpack", (String)"true"), MojoExecutor.element((String)"outputDirectory", (String)installDir.toString())}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
        this.jbangHome = installDir.resolve("jbang-" + this.jbangVersion);
    }

    private ProcessResult version() throws MojoExecutionException {
        List<String> command = this.command();
        command.add(this.findJBangExecutable() + " version");
        ProcessResult result = null;
        try {
            result = new ProcessExecutor().command(command).readOutput(true).destroyOnExit().execute();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while fetching the JBang version", e);
        }
        return result;
    }

    private void executeTrust() throws MojoExecutionException {
        if (this.trusts == null || this.trusts.length == 0) {
            return;
        }
        List<String> command = this.command();
        command.add(this.findJBangExecutable() + " trust add " + String.join((CharSequence)" ", this.trusts));
        ProcessResult result = this.execute(command);
        int exitValue = result.getExitValue();
        if (exitValue != 0 && exitValue != 1) {
            throw new MojoExecutionException("Error while trusting JBang URLs. Exit code: " + result.getExitValue());
        }
    }

    private void executeJBang() throws MojoExecutionException {
        List<String> command = this.command();
        StringBuilder executable = new StringBuilder(this.findJBangExecutable());
        executable.append(" run ").append(this.script);
        if (this.args != null) {
            executable.append(" ").append(String.join((CharSequence)" ", this.args));
        }
        command.add(executable.toString());
        ProcessResult result = this.execute(command);
        if (result.getExitValue() != 0) {
            throw new MojoExecutionException("Error while executing JBang. Exit code: " + result.getExitValue());
        }
    }

    private ProcessResult execute(List<String> command) throws MojoExecutionException {
        try {
            return new ProcessExecutor().command(command).redirectOutput((OutputStream)Slf4jStream.ofCaller().asInfo()).destroyOnExit().execute();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while executing JBang", e);
        }
    }

    private List<String> command() {
        ArrayList<String> command = new ArrayList<String>();
        if (IS_OS_WINDOWS) {
            command.add("cmd.exe");
            command.add("/c");
        } else {
            command.add("sh");
            command.add("-c");
        }
        return command;
    }

    private String findJBangExecutable() {
        if (this.jbangHome != null) {
            if (IS_OS_WINDOWS) {
                return this.jbangHome.resolve("bin/jbang.cmd").toString();
            }
            return this.jbangHome.resolve("bin/jbang").toString();
        }
        if (IS_OS_WINDOWS) {
            return "jbang.cmd";
        }
        return "jbang";
    }
}

