/*
 * Decompiled with CFR 0.152.
 */
package dev.jeschke.maven.mockito;

import java.io.File;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Execute(phase=LifecyclePhase.INITIALIZE, goal="prepareAgent")
@Mojo(name="prepareAgent", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.INITIALIZE, threadSafe=true)
public class PrepareAgentMojo
extends AbstractMojo {
    private static final String TYCHO_SUREFIRE_GROUP_ID = "org.eclipse.tycho";
    private static final String TYCHO_SUREFIRE_ARTIFACT_ID = "tycho-surefire-plugin";
    private static final String TYCHO_ARGLINE_PROPERTY = "tycho.testArgLine";
    private static final String SUREFIRE_ARGLINE_PROPERTY = "argLine";
    private final MavenProject project;
    private String propertyName = null;
    private String agentGroupId = "org.mockito";
    private String agentArtifactId = "mockito-core";
    private Boolean skipPrepare = null;
    private boolean skipTests = false;
    private boolean failSilent = false;

    @Inject
    public PrepareAgentMojo(MavenProject project) {
        this.project = Objects.requireNonNull(project);
    }

    public void execute() throws MojoFailureException {
        if (this.skipTests && this.skipPrepare != Boolean.FALSE) {
            this.getLog().info((CharSequence)"Tests are skipped");
            return;
        }
        if (this.skipPrepare == Boolean.TRUE) {
            this.getLog().info((CharSequence)"Goal is skipped");
            return;
        }
        if (this.isNullOrEmpty(this.agentGroupId) || this.isNullOrEmpty(this.agentArtifactId)) {
            throw new MojoFailureException("Both agentGroupId and agentArtifactId must be set");
        }
        String actualPropertyName = this.getPropertyName();
        Properties properties = this.project.getProperties();
        String existingArgLine = properties.getProperty(actualPropertyName, "");
        Optional<String> artifactPath = this.buildArtifactPath();
        if (!artifactPath.isPresent()) {
            String artifact = String.format("%s:%s", this.agentGroupId, this.agentArtifactId);
            if (this.failSilent) {
                this.getLog().info((CharSequence)String.format("Could not resolve artifact %s, skipping step", artifact));
                return;
            }
            throw new MojoFailureException(String.format("Could not resolve artifact %s", artifact));
        }
        String mockitoArguments = "-javaagent:" + artifactPath.get();
        String newArgline = mockitoArguments + " " + existingArgLine;
        properties.setProperty(actualPropertyName, newArgline);
        this.getLog().info((CharSequence)String.format("%s set to %s", actualPropertyName, newArgline));
    }

    private String getPropertyName() {
        if (this.propertyName != null) {
            return this.propertyName;
        }
        if (this.project.getBuildPlugins().stream().anyMatch(this::isTychoTestPlugin)) {
            return TYCHO_ARGLINE_PROPERTY;
        }
        return SUREFIRE_ARGLINE_PROPERTY;
    }

    private Optional<String> buildArtifactPath() {
        return this.project.getArtifacts().stream().filter(this::isAgentArtifact).findFirst().map(Artifact::getFile).map(File::getAbsolutePath);
    }

    private boolean isTychoTestPlugin(Plugin plugin) {
        return TYCHO_SUREFIRE_GROUP_ID.equals(plugin.getGroupId()) && TYCHO_SUREFIRE_ARTIFACT_ID.equals(plugin.getArtifactId());
    }

    private boolean isAgentArtifact(Artifact artifact) {
        return this.agentGroupId.equals(artifact.getGroupId()) && this.agentArtifactId.equals(artifact.getArtifactId());
    }

    private boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    @Parameter(name="propertyName", property="mockito.agentPropertyName")
    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @Parameter(name="agentGroupId", property="mockito.agentGroupId", defaultValue="org.mockito")
    public void setAgentGroupId(String agentGroupId) {
        this.agentGroupId = agentGroupId;
    }

    @Parameter(name="agentArtifactId", property="mockito.agentArtifactId", defaultValue="mockito-core")
    public void setAgentArtifactId(String agentArtifactId) {
        this.agentArtifactId = agentArtifactId;
    }

    @Parameter(name="skipPrepare", property="mockito.skipPrepare", defaultValue="false")
    public void setSkipPrepare(Boolean skipPrepare) {
        this.skipPrepare = skipPrepare;
    }

    @Parameter(property="skipTests", defaultValue="false")
    public void setSkipTests(boolean skipTests) {
        this.skipTests = skipTests;
    }

    @Parameter(name="failSilent", property="mockito.failSilent", defaultValue="false")
    public void setFailSilent(boolean failSilent) {
        this.failSilent = failSilent;
    }
}

