/*
 * Decompiled with CFR 0.152.
 */
package dev.jora.postman4j;

import dev.jora.postman4j.models.Body;
import dev.jora.postman4j.models.FormParameter;
import dev.jora.postman4j.models.Header;
import dev.jora.postman4j.models.HeaderElement;
import dev.jora.postman4j.models.HeaderUnion;
import dev.jora.postman4j.models.Headers;
import dev.jora.postman4j.models.Items;
import dev.jora.postman4j.models.Mode;
import dev.jora.postman4j.models.PostmanCollection;
import dev.jora.postman4j.models.RequestClass;
import dev.jora.postman4j.models.RequestUnion;
import dev.jora.postman4j.models.Response;
import dev.jora.postman4j.models.URL;
import dev.jora.postman4j.utils.ConverterUtils;
import dev.jora.postman4j.utils.PostmanCollectionFactory;
import dev.jora.postman4j.utils.PostmanSettings;
import dev.jora.postman4j.utils.RequestResponseMode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface BasePostmanInterceptor<Req, Resp> {
    public static final Logger log = LoggerFactory.getLogger(LoggerFactory.getLogger(BasePostmanInterceptor.class).getClass());

    public ConcurrentHashMap<String, PostmanCollection> getData();

    public AtomicInteger getCounter();

    public PostmanSettings getSettings();

    public String extractRequestName(Req var1);

    public Optional<String> extractHeaderValue(Req var1);

    public boolean isHeaderExistsInRequest(Req var1, String var2);

    public String extractCollectionName(Req var1);

    public List<String> extractFolderNames(Req var1);

    public String extractRequestMethodName(Req var1);

    public String extractRequestUrl(Req var1);

    public boolean hasRequestBody(Req var1);

    public boolean hasRequestFormData(Req var1);

    public String extractRequestBody(Req var1);

    public List<FormParameter> extractRequestFormData(Req var1);

    public List<Header> extractRequestHeaders(Req var1);

    public int extractResponseStatusCode(Resp var1);

    public String extractResponseReasonPhrase(Resp var1);

    public boolean hasResponseBody(Resp var1);

    public String extractResponseBody(Resp var1);

    public List<HeaderElement> extractResponseHeaders(Resp var1);

    public String extractResponseName(Req var1, Resp var2);

    default public String generateRequestName(Req request) {
        if (this.extractRequestName(request) != null) {
            return this.extractRequestName(request);
        }
        switch (this.getSettings().getItemNamingStrategy()) {
            case COUNTER: {
                return "Request " + this.getCounter().incrementAndGet();
            }
            case UUID: {
                return UUID.randomUUID().toString();
            }
            case FROM_HEADER: {
                if (this.getSettings().getHeaderName() == null) break;
                return this.extractHeaderValue(request).orElse("Unnamed request");
            }
        }
        return "Unnamed request";
    }

    default public Resp process(Req request, Callable<Resp> callResponse) throws Exception {
        return this.process(request, callResponse, null);
    }

    default public Resp process(Req request, Callable<Resp> callResponse, Exception throwedException) throws Exception {
        Items singleItem;
        String collectionName = this.extractCollectionName(request);
        PostmanCollection postmanCollection = this.getData().computeIfAbsent(collectionName, name -> PostmanCollectionFactory.createPostmanCollection(name, this.getSettings().getSchemaVersion()));
        Items folder = PostmanCollectionFactory.getOrCreateFolder(postmanCollection, this.extractFolderNames(request));
        try {
            singleItem = this.createSingleItem(request);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        boolean saveToCollection = this.getSettings().shouldSaveAll() && this.getSettings().getCustomStatusFilter() == null;
        try {
            Resp response = callResponse.call();
            if (this.getSettings().getSelectedHeaders().stream().anyMatch(headerName -> this.isHeaderExistsInRequest(request, (String)headerName))) {
                saveToCollection = true;
            }
            if (this.getSettings().getCustomStatusFilter() != null) {
                saveToCollection = this.getSettings().getCustomStatusFilter().test(this.extractResponseStatusCode(response));
            }
            if (this.getSettings().getRequestResponseMode() == RequestResponseMode.REQUEST_AND_RESPONSE) {
                if (throwedException == null) {
                    Response postmanResponse = this.processResponse(response, singleItem, singleItem.getRequest());
                    String postmanResponseName = this.extractResponseName(request, response);
                    postmanResponse.setName(postmanResponseName);
                } else {
                    ArrayList<Response> responses = new ArrayList<Response>();
                    Response postmanResponse = new Response();
                    postmanResponse.setName(throwedException.getClass().getName());
                    responses.add(postmanResponse);
                    singleItem.setResponse(responses);
                    throw throwedException;
                }
            }
            Resp Resp = response;
            return Resp;
        }
        catch (Exception e) {
            if (this.getSettings().getSelectedExceptions().stream().anyMatch(className -> StringUtils.containsIgnoreCase((CharSequence)e.getClass().getName(), (CharSequence)className))) {
                saveToCollection = true;
            }
            throw e;
        }
        finally {
            log.debug("Request executed.");
            if (saveToCollection) {
                log.debug("Collection saved.");
                if (folder != null) {
                    folder.getItem().add(singleItem);
                } else {
                    postmanCollection.getItem().add(singleItem);
                }
                if (this.getSettings().isLogWhenChanged()) {
                    log.info(ConverterUtils.toJsonString(postmanCollection));
                }
            }
        }
    }

    private Items createSingleItem(Req request) throws IOException {
        Items singleItem = new Items();
        singleItem.setName(this.generateRequestName(request));
        singleItem.setId(UUID.randomUUID().toString());
        RequestUnion requestUnion = new RequestUnion();
        RequestClass requestClass = new RequestClass();
        requestClass.setMethod(this.extractRequestMethodName(request));
        URL requestURL = new URL();
        requestURL.setStringValue(this.extractRequestUrl(request));
        requestClass.setUrl(requestURL);
        requestClass.setBody(this.fillRequestBody(request));
        requestUnion.setRequestClassValue(requestClass);
        HeaderUnion headerUnion = new HeaderUnion();
        List<Header> headers = this.extractRequestHeaders(request);
        headerUnion.setHeaderArrayValue(headers);
        requestClass.setHeader(headerUnion);
        singleItem.setRequest(requestUnion);
        return singleItem;
    }

    private Body fillRequestBody(Req request) {
        Body body = new Body();
        body.setDisabled(true);
        if (this.getSettings().isEnableRequestBody()) {
            if (this.hasRequestBody(request)) {
                body.setDisabled(false);
                body.setMode(Mode.RAW);
                body.setRaw(this.extractRequestBody(request));
            }
            if (this.hasRequestFormData(request)) {
                body.setDisabled(false);
                body.setMode(Mode.FORMDATA);
                body.setFormdata(this.extractRequestFormData(request));
            }
        }
        return body;
    }

    private Response processResponse(Resp response, Items singleItem, RequestUnion requestUnion) throws IOException {
        ArrayList<Response> responses = new ArrayList<Response>();
        singleItem.setResponse(responses);
        Response postmanResponse = new Response();
        postmanResponse.setCode(Long.valueOf(this.extractResponseStatusCode(response)));
        postmanResponse.setStatus(this.extractResponseReasonPhrase(response));
        postmanResponse.setOriginalRequest(requestUnion);
        if (this.getSettings().isEnableResponseBody() && this.hasResponseBody(response)) {
            postmanResponse.setBody(this.extractResponseBody(response));
        }
        Headers responseHeaders = new Headers();
        List<HeaderElement> responseHeadersList = this.extractResponseHeaders(response);
        responseHeaders.setUnionArrayValue(responseHeadersList);
        postmanResponse.setHeader(responseHeaders);
        responses.add(postmanResponse);
        return postmanResponse;
    }
}

