/*
 * Decompiled with CFR 0.152.
 */
package dev.jora.postman4j.models;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import dev.jora.postman4j.models.PathClass;
import java.io.IOException;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
public class PathElement {
    public PathClass pathClassValue;
    public String stringValue;

    static class Serializer
    extends JsonSerializer<PathElement> {
        Serializer() {
        }

        public void serialize(PathElement obj, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (obj.pathClassValue != null) {
                jsonGenerator.writeObject((Object)obj.pathClassValue);
                return;
            }
            if (obj.stringValue != null) {
                jsonGenerator.writeObject((Object)obj.stringValue);
                return;
            }
            throw new IOException("PathElement must not be null");
        }
    }

    static class Deserializer
    extends JsonDeserializer<PathElement> {
        Deserializer() {
        }

        public PathElement deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            PathElement value = new PathElement();
            switch (jsonParser.currentToken()) {
                case VALUE_STRING: {
                    String string;
                    value.stringValue = string = (String)jsonParser.readValueAs(String.class);
                    break;
                }
                case START_OBJECT: {
                    value.pathClassValue = (PathClass)jsonParser.readValueAs(PathClass.class);
                    break;
                }
                default: {
                    throw new IOException("Cannot deserialize PathElement");
                }
            }
            return value;
        }
    }
}

