/*
 * Decompiled with CFR 0.152.
 */
package dev.jordond.compass.geocoder.web.google.internal;

import dev.jordond.compass.Coordinates;
import dev.jordond.compass.InternalCompassApi;
import dev.jordond.compass.Place;
import dev.jordond.compass.geocoder.exception.GeocodeException;
import dev.jordond.compass.geocoder.web.google.internal.AddressComponentResponse;
import dev.jordond.compass.geocoder.web.google.internal.AddressComponentType;
import dev.jordond.compass.geocoder.web.google.internal.GeocodeResponse;
import dev.jordond.compass.geocoder.web.google.internal.GeometryResponse;
import dev.jordond.compass.geocoder.web.google.internal.LocationResponse;
import dev.jordond.compass.geocoder.web.google.internal.ResultResponse;
import dev.jordond.compass.geocoder.web.google.internal.ResultResponseKt;
import dev.jordond.compass.geocoder.web.google.internal.StatusResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0003H\u0007\u001a\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0001*\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0000\u001a\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001*\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0007\u00a8\u0006\b"}, d2={"resultsOrThrow", "", "Ldev/jordond/compass/geocoder/web/google/internal/ResultResponse;", "Ldev/jordond/compass/geocoder/web/google/internal/GeocodeResponse;", "toCoordinates", "Ldev/jordond/compass/Coordinates;", "toPlaces", "Ldev/jordond/compass/Place;", "compass-geocoder-web-googlemaps_release"})
@SourceDebugExtension(value={"SMAP\nGeocodeResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeocodeResponse.kt\ndev/jordond/compass/geocoder/web/google/internal/GeocodeResponseKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1603#2,9:72\n1855#2:81\n1856#2:83\n1612#2:84\n1603#2,9:85\n1855#2:94\n1856#2:97\n1612#2:98\n1#3:82\n1#3:95\n1#3:96\n*S KotlinDebug\n*F\n+ 1 GeocodeResponse.kt\ndev/jordond/compass/geocoder/web/google/internal/GeocodeResponseKt\n*L\n41#1:72,9\n41#1:81\n41#1:83\n41#1:84\n49#1:85,9\n49#1:94\n49#1:97\n49#1:98\n41#1:82\n49#1:96\n*E\n"})
public final class GeocodeResponseKt {
    @InternalCompassApi
    @NotNull
    public static final List<ResultResponse> resultsOrThrow(@NotNull GeocodeResponse $this$resultsOrThrow) {
        Intrinsics.checkNotNullParameter((Object)$this$resultsOrThrow, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$resultsOrThrow.getStatus().ordinal()]) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new GeocodeException("[" + $this$resultsOrThrow.getStatus() + "] " + $this$resultsOrThrow.getErrorMessage());
            }
        }
        return $this$resultsOrThrow.getResults();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Coordinates> toCoordinates(@NotNull List<ResultResponse> $this$toCoordinates) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toCoordinates, (String)"<this>");
        Iterable $this$mapNotNull$iv = $this$toCoordinates;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Coordinates coordinates;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ResultResponse response = (ResultResponse)element$iv$iv;
            boolean bl2 = false;
            Object object = response.getGeometry();
            if (object == null || (object = ((GeometryResponse)object).getLocation()) == null) {
                coordinates = null;
            } else {
                Object location = object;
                coordinates = new Coordinates(((LocationResponse)location).getLat(), ((LocationResponse)location).getLng());
            }
            if (coordinates == null) continue;
            Coordinates it$iv$iv = coordinates;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @InternalCompassApi
    @NotNull
    public static final List<Place> toPlaces(@NotNull List<ResultResponse> $this$toPlaces) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toPlaces, (String)"<this>");
        Iterable $this$mapNotNull$iv = $this$toPlaces;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ResultResponse response = (ResultResponse)element$iv$iv;
            boolean bl2 = false;
            List<AddressComponentResponse> components = response.getAddressComponents();
            AddressComponentResponse country = ResultResponseKt.find(components, AddressComponentType.Country);
            Object object2 = response.getGeometry();
            if (object2 == null || (object2 = ((GeometryResponse)object2).getLocation()) == null) {
                object = null;
            } else {
                Place place;
                Object $this$toPlaces_u24lambda_u243_u24lambda_u241 = object2;
                boolean bl3 = false;
                Coordinates coordinates = new Coordinates(((LocationResponse)$this$toPlaces_u24lambda_u243_u24lambda_u241).getLat(), ((LocationResponse)$this$toPlaces_u24lambda_u243_u24lambda_u241).getLng());
                AddressComponentResponse addressComponentResponse = ResultResponseKt.find(components, AddressComponentType.Name);
                String string = addressComponentResponse != null ? addressComponentResponse.getLong() : null;
                String string2 = response.getFormattedAddress();
                AddressComponentResponse addressComponentResponse2 = country;
                String string3 = addressComponentResponse2 != null ? addressComponentResponse2.getShort() : null;
                AddressComponentResponse addressComponentResponse3 = country;
                String string4 = addressComponentResponse3 != null ? addressComponentResponse3.getLong() : null;
                AddressComponentResponse addressComponentResponse4 = ResultResponseKt.find(components, AddressComponentType.PostalCode);
                String string5 = addressComponentResponse4 != null ? addressComponentResponse4.getLong() : null;
                AddressComponentResponse addressComponentResponse5 = ResultResponseKt.find(components, AddressComponentType.AdministrativeAreaLevel1);
                String string6 = addressComponentResponse5 != null ? addressComponentResponse5.getLong() : null;
                AddressComponentResponse addressComponentResponse6 = ResultResponseKt.find(components, AddressComponentType.AdministrativeAreaLevel2);
                String string7 = addressComponentResponse6 != null ? addressComponentResponse6.getLong() : null;
                Object object3 = ResultResponseKt.find(components, AddressComponentType.Locality);
                if (object3 == null || (object3 = ((AddressComponentResponse)object3).getLong()) == null) {
                    AddressComponentResponse addressComponentResponse7 = ResultResponseKt.find(components, AddressComponentType.AdministrativeAreaLevel3);
                    object3 = addressComponentResponse7 != null ? addressComponentResponse7.getLong() : null;
                }
                AddressComponentResponse addressComponentResponse8 = ResultResponseKt.find(components, AddressComponentType.Neighborhood);
                AddressComponentResponse addressComponentResponse9 = ResultResponseKt.find(components, AddressComponentType.Thoroughfare);
                Place it = place = new Place(coordinates, string, string2, string3, string4, string5, string6, string7, (String)object3, addressComponentResponse8 != null ? addressComponentResponse8.getLong() : null, addressComponentResponse9 != null ? addressComponentResponse9.getLong() : null, null);
                boolean bl4 = false;
                object = !it.isEmpty() ? place : null;
            }
            if (object == null) continue;
            Place it$iv$iv = object;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StatusResponse.values().length];
            try {
                nArray[StatusResponse.Ok.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StatusResponse.ZeroResults.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

