/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nms;

import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.SafeVarHandle;
import dev.jorel.commandapi.arguments.ArgumentSubType;
import dev.jorel.commandapi.arguments.SuggestionProviders;
import dev.jorel.commandapi.commandsenders.AbstractCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitNativeProxyCommandSender;
import dev.jorel.commandapi.exceptions.UnimplementedArgumentException;
import dev.jorel.commandapi.nms.NMSWrapper_1_15;
import dev.jorel.commandapi.wrappers.ComplexRecipeImpl;
import dev.jorel.commandapi.wrappers.FloatRange;
import dev.jorel.commandapi.wrappers.FunctionWrapper;
import dev.jorel.commandapi.wrappers.IntegerRange;
import dev.jorel.commandapi.wrappers.Location2D;
import dev.jorel.commandapi.wrappers.MathOperation;
import dev.jorel.commandapi.wrappers.NativeProxyCommandSender;
import dev.jorel.commandapi.wrappers.ParticleData;
import dev.jorel.commandapi.wrappers.Rotation;
import dev.jorel.commandapi.wrappers.ScoreboardSlot;
import dev.jorel.commandapi.wrappers.SimpleFunctionWrapper;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.server.v1_15_R1.Advancement;
import net.minecraft.server.v1_15_R1.ArgumentBlockPredicate;
import net.minecraft.server.v1_15_R1.ArgumentChat;
import net.minecraft.server.v1_15_R1.ArgumentChatComponent;
import net.minecraft.server.v1_15_R1.ArgumentChatFormat;
import net.minecraft.server.v1_15_R1.ArgumentCriterionValue;
import net.minecraft.server.v1_15_R1.ArgumentDimension;
import net.minecraft.server.v1_15_R1.ArgumentEnchantment;
import net.minecraft.server.v1_15_R1.ArgumentEntity;
import net.minecraft.server.v1_15_R1.ArgumentEntitySummon;
import net.minecraft.server.v1_15_R1.ArgumentItemPredicate;
import net.minecraft.server.v1_15_R1.ArgumentItemStack;
import net.minecraft.server.v1_15_R1.ArgumentMathOperation;
import net.minecraft.server.v1_15_R1.ArgumentMinecraftKeyRegistered;
import net.minecraft.server.v1_15_R1.ArgumentMobEffect;
import net.minecraft.server.v1_15_R1.ArgumentNBTTag;
import net.minecraft.server.v1_15_R1.ArgumentParticle;
import net.minecraft.server.v1_15_R1.ArgumentPosition;
import net.minecraft.server.v1_15_R1.ArgumentPredicateItemStack;
import net.minecraft.server.v1_15_R1.ArgumentProfile;
import net.minecraft.server.v1_15_R1.ArgumentRegistry;
import net.minecraft.server.v1_15_R1.ArgumentRotation;
import net.minecraft.server.v1_15_R1.ArgumentRotationAxis;
import net.minecraft.server.v1_15_R1.ArgumentScoreboardCriteria;
import net.minecraft.server.v1_15_R1.ArgumentScoreboardObjective;
import net.minecraft.server.v1_15_R1.ArgumentScoreboardSlot;
import net.minecraft.server.v1_15_R1.ArgumentScoreboardTeam;
import net.minecraft.server.v1_15_R1.ArgumentScoreholder;
import net.minecraft.server.v1_15_R1.ArgumentTag;
import net.minecraft.server.v1_15_R1.ArgumentTile;
import net.minecraft.server.v1_15_R1.ArgumentTime;
import net.minecraft.server.v1_15_R1.ArgumentVec2;
import net.minecraft.server.v1_15_R1.ArgumentVec2I;
import net.minecraft.server.v1_15_R1.ArgumentVec3;
import net.minecraft.server.v1_15_R1.BlockPosition;
import net.minecraft.server.v1_15_R1.BlockPosition2D;
import net.minecraft.server.v1_15_R1.CommandListenerWrapper;
import net.minecraft.server.v1_15_R1.CompletionProviders;
import net.minecraft.server.v1_15_R1.CriterionConditionValue;
import net.minecraft.server.v1_15_R1.CustomFunction;
import net.minecraft.server.v1_15_R1.CustomFunctionData;
import net.minecraft.server.v1_15_R1.Entity;
import net.minecraft.server.v1_15_R1.EntityPlayer;
import net.minecraft.server.v1_15_R1.EntitySelector;
import net.minecraft.server.v1_15_R1.EntityTypes;
import net.minecraft.server.v1_15_R1.EnumChatFormat;
import net.minecraft.server.v1_15_R1.EnumDirection;
import net.minecraft.server.v1_15_R1.IBlockData;
import net.minecraft.server.v1_15_R1.IChatBaseComponent;
import net.minecraft.server.v1_15_R1.ICompletionProvider;
import net.minecraft.server.v1_15_R1.IRecipe;
import net.minecraft.server.v1_15_R1.IRegistry;
import net.minecraft.server.v1_15_R1.IWorldReader;
import net.minecraft.server.v1_15_R1.MinecraftKey;
import net.minecraft.server.v1_15_R1.MinecraftServer;
import net.minecraft.server.v1_15_R1.NBTTagCompound;
import net.minecraft.server.v1_15_R1.ParticleParam;
import net.minecraft.server.v1_15_R1.ParticleParamBlock;
import net.minecraft.server.v1_15_R1.ParticleParamItem;
import net.minecraft.server.v1_15_R1.ParticleParamRedstone;
import net.minecraft.server.v1_15_R1.ParticleType;
import net.minecraft.server.v1_15_R1.ShapeDetectorBlock;
import net.minecraft.server.v1_15_R1.Vec2F;
import net.minecraft.server.v1_15_R1.Vec3D;
import org.bukkit.Axis;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Server;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_15_R1.CraftLootTable;
import org.bukkit.craftbukkit.v1_15_R1.CraftParticle;
import org.bukkit.craftbukkit.v1_15_R1.CraftServer;
import org.bukkit.craftbukkit.v1_15_R1.CraftSound;
import org.bukkit.craftbukkit.v1_15_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_15_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_15_R1.command.BukkitCommandWrapper;
import org.bukkit.craftbukkit.v1_15_R1.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_15_R1.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_15_R1.help.CustomHelpTopic;
import org.bukkit.craftbukkit.v1_15_R1.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_15_R1.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_15_R1.util.CraftChatMessage;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ComplexRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootTable;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Team;

public class NMS_1_15
extends NMSWrapper_1_15 {
    private static final SafeVarHandle<SimpleHelpMap, Map<String, HelpTopic>> helpMapTopics = SafeVarHandle.ofOrNull(SimpleHelpMap.class, "helpTopics", "helpTopics", Map.class);
    private static final Field entitySelectorCheckPermissions = CommandAPIHandler.getField(EntitySelector.class, "checkPermissions", "checkPermissions");
    private static final SafeVarHandle<ParticleParamBlock, IBlockData> particleParamBlockData = SafeVarHandle.ofOrNull(ParticleParamBlock.class, "c", "c", IBlockData.class);
    private static final SafeVarHandle<ParticleParamItem, net.minecraft.server.v1_15_R1.ItemStack> particleParamItemStack = SafeVarHandle.ofOrNull(ParticleParamItem.class, "c", "c", net.minecraft.server.v1_15_R1.ItemStack.class);
    private static final SafeVarHandle<ParticleParamRedstone, Float> particleParamRedstoneSize = SafeVarHandle.ofOrNull(ParticleParamRedstone.class, "f", "f", Float.TYPE);
    private static final SafeVarHandle<ArgumentPredicateItemStack, NBTTagCompound> itemStackPredicateArgument = SafeVarHandle.ofOrNull(ArgumentPredicateItemStack.class, "c", "c", NBTTagCompound.class);
    private static final SafeVarHandle<CraftSound, String> craftSoundMinecraftKey = SafeVarHandle.ofOrNull(CraftSound.class, "minecraftKey", "minecraftKey", String.class);
    private static final SafeVarHandle<EnumChatFormat, Integer> enumChatFormatD = SafeVarHandle.ofOrNull(EnumChatFormat.class, "D", "D", Integer.class);

    private static NamespacedKey fromMinecraftKey(MinecraftKey key) {
        return new NamespacedKey(key.getNamespace(), key.getKey());
    }

    @Override
    public ArgumentType<?> _ArgumentAngle() {
        throw new UnimplementedArgumentException("AngleArgument", "1.16.2");
    }

    @Override
    public ArgumentType<?> _ArgumentAxis() {
        return ArgumentRotationAxis.a();
    }

    @Override
    public ArgumentType<?> _ArgumentBlockPredicate() {
        return ArgumentBlockPredicate.a();
    }

    @Override
    public ArgumentType<?> _ArgumentBlockState() {
        return ArgumentTile.a();
    }

    @Override
    public ArgumentType<?> _ArgumentChat() {
        return ArgumentChat.a();
    }

    @Override
    public ArgumentType<?> _ArgumentChatComponent() {
        return ArgumentChatComponent.a();
    }

    @Override
    public ArgumentType<?> _ArgumentChatFormat() {
        return ArgumentChatFormat.a();
    }

    @Override
    public ArgumentType<?> _ArgumentDimension() {
        return ArgumentDimension.a();
    }

    @Override
    public ArgumentType<?> _ArgumentEnchantment() {
        return ArgumentEnchantment.a();
    }

    @Override
    public ArgumentType<?> _ArgumentEntity(ArgumentSubType subType) {
        return switch (subType) {
            case ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES -> ArgumentEntity.multipleEntities();
            case ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS -> ArgumentEntity.d();
            case ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY -> ArgumentEntity.a();
            case ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER -> ArgumentEntity.c();
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    @Override
    public ArgumentType<?> _ArgumentEntitySummon() {
        return ArgumentEntitySummon.a();
    }

    @Override
    public ArgumentType<?> _ArgumentFloatRange() {
        return new ArgumentCriterionValue.a();
    }

    @Override
    public ArgumentType<?> _ArgumentIntRange() {
        return new ArgumentCriterionValue.b();
    }

    @Override
    public ArgumentType<?> _ArgumentItemPredicate() {
        return ArgumentItemPredicate.a();
    }

    @Override
    public ArgumentType<?> _ArgumentItemStack() {
        return ArgumentItemStack.a();
    }

    @Override
    public ArgumentType<?> _ArgumentMathOperation() {
        return ArgumentMathOperation.a();
    }

    @Override
    public ArgumentType<?> _ArgumentMinecraftKeyRegistered() {
        return ArgumentMinecraftKeyRegistered.a();
    }

    @Override
    public ArgumentType<?> _ArgumentMobEffect() {
        return ArgumentMobEffect.a();
    }

    @Override
    public ArgumentType<?> _ArgumentNBTCompound() {
        return ArgumentNBTTag.a();
    }

    @Override
    public ArgumentType<?> _ArgumentParticle() {
        return ArgumentParticle.a();
    }

    @Override
    public ArgumentType<?> _ArgumentPosition() {
        return ArgumentPosition.a();
    }

    @Override
    public ArgumentType<?> _ArgumentPosition2D() {
        return ArgumentVec2I.a();
    }

    @Override
    public ArgumentType<?> _ArgumentProfile() {
        return ArgumentProfile.a();
    }

    @Override
    public ArgumentType<?> _ArgumentRotation() {
        return ArgumentRotation.a();
    }

    @Override
    public ArgumentType<?> _ArgumentScoreboardCriteria() {
        return ArgumentScoreboardCriteria.a();
    }

    @Override
    public ArgumentType<?> _ArgumentScoreboardObjective() {
        return ArgumentScoreboardObjective.a();
    }

    @Override
    public ArgumentType<?> _ArgumentScoreboardSlot() {
        return ArgumentScoreboardSlot.a();
    }

    @Override
    public ArgumentType<?> _ArgumentScoreboardTeam() {
        return ArgumentScoreboardTeam.a();
    }

    @Override
    public final ArgumentType<?> _ArgumentScoreholder(ArgumentSubType subType) {
        return switch (subType) {
            case ArgumentSubType.SCOREHOLDER_SINGLE -> ArgumentScoreholder.a();
            case ArgumentSubType.SCOREHOLDER_MULTIPLE -> ArgumentScoreholder.b();
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    @Override
    public ArgumentType<?> _ArgumentSyntheticBiome() {
        throw new UnimplementedArgumentException("BiomeArgument", "1.16");
    }

    @Override
    public ArgumentType<?> _ArgumentTag() {
        return ArgumentTag.a();
    }

    @Override
    public ArgumentType<?> _ArgumentTime() {
        return ArgumentTime.a();
    }

    @Override
    public ArgumentType<?> _ArgumentUUID() {
        throw new UnimplementedArgumentException("UUIDArgument", "1.16");
    }

    @Override
    public ArgumentType<?> _ArgumentVec2(boolean centerPosition) {
        return new ArgumentVec2(centerPosition);
    }

    @Override
    public ArgumentType<?> _ArgumentVec3(boolean centerPosition) {
        return ArgumentVec3.a((boolean)centerPosition);
    }

    @Override
    public Map<String, HelpTopic> getHelpMap() {
        return helpMapTopics.get((SimpleHelpMap)Bukkit.getHelpMap());
    }

    @Override
    public String[] compatibleVersions() {
        return new String[]{"1.15", "1.15.1", "1.15.2"};
    }

    @Override
    public String convert(ItemStack is) {
        return is.getType().getKey().toString() + CraftItemStack.asNMSCopy((ItemStack)is).getOrCreateTag().toString();
    }

    @Override
    public String convert(ParticleData<?> particle) {
        return CraftParticle.toNMS((Particle)particle.particle(), particle.data()).a();
    }

    @Override
    public String convert(PotionEffectType potion) {
        return potion.getName().toLowerCase(Locale.ENGLISH);
    }

    @Override
    public String convert(Sound sound) {
        return CraftSound.getSound((Sound)sound);
    }

    private SimpleFunctionWrapper convertFunction(CustomFunction customFunction) {
        ToIntFunction<CommandListenerWrapper> appliedObj = clw -> ((MinecraftServer)this.getMinecraftServer()).getFunctionData().a(customFunction, clw);
        CustomFunction.c[] cArr = customFunction.b();
        String[] result = new String[cArr.length];
        int size = cArr.length;
        for (int i = 0; i < size; ++i) {
            result[i] = cArr[i].toString();
        }
        return new SimpleFunctionWrapper(NMS_1_15.fromMinecraftKey(customFunction.a()), appliedObj, result);
    }

    @Override
    public void createDispatcherFile(File file, CommandDispatcher<CommandListenerWrapper> dispatcher) throws IOException {
        Files.write((CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)ArgumentRegistry.a(dispatcher, (CommandNode)dispatcher.getRoot())), (File)file, (Charset)StandardCharsets.UTF_8);
    }

    @Override
    public HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return new CustomHelpTopic(commandName, shortDescription, fullDescription, permission);
    }

    @Override
    public org.bukkit.advancement.Advancement getAdvancement(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentMinecraftKeyRegistered.a(cmdCtx, (String)key).bukkit;
    }

    @Override
    public Component getAdventureChat(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return GsonComponentSerializer.gson().deserialize((Object)IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChat.a(cmdCtx, (String)key)));
    }

    @Override
    public NamedTextColor getAdventureChatColor(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        Integer color = enumChatFormatD.get(ArgumentChatFormat.a(cmdCtx, (String)key));
        return color == null ? NamedTextColor.WHITE : NamedTextColor.namedColor((int)color);
    }

    @Override
    public Component getAdventureChatComponent(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return GsonComponentSerializer.gson().deserialize((Object)IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChatComponent.a(cmdCtx, (String)key)));
    }

    @Override
    public float getAngle(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        throw new UnimplementedArgumentException("AngleArgument", "1.16.2");
    }

    @Override
    public EnumSet<Axis> getAxis(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        EnumSet<Axis> set = EnumSet.noneOf(Axis.class);
        EnumSet parsedEnumSet = ArgumentRotationAxis.a(cmdCtx, (String)key);
        for (EnumDirection.EnumAxis element : parsedEnumSet) {
            set.add(switch (element) {
                default -> throw new IncompatibleClassChangeError();
                case EnumDirection.EnumAxis.X -> Axis.X;
                case EnumDirection.EnumAxis.Y -> Axis.Y;
                case EnumDirection.EnumAxis.Z -> Axis.Z;
            });
        }
        return set;
    }

    @Override
    public Object getBiome(CommandContext<CommandListenerWrapper> cmdCtx, String key, ArgumentSubType subType) throws CommandSyntaxException {
        throw new UnimplementedArgumentException("BiomeArgument", "1.16");
    }

    @Override
    public Predicate<Block> getBlockPredicate(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = ArgumentBlockPredicate.a(cmdCtx, (String)key);
        return block -> predicate.test(new ShapeDetectorBlock((IWorldReader)((CommandListenerWrapper)cmdCtx.getSource()).getWorld(), new BlockPosition(block.getX(), block.getY(), block.getZ()), true));
    }

    @Override
    public BlockData getBlockState(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return CraftBlockData.fromData((IBlockData)ArgumentTile.a(cmdCtx, (String)key).a());
    }

    @Override
    public CommandDispatcher<CommandListenerWrapper> getBrigadierDispatcher() {
        return ((MinecraftServer)this.getMinecraftServer()).vanillaCommandDispatcher.a();
    }

    @Override
    public CommandDispatcher<CommandListenerWrapper> getResourcesDispatcher() {
        return ((MinecraftServer)this.getMinecraftServer()).getCommandDispatcher().a();
    }

    @Override
    public BaseComponent[] getChat(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ComponentSerializer.parse((String)IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChat.a(cmdCtx, (String)key)));
    }

    @Override
    public ChatColor getChatColor(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return CraftChatMessage.getColor((EnumChatFormat)ArgumentChatFormat.a(cmdCtx, (String)key));
    }

    @Override
    public BaseComponent[] getChatComponent(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return ComponentSerializer.parse((String)IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChatComponent.a(cmdCtx, (String)key)));
    }

    @Override
    public CommandListenerWrapper getBrigadierSourceFromCommandSender(AbstractCommandSender<? extends CommandSender> senderWrapper) {
        return VanillaCommandWrapper.getListener((CommandSender)senderWrapper.getSource());
    }

    @Override
    public BukkitCommandSender<? extends CommandSender> getCommandSenderFromCommandSource(CommandListenerWrapper clw) {
        try {
            return this.wrapCommandSender(clw.getBukkitSender());
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    @Override
    public World getDimension(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return ((MinecraftServer)this.getMinecraftServer()).getWorldServer(ArgumentDimension.a(cmdCtx, (String)key)).getWorld();
    }

    @Override
    public Enchantment getEnchantment(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return new CraftEnchantment(ArgumentEnchantment.a(cmdCtx, (String)key));
    }

    @Override
    public Object getEntitySelector(CommandContext<CommandListenerWrapper> cmdCtx, String str, ArgumentSubType subType) throws CommandSyntaxException {
        EntitySelector argument = (EntitySelector)cmdCtx.getArgument(str, EntitySelector.class);
        try {
            entitySelectorCheckPermissions.set(argument, false);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return switch (subType) {
            case ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES -> {
                try {
                    ArrayList<CraftEntity> result = new ArrayList<CraftEntity>();
                    for (Entity entity : argument.getEntities((CommandListenerWrapper)cmdCtx.getSource())) {
                        result.add(entity.getBukkitEntity());
                    }
                    ArrayList<CraftEntity> var5_6 = result;
                    yield var5_6;
                }
                catch (CommandSyntaxException e) {
                    CraftEntity var5_7;
                    yield var5_7 = new ArrayList();
                }
            }
            case ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS -> {
                try {
                    ArrayList<CraftPlayer> result = new ArrayList<CraftPlayer>();
                    for (EntityPlayer player : argument.d((CommandListenerWrapper)cmdCtx.getSource())) {
                        result.add(player.getBukkitEntity());
                    }
                    ArrayList<CraftPlayer> var5_8 = result;
                    yield var5_8;
                }
                catch (CommandSyntaxException e) {
                    ArrayList var5_9 = new ArrayList();
                    yield var5_9;
                }
            }
            case ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY -> {
                CraftEntity var5_10;
                yield var5_10 = argument.a((CommandListenerWrapper)cmdCtx.getSource()).getBukkitEntity();
            }
            case ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER -> {
                CraftPlayer var5_11 = argument.c((CommandListenerWrapper)cmdCtx.getSource()).getBukkitEntity();
                yield var5_11;
            }
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    @Override
    public EntityType getEntityType(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ((EntityTypes)IRegistry.ENTITY_TYPE.get(ArgumentEntitySummon.a(cmdCtx, (String)key))).a((net.minecraft.server.v1_15_R1.World)((CraftWorld)this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource())).getHandle()).getBukkitEntity().getType();
    }

    @Override
    public FloatRange getFloatRange(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        CriterionConditionValue.FloatRange range = (CriterionConditionValue.FloatRange)cmdCtx.getArgument(key, CriterionConditionValue.FloatRange.class);
        float low = range.a() == null ? -3.4028235E38f : ((Float)range.a()).floatValue();
        float high = range.b() == null ? Float.MAX_VALUE : ((Float)range.b()).floatValue();
        return new FloatRange(low, high);
    }

    @Override
    public FunctionWrapper[] getFunction(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        ArrayList<FunctionWrapper> result = new ArrayList<FunctionWrapper>();
        CommandListenerWrapper commandListenerWrapper = ((CommandListenerWrapper)cmdCtx.getSource()).a().b(2);
        for (CustomFunction customFunction : ArgumentTag.a(cmdCtx, (String)key)) {
            result.add(FunctionWrapper.fromSimpleFunctionWrapper(this.convertFunction(customFunction), commandListenerWrapper, e -> ((CommandListenerWrapper)cmdCtx.getSource()).a(((CraftEntity)e).getHandle())));
        }
        return result.toArray(new FunctionWrapper[0]);
    }

    @Override
    public SimpleFunctionWrapper getFunction(NamespacedKey key) {
        return this.convertFunction((CustomFunction)((MinecraftServer)this.getMinecraftServer()).getFunctionData().a(new MinecraftKey(key.getNamespace(), key.getKey())).get());
    }

    @Override
    public Set<NamespacedKey> getFunctions() {
        HashSet<NamespacedKey> functions = new HashSet<NamespacedKey>();
        for (MinecraftKey key : ((MinecraftServer)this.getMinecraftServer()).getFunctionData().c().keySet()) {
            functions.add(NMS_1_15.fromMinecraftKey(key));
        }
        return functions;
    }

    @Override
    public IntegerRange getIntRange(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        CriterionConditionValue.IntegerRange range = ArgumentCriterionValue.b.a(cmdCtx, (String)key);
        int low = range.a() == null ? Integer.MIN_VALUE : (Integer)range.a();
        int high = range.b() == null ? Integer.MAX_VALUE : (Integer)range.b();
        return new IntegerRange(low, high);
    }

    @Override
    public ItemStack getItemStack(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        ArgumentPredicateItemStack input = ArgumentItemStack.a(cmdCtx, (String)key);
        net.minecraft.server.v1_15_R1.ItemStack itemWithMaybeTag = input.a(1, false);
        NBTTagCompound tag = itemStackPredicateArgument.get(input);
        if (tag != null) {
            byte count = tag.getByte("Count");
            itemWithMaybeTag = input.a((int)(count == 0 ? (byte)1 : count), false);
        }
        ItemStack result = CraftItemStack.asBukkitCopy((net.minecraft.server.v1_15_R1.ItemStack)itemWithMaybeTag);
        result.setItemMeta(CraftItemStack.getItemMeta((net.minecraft.server.v1_15_R1.ItemStack)itemWithMaybeTag));
        return result;
    }

    @Override
    public Predicate<ItemStack> getItemStackPredicate(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = ArgumentItemPredicate.a(cmdCtx, (String)key);
        return item -> predicate.test(CraftItemStack.asNMSCopy((ItemStack)item));
    }

    @Override
    public Location2D getLocation2DBlock(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        BlockPosition2D blockPos = ArgumentVec2I.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), blockPos.a, blockPos.b);
    }

    @Override
    public Location2D getLocation2DPrecise(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Vec2F vecPos = ArgumentVec2.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), vecPos.i, vecPos.j);
    }

    @Override
    public Location getLocationBlock(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        BlockPosition blockPos = ArgumentPosition.b(cmdCtx, (String)key);
        return new Location(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
    }

    @Override
    public Location getLocationPrecise(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Vec3D vecPos = ArgumentVec3.a(cmdCtx, (String)key);
        return new Location(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), vecPos.x, vecPos.y, vecPos.z);
    }

    @Override
    public LootTable getLootTable(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        MinecraftKey minecraftKey = ArgumentMinecraftKeyRegistered.d(cmdCtx, (String)key);
        return new CraftLootTable(NMS_1_15.fromMinecraftKey(minecraftKey), ((MinecraftServer)this.getMinecraftServer()).getLootTableRegistry().getLootTable(minecraftKey));
    }

    @Override
    public MathOperation getMathOperation(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        ArgumentMathOperation.a(cmdCtx, (String)key);
        return MathOperation.fromString(CommandAPIHandler.getRawArgumentInput(cmdCtx, key));
    }

    @Override
    public NamespacedKey getMinecraftKey(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        MinecraftKey resourceLocation = ArgumentMinecraftKeyRegistered.d(cmdCtx, (String)key);
        return new NamespacedKey(resourceLocation.getNamespace(), resourceLocation.getKey());
    }

    @Override
    public <NBTContainer> Object getNBTCompound(CommandContext<CommandListenerWrapper> cmdCtx, String key, Function<Object, NBTContainer> nbtContainerConstructor) {
        return nbtContainerConstructor.apply(ArgumentNBTTag.a(cmdCtx, (String)key));
    }

    @Override
    public Objective getObjective(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws IllegalArgumentException, CommandSyntaxException {
        String objectiveName = ArgumentScoreboardObjective.a(cmdCtx, (String)key).getName();
        return Bukkit.getScoreboardManager().getMainScoreboard().getObjective(objectiveName);
    }

    @Override
    public String getObjectiveCriteria(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return ArgumentScoreboardCriteria.a(cmdCtx, (String)key).getName();
    }

    @Override
    public OfflinePlayer getOfflinePlayer(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)((GameProfile)ArgumentProfile.a(cmdCtx, (String)key).iterator().next()).getId());
        if (target == null) {
            throw ArgumentProfile.a.create();
        }
        return target;
    }

    @Override
    public ParticleData<?> getParticle(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        ParticleParam particleOptions = ArgumentParticle.a(cmdCtx, (String)key);
        Particle particle = CraftParticle.toBukkit((ParticleParam)particleOptions);
        if (particleOptions instanceof ParticleType) {
            return new ParticleData<Object>(particle, null);
        }
        if (particleOptions instanceof ParticleParamBlock) {
            ParticleParamBlock options = (ParticleParamBlock)particleOptions;
            return new ParticleData<CraftBlockData>(particle, CraftBlockData.fromData((IBlockData)particleParamBlockData.get(options)));
        }
        if (particleOptions instanceof ParticleParamRedstone) {
            ParticleParamRedstone options = (ParticleParamRedstone)particleOptions;
            return this.getParticleDataAsDustOptions(particle, options);
        }
        if (particleOptions instanceof ParticleParamItem) {
            ParticleParamItem options = (ParticleParamItem)particleOptions;
            return new ParticleData<ItemStack>(particle, CraftItemStack.asBukkitCopy((net.minecraft.server.v1_15_R1.ItemStack)particleParamItemStack.get(options)));
        }
        CommandAPI.getLogger().warning("Invalid particle data type for " + particle.getDataType().toString());
        return new ParticleData<Object>(particle, null);
    }

    private ParticleData<Particle.DustOptions> getParticleDataAsDustOptions(Particle particle, ParticleParamRedstone options) {
        String optionsStr = options.a();
        String[] optionsArr = optionsStr.split(" ");
        float red = Float.parseFloat(optionsArr[1]);
        float green = Float.parseFloat(optionsArr[2]);
        float blue = Float.parseFloat(optionsArr[3]);
        Color color = Color.fromRGB((int)((int)(red * 255.0f)), (int)((int)(green * 255.0f)), (int)((int)(blue * 255.0f)));
        return new ParticleData<Particle.DustOptions>(particle, new Particle.DustOptions(color, particleParamRedstoneSize.get(options).floatValue()));
    }

    @Override
    public Player getPlayer(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Player target = Bukkit.getPlayer((UUID)((GameProfile)ArgumentProfile.a(cmdCtx, (String)key).iterator().next()).getId());
        if (target == null) {
            throw ArgumentProfile.a.create();
        }
        return target;
    }

    @Override
    public PotionEffectType getPotionEffect(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return new CraftPotionEffectType(ArgumentMobEffect.a(cmdCtx, (String)key));
    }

    public ComplexRecipe getRecipe(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        IRecipe recipe = ArgumentMinecraftKeyRegistered.b(cmdCtx, (String)key);
        return new ComplexRecipeImpl(NMS_1_15.fromMinecraftKey(recipe.getKey()), recipe.toBukkitRecipe());
    }

    @Override
    public Rotation getRotation(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        Vec2F vec = ArgumentRotation.a(cmdCtx, (String)key).b((CommandListenerWrapper)cmdCtx.getSource());
        return new Rotation(vec.j, vec.i);
    }

    @Override
    public ScoreboardSlot getScoreboardSlot(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return ScoreboardSlot.ofMinecraft(ArgumentScoreboardSlot.a(cmdCtx, (String)key));
    }

    @Override
    public Collection<String> getScoreHolderMultiple(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentScoreholder.b(cmdCtx, (String)key);
    }

    @Override
    public String getScoreHolderSingle(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentScoreholder.a(cmdCtx, (String)key);
    }

    @Override
    public BukkitCommandSender<? extends CommandSender> getSenderForCommand(CommandContext<CommandListenerWrapper> cmdCtx, boolean isNative) {
        CraftEntity proxy;
        CommandListenerWrapper clw = (CommandListenerWrapper)cmdCtx.getSource();
        CommandSender sender = clw.getBukkitSender();
        if (sender == null) {
            sender = Bukkit.getConsoleSender();
        }
        Vec3D pos = clw.getPosition();
        Vec2F rot = clw.i();
        World world = this.getWorldForCSS(clw);
        Location location = new Location(world, pos.getX(), pos.getY(), pos.getZ(), rot.j, rot.i);
        Entity proxyEntity = clw.getEntity();
        CraftEntity craftEntity = proxy = proxyEntity == null ? null : proxyEntity.getBukkitEntity();
        if (isNative || proxy != null && !sender.equals(proxy)) {
            if (proxy == null) {
                proxy = sender;
            }
            return new BukkitNativeProxyCommandSender(new NativeProxyCommandSender(sender, (CommandSender)proxy, location, world));
        }
        return this.wrapCommandSender(sender);
    }

    @Override
    public SimpleCommandMap getSimpleCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    @Override
    public final Object getSound(CommandContext<CommandListenerWrapper> cmdCtx, String key, ArgumentSubType subType) {
        MinecraftKey soundResource = ArgumentMinecraftKeyRegistered.d(cmdCtx, (String)key);
        return switch (subType) {
            case ArgumentSubType.SOUND_SOUND -> {
                for (CraftSound sound : CraftSound.values()) {
                    if (!craftSoundMinecraftKey.get(sound).equals(soundResource.getKey())) continue;
                    yield Sound.valueOf((String)sound.name());
                }
                yield null;
            }
            case ArgumentSubType.SOUND_NAMESPACEDKEY -> NMS_1_15.fromMinecraftKey(soundResource);
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    @Override
    public SuggestionProvider<CommandListenerWrapper> getSuggestionProvider(SuggestionProviders provider) {
        return switch (provider) {
            case SuggestionProviders.FUNCTION -> (context, builder) -> {
                CustomFunctionData functionData = ((MinecraftServer)this.getMinecraftServer()).getFunctionData();
                ICompletionProvider.a((Iterable)functionData.h().a(), (SuggestionsBuilder)builder, (String)"#");
                return ICompletionProvider.a(functionData.c().keySet(), (SuggestionsBuilder)builder);
            };
            case SuggestionProviders.RECIPES -> CompletionProviders.b;
            case SuggestionProviders.SOUNDS -> CompletionProviders.c;
            case SuggestionProviders.ADVANCEMENTS -> (cmdCtx, builder) -> ICompletionProvider.a(((MinecraftServer)this.getMinecraftServer()).getAdvancementData().getAdvancements().stream().map(Advancement::getName), (SuggestionsBuilder)builder);
            case SuggestionProviders.LOOT_TABLES -> (cmdCtx, builder) -> ICompletionProvider.a((Iterable)((MinecraftServer)this.getMinecraftServer()).getLootTableRegistry().a(), (SuggestionsBuilder)builder);
            case SuggestionProviders.ENTITIES -> CompletionProviders.d;
            default -> (context, builder) -> Suggestions.empty();
        };
    }

    @Override
    public SimpleFunctionWrapper[] getTag(NamespacedKey key) {
        ArrayList customFunctions = new ArrayList(((MinecraftServer)this.getMinecraftServer()).getFunctionData().h().b(new MinecraftKey(key.getNamespace(), key.getKey())).a());
        SimpleFunctionWrapper[] result = new SimpleFunctionWrapper[customFunctions.size()];
        int size = customFunctions.size();
        for (int i = 0; i < size; ++i) {
            result[i] = this.convertFunction((CustomFunction)customFunctions.get(i));
        }
        return result;
    }

    @Override
    public Set<NamespacedKey> getTags() {
        HashSet<NamespacedKey> functions = new HashSet<NamespacedKey>();
        for (MinecraftKey key : ((MinecraftServer)this.getMinecraftServer()).getFunctionData().h().a()) {
            functions.add(NMS_1_15.fromMinecraftKey(key));
        }
        return functions;
    }

    @Override
    public Team getTeam(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        String teamName = ArgumentScoreboardTeam.a(cmdCtx, (String)key).getName();
        return Bukkit.getScoreboardManager().getMainScoreboard().getTeam(teamName);
    }

    @Override
    public int getTime(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return (Integer)cmdCtx.getArgument(key, Integer.class);
    }

    @Override
    public UUID getUUID(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        throw new UnimplementedArgumentException("UUIDArgument", "1.16");
    }

    @Override
    public World getWorldForCSS(CommandListenerWrapper clw) {
        return clw.getWorld() == null ? null : clw.getWorld().getWorld();
    }

    @Override
    public boolean isVanillaCommandWrapper(Command command) {
        return command instanceof VanillaCommandWrapper;
    }

    @Override
    public Command wrapToVanillaCommandWrapper(LiteralCommandNode<CommandListenerWrapper> node) {
        return new VanillaCommandWrapper(((MinecraftServer)this.getMinecraftServer()).vanillaCommandDispatcher, node);
    }

    @Override
    public boolean isBukkitCommandWrapper(CommandNode<CommandListenerWrapper> node) {
        return node.getCommand() instanceof BukkitCommandWrapper;
    }

    @Override
    public void reloadDataPacks() {
    }

    @Override
    public Message generateMessageFromJson(String json) {
        return IChatBaseComponent.ChatSerializer.a((String)json);
    }

    @Override
    public <T> T getMinecraftServer() {
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            return (T)server2.getServer();
        }
        return null;
    }
}

