/*
 * Decompiled with CFR 0.152.
 */
package dev.keva.ioc;

import dev.keva.ioc.annotation.Autowired;
import dev.keva.ioc.annotation.Bean;
import dev.keva.ioc.annotation.Component;
import dev.keva.ioc.annotation.ComponentScan;
import dev.keva.ioc.annotation.Configuration;
import dev.keva.ioc.annotation.Qualifier;
import dev.keva.ioc.core.BeanContainer;
import dev.keva.ioc.core.CircularDetector;
import dev.keva.ioc.core.ImplementationContainer;
import dev.keva.ioc.exception.IoCBeanNotFound;
import dev.keva.ioc.exception.IoCCircularDepException;
import dev.keva.ioc.exception.IoCException;
import dev.keva.ioc.utils.ClassLoaderUtil;
import dev.keva.ioc.utils.FinderUtil;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class KevaIoC {
    private final BeanContainer beanContainer = new BeanContainer();
    private final ImplementationContainer implementationContainer = new ImplementationContainer();
    private final CircularDetector circularDetector = new CircularDetector();

    private KevaIoC() {
    }

    public static KevaIoC initBeans(Class<?> mainClass, Object ... predefinedBeans) {
        try {
            KevaIoC instance = new KevaIoC();
            instance.initWrapper(mainClass, predefinedBeans);
            return instance;
        }
        catch (IoCBeanNotFound | IoCCircularDepException | IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | URISyntaxException e) {
            throw new IoCException(e);
        }
    }

    public <T> T getBean(Class<T> clazz) {
        try {
            return this._getBean(clazz);
        }
        catch (IoCBeanNotFound | IoCCircularDepException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IoCException(e);
        }
    }

    private void initWrapper(Class<?> mainClass, Object[] predefinedBeans) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, IoCBeanNotFound, IoCCircularDepException, URISyntaxException {
        ComponentScan scan;
        if (predefinedBeans != null && predefinedBeans.length > 0) {
            for (Object bean : predefinedBeans) {
                Class<?>[] interfaces = bean.getClass().getInterfaces();
                if (interfaces.length == 0) {
                    this.implementationContainer.putImplementationClass(bean.getClass(), bean.getClass());
                } else {
                    for (Class<?> interfaceClass : interfaces) {
                        this.implementationContainer.putImplementationClass(bean.getClass(), interfaceClass);
                    }
                }
                this.beanContainer.putBean(bean.getClass(), bean);
            }
        }
        if ((scan = mainClass.getAnnotation(ComponentScan.class)) != null) {
            String[] packages;
            for (String packageName : packages = scan.value()) {
                this.init(packageName);
            }
        } else {
            this.init(mainClass.getPackage().getName());
        }
    }

    private void init(String packageName) throws IOException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, IoCBeanNotFound, IoCCircularDepException, URISyntaxException, ClassNotFoundException {
        this.beanContainer.putBean(KevaIoC.class, this);
        this.implementationContainer.putImplementationClass(KevaIoC.class, KevaIoC.class);
        List<Class<?>> classes = ClassLoaderUtil.getClasses(packageName);
        this.scanImplementations(packageName);
        this.scanConfigurationClass(classes);
        this.scanComponentClasses(classes);
    }

    private void scanImplementations(String packageName) {
        Reflections reflections = new Reflections(packageName, new Scanner[0]);
        Set<Class<?>> componentClasses = reflections.getTypesAnnotatedWith(Component.class);
        for (Class<?> implementationClass : componentClasses) {
            Class<?>[] interfaces = implementationClass.getInterfaces();
            if (interfaces.length == 0) {
                this.implementationContainer.putImplementationClass(implementationClass, implementationClass);
                continue;
            }
            for (Class<?> interfaceClass : interfaces) {
                this.implementationContainer.putImplementationClass(implementationClass, interfaceClass);
            }
        }
        Set<Class<?>> configurationClasses = reflections.getTypesAnnotatedWith(Configuration.class);
        for (Class<?> configurationClass : configurationClasses) {
            Set<Method> methods = FinderUtil.findMethods(configurationClass, Bean.class);
            for (Method method : methods) {
                Class<?> returnType = method.getReturnType();
                this.implementationContainer.putImplementationClass(returnType, returnType);
            }
        }
    }

    private void scanConfigurationClass(List<Class<?>> classes) throws IoCCircularDepException, InvocationTargetException, IllegalAccessException, InstantiationException, NoSuchMethodException {
        ArrayDeque<Class> configurationClassesQ = new ArrayDeque<Class>(5);
        for (Class<?> clazz : classes) {
            if (!clazz.isAnnotationPresent(Configuration.class)) continue;
            configurationClassesQ.add(clazz);
        }
        while (!configurationClassesQ.isEmpty()) {
            Class configurationClass = (Class)configurationClassesQ.removeFirst();
            try {
                Object instance = configurationClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.circularDetector.detect(configurationClass);
                this.scanConfigurationBeans(configurationClass, instance);
            }
            catch (IoCBeanNotFound e) {
                configurationClassesQ.addLast(configurationClass);
            }
        }
    }

    private void scanComponentClasses(List<Class<?>> classes) throws IoCCircularDepException, InvocationTargetException, IllegalAccessException, InstantiationException, NoSuchMethodException, IoCBeanNotFound {
        for (Class<?> clazz : classes) {
            if (!clazz.isAnnotationPresent(Component.class)) continue;
            this.newInstanceWrapper(clazz);
        }
    }

    private void scanConfigurationBeans(Class<?> clazz, Object classInstance) throws InvocationTargetException, IllegalAccessException, InstantiationException, NoSuchMethodException, IoCBeanNotFound, IoCCircularDepException {
        Set<Method> methods = FinderUtil.findMethods(clazz, Bean.class);
        Set<Field> fields = FinderUtil.findFields(clazz, Autowired.class);
        for (Field field : fields) {
            String qualifier = field.isAnnotationPresent(Qualifier.class) ? field.getAnnotation(Qualifier.class).value() : null;
            Object fieldInstance = this._getBean(field.getType(), field.getName(), qualifier, false);
            field.set(classInstance, fieldInstance);
        }
        for (Method method : methods) {
            Class<?> beanType = method.getReturnType();
            Object beanInstance = method.invoke(classInstance, new Object[0]);
            String name = method.getAnnotation(Bean.class).value() != null ? method.getAnnotation(Bean.class).value() : beanType.getName();
            this.beanContainer.putBean(beanType, beanInstance, name);
        }
    }

    private Object newInstanceWrapper(Class<?> clazz) throws InvocationTargetException, IllegalAccessException, InstantiationException, NoSuchMethodException, IoCBeanNotFound, IoCCircularDepException {
        if (this.beanContainer.containsBean(clazz)) {
            return this.beanContainer.getBean(clazz);
        }
        this.circularDetector.detect(clazz);
        Object instance = this.newInstance(clazz);
        this.beanContainer.putBean(clazz, instance);
        this.fieldInject(clazz, instance);
        this.setterInject(clazz, instance);
        return instance;
    }

    private Object newInstance(Class<?> clazz) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException, IoCBeanNotFound, IoCCircularDepException {
        Constructor<?> annotatedConstructor = FinderUtil.findAnnotatedConstructor(clazz);
        if (annotatedConstructor == null) {
            try {
                Constructor<?> defaultConstructor = clazz.getConstructor(new Class[0]);
                defaultConstructor.setAccessible(true);
                Object instance = clazz.newInstance();
                return instance;
            }
            catch (NoSuchMethodException e) {
                throw new IoCException("There is no default constructor in class " + clazz.getName());
            }
        }
        Object[] parameters = new Object[annotatedConstructor.getParameterCount()];
        for (int i = 0; i < parameters.length; ++i) {
            Object depInstance;
            String qualifier = annotatedConstructor.getParameters()[i].isAnnotationPresent(Qualifier.class) ? annotatedConstructor.getParameters()[i].getAnnotation(Qualifier.class).value() : null;
            parameters[i] = depInstance = this._getBean(annotatedConstructor.getParameterTypes()[i], annotatedConstructor.getParameterTypes()[i].getName(), qualifier, true);
        }
        Object instance = annotatedConstructor.newInstance(parameters);
        return instance;
    }

    private void setterInject(Class<?> clazz, Object classInstance) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException, IoCBeanNotFound, IoCCircularDepException {
        Set<Method> methods = FinderUtil.findMethods(clazz, Autowired.class);
        for (Method method : methods) {
            Object[] parameters = new Object[method.getParameterCount()];
            for (int i = 0; i < parameters.length; ++i) {
                Object instance;
                String qualifier = method.getParameters()[i].isAnnotationPresent(Qualifier.class) ? method.getParameters()[i].getAnnotation(Qualifier.class).value() : null;
                parameters[i] = instance = this._getBean(method.getParameterTypes()[i], method.getParameterTypes()[i].getName(), qualifier, true);
            }
            method.invoke(classInstance, parameters);
        }
    }

    private void fieldInject(Class<?> clazz, Object classInstance) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException, IoCBeanNotFound, IoCCircularDepException {
        Set<Field> fields = FinderUtil.findFields(clazz, Autowired.class);
        for (Field field : fields) {
            String qualifier = field.isAnnotationPresent(Qualifier.class) ? field.getAnnotation(Qualifier.class).value() : null;
            Object fieldInstance = this._getBean(field.getType(), field.getName(), qualifier, true);
            field.set(classInstance, fieldInstance);
        }
    }

    private <T> T _getBean(Class<T> interfaceClass) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, IoCBeanNotFound, IoCCircularDepException {
        return (T)this._getBean(interfaceClass, null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Object _getBean(Class<T> interfaceClass, String fieldName, String qualifier, boolean createIfNotFound) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, IoCBeanNotFound, IoCCircularDepException {
        Class<T> implementationClass;
        Class<Object> clazz = implementationClass = interfaceClass.isInterface() ? this.implementationContainer.getImplementationClass(interfaceClass, fieldName, qualifier) : interfaceClass;
        if (this.beanContainer.containsBean(implementationClass)) {
            if (qualifier != null) {
                return this.beanContainer.getBean(implementationClass, qualifier);
            }
            return this.beanContainer.getBean(implementationClass);
        }
        if (createIfNotFound) {
            BeanContainer beanContainer = this.beanContainer;
            synchronized (beanContainer) {
                return this.newInstanceWrapper(implementationClass);
            }
        }
        throw new IoCBeanNotFound("Cannot found bean for " + interfaceClass.getName());
    }
}

