/*
 * Decompiled with CFR 0.152.
 */
package dev.keva.ioc.core;

import dev.keva.ioc.exception.IoCException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ImplementationContainer {
    private final Map<Class<?>, Class<?>> implementationsMap = new HashMap(10);

    public void putImplementationClass(Class<?> implementationClass, Class<?> interfaceClass) {
        this.implementationsMap.put(implementationClass, interfaceClass);
    }

    public Class<?> getImplementationClass(Class<?> interfaceClass, String fieldName, String qualifier) {
        String errorMessage;
        Set implementationClasses = this.implementationsMap.entrySet().stream().filter(entry -> entry.getValue() == interfaceClass).collect(Collectors.toSet());
        if (implementationClasses.isEmpty()) {
            errorMessage = "No implementation found for interface " + interfaceClass.getName();
        } else {
            if (implementationClasses.size() == 1) {
                Optional optional = implementationClasses.stream().findFirst();
                return (Class)((Map.Entry)optional.get()).getKey();
            }
            String findBy = qualifier == null || qualifier.trim().length() == 0 ? fieldName : qualifier;
            Optional<Map.Entry> optional = implementationClasses.stream().filter(entry -> ((Class)entry.getKey()).getSimpleName().equalsIgnoreCase(findBy)).findAny();
            if (optional.isPresent()) {
                return (Class)optional.get().getKey();
            }
            errorMessage = "There are " + implementationClasses.size() + " of interface " + interfaceClass.getName() + " Expected single implementation or make use of @Qualifier to resolve conflict";
        }
        throw new IoCException(errorMessage);
    }
}

