/*
 * Decompiled with CFR 0.152.
 */
package dev.keva.ioc.utils;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class ClassLoaderUtil {
    public static List<Class<?>> getClasses(String packageName) throws IOException, URISyntaxException, ClassNotFoundException {
        ArrayList classes = new ArrayList();
        String path = packageName.replace('.', '/');
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URI pkg = Objects.requireNonNull(classLoader.getResource(path)).toURI();
        if (pkg.toString().startsWith("jar:")) {
            Path root;
            try {
                root = FileSystems.getFileSystem(pkg).getPath(path, new String[0]);
            }
            catch (FileSystemNotFoundException e) {
                root = FileSystems.newFileSystem(pkg, Collections.emptyMap()).getPath(path, new String[0]);
            }
            String extension = ".class";
            try (Stream<Path> allPaths = Files.walk(root, new FileVisitOption[0]);){
                allPaths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                    try {
                        String filePath = file.toString().replace('/', '.');
                        String fileName = filePath.substring(filePath.indexOf(packageName), filePath.length() - extension.length());
                        classes.add(Class.forName(fileName));
                    }
                    catch (ClassNotFoundException | StringIndexOutOfBoundsException exception) {
                        // empty catch block
                    }
                });
            }
        }
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        for (File directory : dirs) {
            classes.addAll(ClassLoaderUtil.findClasses(directory, packageName));
        }
        return classes;
    }

    private static List<Class<?>> findClasses(File directory, String packageName) throws ClassNotFoundException {
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        File[] files = directory.listFiles();
        assert (files != null);
        for (File file : files) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(ClassLoaderUtil.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String className = packageName + '.' + file.getName().substring(0, file.getName().length() - 6);
            classes.add(Class.forName(className));
        }
        return classes;
    }
}

