/*
 * Decompiled with CFR 0.152.
 */
package dev.keva.core.aof;

import dev.keva.core.config.KevaConfig;
import dev.keva.core.exception.StartupException;
import dev.keva.ioc.annotation.Autowired;
import dev.keva.ioc.annotation.Component;
import dev.keva.protocol.resp.Command;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class AOFContainer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AOFContainer.class);
    private ReentrantLock bufferLock;
    private ObjectOutputStream output;
    private FileDescriptor fd;
    private boolean alwaysFlush;
    @Autowired
    private KevaConfig kevaConfig;

    public void init() {
        this.alwaysFlush = this.kevaConfig.getAofInterval() == 0;
        this.bufferLock = new ReentrantLock();
        try {
            boolean isExists = new File(this.getWorkingDir() + "keva.aof").exists();
            FileOutputStream fos = new FileOutputStream(this.getWorkingDir() + "keva.aof", true);
            this.fd = fos.getFD();
            this.output = isExists ? new AppendOnlyObjectOutputStream(fos) : new ObjectOutputStream(fos);
        }
        catch (IOException e) {
            if (e instanceof FileNotFoundException) {
                log.info("AOF file not found, creating new file...");
                if (e.getMessage().contains("Permission denied")) {
                    log.error("Permission denied to access AOF file, please check your file permissions");
                    System.exit(1);
                }
            }
            log.error("Error writing to AOF file", (Throwable)e);
            System.exit(1);
        }
        if (!this.alwaysFlush) {
            ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
            executorService.scheduleAtFixedRate(() -> {
                try {
                    this.flush();
                }
                catch (IOException e) {
                    log.error("Error writing AOF file", (Throwable)e);
                }
            }, this.kevaConfig.getAofInterval().intValue(), this.kevaConfig.getAofInterval().intValue(), TimeUnit.MILLISECONDS);
            log.info("AOF started with interval {} ms", (Object)this.kevaConfig.getAofInterval());
        } else {
            log.info("AOF will trigger for every new mutate command");
        }
    }

    public void write(Command command) {
        this.bufferLock.lock();
        try {
            this.output.writeObject(command.getObjects());
            if (this.alwaysFlush) {
                this.flush();
            }
        }
        catch (IOException e) {
            log.error("Error writing AOF file", (Throwable)e);
        }
        finally {
            this.bufferLock.unlock();
        }
    }

    private void flush() throws IOException {
        this.fd.sync();
    }

    public List<Command> read() throws IOException {
        ArrayList<Command> commands = new ArrayList<Command>(100);
        try {
            FileInputStream fis = new FileInputStream(this.getWorkingDir() + "keva.aof");
            Throwable throwable = null;
            try {
                try {
                    ObjectInputStream input = new ObjectInputStream(fis);
                    Throwable throwable2 = null;
                    try {
                        try {
                            log.info("AOF size is: {}", (Object)fis.getChannel().size());
                            while (true) {
                                byte[][] objects = (byte[][])input.readObject();
                                commands.add(Command.newInstance((byte[][])objects, (boolean)false));
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (input != null) {
                            if (throwable2 != null) {
                                try {
                                    input.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable2.addSuppressed(throwable5);
                                }
                            } else {
                                input.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
            }
            catch (Throwable throwable7) {
                if (fis != null) {
                    if (throwable != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable8) {
                            throwable.addSuppressed(throwable8);
                        }
                    } else {
                        fis.close();
                    }
                }
                throw throwable7;
            }
        }
        catch (EOFException | FileNotFoundException ignored) {
            return commands;
        }
        catch (ClassNotFoundException e) {
            String msg = "Error reading AOF file";
            log.error("Error reading AOF file", (Throwable)e);
            throw new StartupException("Error reading AOF file", e);
        }
    }

    private String getWorkingDir() {
        String workingDir = this.kevaConfig.getWorkDirectory();
        return workingDir.equals("./") ? "" : workingDir + "/";
    }

    private static class AppendOnlyObjectOutputStream
    extends ObjectOutputStream {
        public AppendOnlyObjectOutputStream(OutputStream out) throws IOException {
            super(out);
        }

        @Override
        protected void writeStreamHeader() throws IOException {
            this.reset();
        }
    }
}

