/*
 * Decompiled with CFR 0.152.
 */
package dev.keva.core.aof;

import dev.keva.core.aof.AOFContainer;
import dev.keva.core.command.mapping.CommandMapper;
import dev.keva.core.command.mapping.CommandWrapper;
import dev.keva.core.config.KevaConfig;
import dev.keva.ioc.annotation.Autowired;
import dev.keva.ioc.annotation.Component;
import dev.keva.protocol.resp.Command;
import dev.keva.util.hashbytes.BytesKey;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class AOFManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AOFManager.class);
    private final KevaConfig kevaConfig;
    private final CommandMapper commandMapper;
    private final AOFContainer aof;

    @Autowired
    public AOFManager(KevaConfig kevaConfig, CommandMapper commandMapper, AOFContainer aof) {
        this.kevaConfig = kevaConfig;
        this.commandMapper = commandMapper;
        this.aof = aof;
    }

    public void init() {
        if (!this.kevaConfig.getAof().booleanValue()) {
            return;
        }
        try {
            List<Command> commands = this.aof.read();
            if (commands != null) {
                log.info("Processing {} commands from AOF file", (Object)commands.size());
                for (Command command : commands) {
                    byte[] name = command.getName();
                    CommandWrapper commandWrapper = this.commandMapper.getMethods().get(new BytesKey(name));
                    if (commandWrapper == null) continue;
                    commandWrapper.execute(null, command);
                }
                log.info("Recovered {} commands from AOF file", (Object)commands.size());
            }
        }
        catch (IOException | InterruptedException e) {
            log.error("Cannot read AOF file", (Throwable)e);
        }
        this.aof.init();
    }
}

