/*
 * Decompiled with CFR 0.152.
 */
package dev.keva.core.command.impl.generic;

import dev.keva.core.command.annotation.CommandImpl;
import dev.keva.core.command.annotation.Execute;
import dev.keva.core.command.annotation.ParamLength;
import dev.keva.ioc.annotation.Autowired;
import dev.keva.ioc.annotation.Component;
import dev.keva.protocol.resp.reply.StatusReply;
import dev.keva.storage.KevaDatabase;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.SerializationUtils;

@Component
@CommandImpl(value="type")
@ParamLength(value=1)
public class Type {
    private final KevaDatabase database;

    @Autowired
    public Type(KevaDatabase database) {
        this.database = database;
    }

    @Execute
    public StatusReply execute(byte[] key) {
        byte[] got = this.database.get(key);
        if (got == null) {
            return new StatusReply("none");
        }
        try {
            Object object = SerializationUtils.deserialize((byte[])got);
        }
        catch (SerializationException e) {
            return new StatusReply("string");
        }
        Object value = SerializationUtils.deserialize((byte[])got);
        try {
            String ignored = (String)value;
            return new StatusReply("string");
        }
        catch (ClassCastException e) {
            if (value instanceof HashMap) {
                return new StatusReply("hash");
            }
            if (value instanceof LinkedList) {
                return new StatusReply("list");
            }
            if (value instanceof HashSet) {
                return new StatusReply("set");
            }
            return new StatusReply("unknown");
        }
    }
}

