/*
 * Decompiled with CFR 0.152.
 */
package dev.keva.core.command.impl.hash;

import dev.keva.storage.KevaDatabase;
import dev.keva.util.hashbytes.BytesKey;
import dev.keva.util.hashbytes.BytesValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.SerializationUtils;

public abstract class HashBase {
    protected final KevaDatabase database;

    public HashBase(KevaDatabase database) {
        this.database = database;
    }

    protected byte[] get(byte[] key, byte[] field) {
        byte[] value = this.database.get(key);
        if (value == null) {
            return null;
        }
        HashMap map = (HashMap)SerializationUtils.deserialize((byte[])value);
        BytesValue got = (BytesValue)map.get(new BytesKey(field));
        return got == null ? null : got.getBytes();
    }

    protected HashMap<BytesKey, BytesValue> getMap(byte[] key) {
        byte[] value = this.database.get(key);
        if (value == null) {
            return null;
        }
        return (HashMap)SerializationUtils.deserialize((byte[])value);
    }

    protected byte[][] getAll(byte[] key) {
        byte[] value = this.database.get(key);
        if (value == null) {
            return null;
        }
        HashMap map = (HashMap)SerializationUtils.deserialize((byte[])value);
        byte[][] result = new byte[map.size() * 2][];
        int i = 0;
        for (Map.Entry entry : map.entrySet()) {
            result[i++] = ((BytesKey)entry.getKey()).getBytes();
            result[i++] = ((BytesValue)entry.getValue()).getBytes();
        }
        return result;
    }

    protected void set(byte[] key, byte[] field, byte[] value) {
        byte[] oldValue = this.database.get(key);
        HashMap map = oldValue == null ? new HashMap() : (HashMap)SerializationUtils.deserialize((byte[])oldValue);
        map.put(new BytesKey(field), new BytesValue(value));
        this.database.put(key, SerializationUtils.serialize((Serializable)map));
    }

    protected boolean delete(byte[] key, byte[] field) {
        boolean result;
        byte[] value = this.database.get(key);
        if (value == null) {
            return false;
        }
        HashMap map = (HashMap)SerializationUtils.deserialize((byte[])value);
        boolean bl = result = map.remove(new BytesKey(field)) != null;
        if (result) {
            this.database.put(key, SerializationUtils.serialize((Serializable)map));
        }
        return result;
    }
}

