/*
 * Decompiled with CFR 0.152.
 */
package dev.keva.core.command.impl.list;

import dev.keva.storage.KevaDatabase;
import dev.keva.util.hashbytes.BytesValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.commons.lang3.SerializationUtils;

public abstract class ListBase {
    protected final KevaDatabase database;

    public ListBase(KevaDatabase database) {
        this.database = database;
    }

    protected LinkedList<BytesValue> getList(byte[] key) {
        byte[] value = this.database.get(key);
        if (value == null) {
            return null;
        }
        return (LinkedList)SerializationUtils.deserialize((byte[])value);
    }

    protected byte[] lpop(byte[] key) {
        LinkedList<BytesValue> list = this.getList(key);
        if (list.isEmpty()) {
            return null;
        }
        byte[] result = list.removeFirst().getBytes();
        this.database.put(key, SerializationUtils.serialize(list));
        return result;
    }

    protected byte[] rpop(byte[] key) {
        LinkedList<BytesValue> list = this.getList(key);
        if (list.isEmpty()) {
            return null;
        }
        byte[] result = list.removeLast().getBytes();
        this.database.put(key, SerializationUtils.serialize(list));
        return result;
    }

    protected int lpush(byte[] key, byte[] ... values) {
        LinkedList<Object> list = this.getList(key);
        if (list == null) {
            list = new LinkedList();
        }
        for (byte[] v : values) {
            list.addFirst(new BytesValue(v));
        }
        this.database.put(key, SerializationUtils.serialize(list));
        return list.size();
    }

    protected int rpush(byte[] key, byte[] ... values) {
        byte[] value = this.database.get(key);
        LinkedList<Object> list = value == null ? new LinkedList() : this.getList(key);
        for (byte[] v : values) {
            list.addLast(new BytesValue(v));
        }
        this.database.put(key, SerializationUtils.serialize(list));
        return list.size();
    }

    protected void set(byte[] key, int index, byte[] value) {
        LinkedList<BytesValue> list = this.getList(key);
        if (index < 0) {
            index = list.size() + index;
        }
        if (index < 0 || index >= list.size()) {
            return;
        }
        list.set(index, new BytesValue(value));
        this.database.put(key, SerializationUtils.serialize(list));
    }

    protected byte[][] range(byte[] key, int start, int end) {
        LinkedList<BytesValue> list = this.getList(key);
        int size = list.size();
        if (start < 0) {
            start = size + start;
        }
        if (end < 0) {
            end = size + end;
        }
        if (start < 0) {
            start = 0;
        }
        if (end > size) {
            end = size;
        }
        if (start > end) {
            return null;
        }
        ArrayList<byte[]> result = new ArrayList<byte[]>(0);
        for (int j = start; j <= end; ++j) {
            try {
                if (list.get(j) == null) continue;
                result.add(list.get(j).getBytes());
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return (byte[][])result.toArray((T[])new byte[0][0]);
    }

    protected int remove(byte[] key, int count, byte[] value) {
        LinkedList<BytesValue> list = this.getList(key);
        int size = list.size();
        int result = 0;
        if (count > 0) {
            for (int i = 0; i < size; ++i) {
                if (!Arrays.equals(list.get(i).getBytes(), value) || count == 0) continue;
                --count;
                list.remove(i);
                ++result;
                --size;
            }
        } else if (count < 0) {
            for (int i = size - 1; i >= 0; --i) {
                if (!Arrays.equals(list.get(i).getBytes(), value) || count == 0) continue;
                ++count;
                list.remove(i);
                ++result;
                --size;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                if (!Arrays.equals(list.get(i).getBytes(), value)) continue;
                list.remove(i);
                ++result;
                --size;
            }
        }
        this.database.put(key, SerializationUtils.serialize(list));
        return result;
    }
}

