/*
 * Decompiled with CFR 0.152.
 */
package dev.keva.core.command.impl.pubsub;

import dev.keva.core.command.annotation.CommandImpl;
import dev.keva.core.command.annotation.Execute;
import dev.keva.core.command.annotation.ParamLength;
import dev.keva.core.command.impl.pubsub.manager.PubSubManager;
import dev.keva.ioc.annotation.Autowired;
import dev.keva.ioc.annotation.Component;
import dev.keva.protocol.resp.reply.BulkReply;
import dev.keva.protocol.resp.reply.IntegerReply;
import dev.keva.protocol.resp.reply.MultiBulkReply;
import dev.keva.protocol.resp.reply.Reply;
import io.netty.channel.Channel;
import java.util.Set;

@Component
@CommandImpl(value="publish")
@ParamLength(value=2)
public class Publish {
    private final PubSubManager manager;

    @Autowired
    public Publish(PubSubManager manager) {
        this.manager = manager;
    }

    @Execute
    public IntegerReply execute(byte[] topicBytes, byte[] message) {
        int count = 0;
        String topic = new String(topicBytes).toLowerCase();
        Set set = (Set)this.manager.getTopics().get(topic);
        if (set != null) {
            for (Channel channel : set) {
                if (channel.isActive()) {
                    BulkReply[] replies = new BulkReply[]{new BulkReply("message"), new BulkReply(topic), new BulkReply(message)};
                    channel.writeAndFlush((Object)new MultiBulkReply((Reply[])replies));
                    ++count;
                    continue;
                }
                if (channel.isOpen()) continue;
                set.remove(channel);
            }
        }
        return new IntegerReply((long)count);
    }
}

