/*
 * Decompiled with CFR 0.152.
 */
package dev.keva.core.command.impl.pubsub;

import dev.keva.core.command.annotation.CommandImpl;
import dev.keva.core.command.annotation.Execute;
import dev.keva.core.command.impl.pubsub.manager.PubSubManager;
import dev.keva.ioc.annotation.Autowired;
import dev.keva.ioc.annotation.Component;
import dev.keva.protocol.resp.reply.BulkReply;
import dev.keva.protocol.resp.reply.IntegerReply;
import dev.keva.protocol.resp.reply.MultiBulkReply;
import dev.keva.protocol.resp.reply.Reply;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@Component
@CommandImpl(value="unsubscribe")
public class Unsubscribe {
    private final PubSubManager manager;

    @Autowired
    public Unsubscribe(PubSubManager manager) {
        this.manager = manager;
    }

    public void remove(ChannelHandlerContext ctx, Set<String> track, String topic) {
        ConcurrentMap<String, Set<Channel>> topics = this.manager.getTopics();
        Set list = (Set)topics.get(topic);
        if (list != null) {
            list.remove(ctx.channel());
        }
        track.remove(topic);
        Reply[] replies = new Reply[]{new BulkReply("unsubscribe"), new BulkReply(topic), new IntegerReply((long)track.size())};
        ctx.write((Object)new MultiBulkReply(replies));
    }

    @Execute
    public void execute(ChannelHandlerContext ctx, byte[] ... topicBytes) {
        ConcurrentMap<Channel, Set<String>> tracks = this.manager.getTracks();
        ConcurrentHashMap.KeySetView track = (ConcurrentHashMap.KeySetView)tracks.get(ctx.channel());
        if (track == null) {
            track = ConcurrentHashMap.newKeySet();
        }
        if (topicBytes.length == 0) {
            for (String topic : track) {
                this.remove(ctx, track, topic);
            }
            return;
        }
        String[] topicsToUnsubscribe = new String[topicBytes.length];
        for (int i = 0; i < topicBytes.length; ++i) {
            topicsToUnsubscribe[i] = new String(topicBytes[i]);
        }
        for (String topic : topicsToUnsubscribe) {
            this.remove(ctx, track, topic);
        }
    }
}

