/*
 * Decompiled with CFR 0.152.
 */
package dev.keva.core.command.impl.set;

import dev.keva.storage.KevaDatabase;
import dev.keva.util.hashbytes.BytesKey;
import java.io.Serializable;
import java.util.HashSet;
import org.apache.commons.lang3.SerializationUtils;

public abstract class SetBase {
    protected final KevaDatabase database;

    public SetBase(KevaDatabase database) {
        this.database = database;
    }

    protected HashSet<BytesKey> getSet(byte[] key) {
        byte[] value = this.database.get(key);
        if (value == null) {
            return null;
        }
        return (HashSet)SerializationUtils.deserialize((byte[])value);
    }

    protected int add(byte[] key, byte[] ... values) {
        byte[] value = this.database.get(key);
        HashSet<Object> set = value == null ? new HashSet() : this.getSet(key);
        int count = 0;
        for (byte[] v : values) {
            boolean isNewElement = set.add(new BytesKey(v));
            if (!isNewElement) continue;
            ++count;
        }
        this.database.put(key, SerializationUtils.serialize(set));
        return count;
    }

    protected int size(byte[] key) {
        HashSet<BytesKey> set = this.getSet(key);
        return set.size();
    }

    protected byte[][] diff(byte[] ... keys) {
        HashSet set = new HashSet();
        for (byte[] key : keys) {
            byte[] value = this.database.get(key);
            if (set.isEmpty() && value != null) {
                set.addAll((HashSet)SerializationUtils.deserialize((byte[])value));
                continue;
            }
            if (value == null) continue;
            HashSet set1 = (HashSet)SerializationUtils.deserialize((byte[])value);
            set.removeAll(set1);
        }
        byte[][] result = new byte[set.size()][];
        int i = 0;
        for (BytesKey v : set) {
            result[i++] = v.getBytes();
        }
        return result;
    }

    protected byte[][] inter(byte[] ... keys) {
        HashSet set = new HashSet();
        for (byte[] key : keys) {
            byte[] value = this.database.get(key);
            if (set.isEmpty() && value != null) {
                set.addAll((HashSet)SerializationUtils.deserialize((byte[])value));
                continue;
            }
            if (value == null) continue;
            HashSet set1 = (HashSet)SerializationUtils.deserialize((byte[])value);
            set.retainAll(set1);
        }
        byte[][] result = new byte[set.size()][];
        int i = 0;
        for (BytesKey v : set) {
            result[i++] = v.getBytes();
        }
        return result;
    }

    protected byte[][] members(byte[] key) {
        byte[] value = this.database.get(key);
        if (value == null) {
            return null;
        }
        HashSet set = (HashSet)SerializationUtils.deserialize((byte[])value);
        byte[][] result = new byte[set.size()][];
        int i = 0;
        for (BytesKey v : set) {
            result[i++] = v.getBytes();
        }
        return result;
    }

    protected boolean isMember(byte[] key, byte[] value) {
        byte[] got = this.database.get(key);
        if (got == null) {
            return false;
        }
        HashSet set = (HashSet)SerializationUtils.deserialize((byte[])got);
        return set.contains(new BytesKey(value));
    }

    protected int move(byte[] source, byte[] destination, byte[] value) {
        byte[] sourceValue = this.database.get(source);
        if (sourceValue == null) {
            return 0;
        }
        HashSet set = (HashSet)SerializationUtils.deserialize((byte[])sourceValue);
        if (set.remove(new BytesKey(value))) {
            byte[] destinationValue = this.database.get(destination);
            HashSet set1 = destinationValue == null ? new HashSet() : (HashSet)SerializationUtils.deserialize((byte[])destinationValue);
            boolean result = set1.add(new BytesKey(value));
            this.database.put(source, SerializationUtils.serialize((Serializable)set));
            this.database.put(destination, SerializationUtils.serialize((Serializable)set1));
            return result ? 1 : 0;
        }
        return 0;
    }

    protected int remove(byte[] key, byte[] ... values) {
        byte[] value = this.database.get(key);
        if (value == null) {
            return 0;
        }
        HashSet set = (HashSet)SerializationUtils.deserialize((byte[])value);
        int result = 0;
        for (byte[] v : values) {
            if (!set.remove(new BytesKey(v))) continue;
            ++result;
        }
        if (set.isEmpty()) {
            this.database.remove(key);
        } else {
            this.database.put(key, SerializationUtils.serialize((Serializable)set));
        }
        return result;
    }

    protected byte[][] union(byte[] ... keys) {
        HashSet set = new HashSet();
        for (byte[] key : keys) {
            byte[] value = this.database.get(key);
            if (value == null) continue;
            HashSet set1 = (HashSet)SerializationUtils.deserialize((byte[])value);
            set.addAll(set1);
        }
        byte[][] result = new byte[set.size()][];
        int i = 0;
        for (BytesKey v : set) {
            result[i++] = v.getBytes();
        }
        return result;
    }
}

