/*
 * Decompiled with CFR 0.152.
 */
package dev.keva.core.command.impl.string;

import dev.keva.core.command.annotation.CommandImpl;
import dev.keva.core.command.annotation.Execute;
import dev.keva.core.command.annotation.ParamLength;
import dev.keva.core.exception.CommandException;
import dev.keva.ioc.annotation.Autowired;
import dev.keva.ioc.annotation.Component;
import dev.keva.protocol.resp.reply.BulkReply;
import dev.keva.storage.KevaDatabase;
import java.nio.charset.StandardCharsets;

@Component
@CommandImpl(value="getex")
@ParamLength(type=ParamLength.Type.AT_LEAST, value=2)
public class GetEx {
    private final KevaDatabase database;
    private final String EX = "EX";
    private final String PX = "PX";
    private final String EXAT = "EXAT";
    private final String PXAT = "PXAT";
    private final String PERSIST = "PERSIST";
    private final int EX_FLG = 4;
    private final int PX_FLG = 8;
    private final int EXAT_FLG = 64;
    private final int PXAT_FLG = 128;
    private final int PERSIST_FLG = 256;

    @Autowired
    public GetEx(KevaDatabase database) {
        this.database = database;
    }

    @Execute
    public BulkReply execute(byte[][] params) {
        int flgs = 0;
        String nextArg = null;
        long expireTime = 0L;
        for (int i = 1; i < params.length; ++i) {
            String opt = new String(params[i], StandardCharsets.UTF_8);
            String string = nextArg = i == params.length - 1 ? null : new String(params[i + 1], StandardCharsets.UTF_8);
            if ("EX".equalsIgnoreCase(opt) && nextArg != null && !this.isHavingOneOfTheseFlgs(flgs, 4, 8, 64, 128, 256)) {
                flgs |= 4;
                ++i;
                continue;
            }
            if ("PX".equalsIgnoreCase(opt) && nextArg != null && !this.isHavingOneOfTheseFlgs(flgs, 4, 8, 64, 128, 256)) {
                flgs |= 8;
                ++i;
                continue;
            }
            if ("EXAT".equalsIgnoreCase(opt) && nextArg != null && !this.isHavingOneOfTheseFlgs(flgs, 4, 8, 64, 128, 256)) {
                flgs |= 0x40;
                ++i;
                continue;
            }
            if ("PXAT".equalsIgnoreCase(opt) && nextArg != null && !this.isHavingOneOfTheseFlgs(flgs, 4, 8, 64, 128, 256)) {
                flgs |= 0x80;
                ++i;
                continue;
            }
            if ("PERSIST".equalsIgnoreCase(opt) && nextArg == null && !this.isHavingOneOfTheseFlgs(flgs, 4, 8, 64, 128, 256)) {
                flgs |= 0x100;
                continue;
            }
            throw new CommandException("Syntax error");
        }
        byte[] got = this.database.get(params[0]);
        if (got == null) {
            return BulkReply.NIL_REPLY;
        }
        if (this.isHavingOneOfTheseFlgs(flgs, 256)) {
            this.database.removeExpire(params[0]);
        } else {
            try {
                expireTime = Long.parseLong(nextArg);
            }
            catch (NumberFormatException e) {
                throw new CommandException("value is not an integer or out of range");
            }
            if (expireTime < 1L) {
                throw new CommandException("invalid expire time in 'getex' command");
            }
            long expireAt = expireTime;
            if (this.isHavingOneOfTheseFlgs(flgs, 4, 64)) {
                expireAt *= 1000L;
            }
            if (this.isHavingOneOfTheseFlgs(flgs, 4, 8)) {
                expireAt += System.currentTimeMillis();
            }
            if (expireAt < System.currentTimeMillis()) {
                this.database.remove(params[0]);
            } else {
                this.database.setExpiration(params[0], expireAt);
            }
        }
        return new BulkReply(got);
    }

    private boolean isHavingOneOfTheseFlgs(int flgs, int ... flgsToCompare) {
        for (int j : flgsToCompare) {
            if ((flgs & j) == 0) continue;
            return true;
        }
        return false;
    }
}

