/*
 * Decompiled with CFR 0.152.
 */
package dev.keva.core.command.impl.string;

import dev.keva.core.command.annotation.CommandImpl;
import dev.keva.core.command.annotation.Execute;
import dev.keva.core.command.annotation.ParamLength;
import dev.keva.core.exception.CommandException;
import dev.keva.ioc.annotation.Autowired;
import dev.keva.ioc.annotation.Component;
import dev.keva.protocol.resp.reply.BulkReply;
import dev.keva.protocol.resp.reply.IntegerReply;
import dev.keva.protocol.resp.reply.MultiBulkReply;
import dev.keva.protocol.resp.reply.Reply;
import dev.keva.storage.KevaDatabase;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@Component
@CommandImpl(value="stralgo")
@ParamLength(type=ParamLength.Type.AT_LEAST, value=2)
public class LCS {
    private final String LEN = "len";
    private final String IDX = "idx";
    private final String MINMATCHLEN = "minmatchlen";
    private final String WITHMATCHLEN = "withmatchlen";
    private final String STRINGS = "strings";
    private final String KEYS = "keys";
    private final KevaDatabase database;

    @Autowired
    public LCS(KevaDatabase database) {
        this.database = database;
    }

    @Execute
    public MultiBulkReply execute(byte[][] params) {
        ArrayList<Object> repliesList = new ArrayList<Object>();
        long minMatchLen = 0L;
        boolean getLen = false;
        boolean getIdx = false;
        boolean withMatchLen = false;
        String a = null;
        String b = null;
        for (int i = 1; i < params.length; ++i) {
            String opt = new String(params[i], StandardCharsets.UTF_8);
            int moreArgs = params.length - i;
            if ("idx".compareToIgnoreCase(opt) == 0) {
                getIdx = true;
                continue;
            }
            if ("len".compareToIgnoreCase(opt) == 0) {
                getLen = true;
                continue;
            }
            if ("withmatchlen".compareToIgnoreCase(opt) == 0) {
                withMatchLen = true;
                continue;
            }
            if ("minmatchlen".compareToIgnoreCase(opt) == 0 && moreArgs > 0) {
                try {
                    minMatchLen = Long.parseLong(new String(params[i + 1]));
                }
                catch (NumberFormatException e) {
                    throw new CommandException("Error while parsing value");
                }
                if (minMatchLen < 0L) {
                    minMatchLen = 0L;
                }
                ++i;
                continue;
            }
            if ("strings".compareToIgnoreCase(opt) == 0 && moreArgs > 1) {
                if (a != null) {
                    throw new CommandException("Either use STRINGS or KEYS");
                }
                a = new String(params[i + 1], StandardCharsets.UTF_8);
                b = new String(params[i + 2], StandardCharsets.UTF_8);
                i += 2;
                continue;
            }
            if ("keys".compareToIgnoreCase(opt) == 0 && moreArgs > 1) {
                if (a != null) {
                    throw new CommandException("Either use STRINGS or KEYS");
                }
                a = new String(this.database.get(params[i + 1]), StandardCharsets.UTF_8);
                if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{a, b = new String(this.database.get(params[i + 2]), StandardCharsets.UTF_8)})) {
                    throw new CommandException("The specified keys must contain string values");
                }
                i += 2;
                continue;
            }
            throw new CommandException("Syntax error");
        }
        if (a == null) {
            throw new CommandException("Please specify two strings: STRINGS or KEYS options are mandatory");
        }
        if (getLen && getIdx) {
            throw new CommandException("If you want bot the length and indexes, please just use IDX");
        }
        if (a.length() > Integer.MAX_VALUE || b.length() > Integer.MAX_VALUE) {
            throw new CommandException("String too long for LCS");
        }
        int alen = a.length();
        int blen = b.length();
        int DP_TBL_SIZE1 = alen + 1;
        int DP_TBL_SIZE2 = blen + 1;
        int[][] dpTbl = new int[DP_TBL_SIZE1][DP_TBL_SIZE2];
        for (int i = 1; i <= alen; ++i) {
            for (int j = 1; j <= blen; ++j) {
                dpTbl[i][j] = a.charAt(i - 1) != b.charAt(j - 1) ? Math.max(dpTbl[i][j - 1], dpTbl[i - 1][j]) : dpTbl[i - 1][j - 1] + 1;
            }
        }
        int idx = dpTbl[alen][blen];
        Object result = null;
        boolean isComputeLcs = getIdx || !getLen;
        int i = alen;
        int j = blen;
        ArrayList<List<List>> idxList = new ArrayList<List<List>>();
        StringBuilder res = new StringBuilder();
        int pos1 = i;
        int pos2 = j;
        boolean matched = false;
        while (isComputeLcs && i > 0 && j > 0) {
            if (a.charAt(i - 1) == b.charAt(j - 1)) {
                if (!matched) {
                    pos1 = i;
                    pos2 = j;
                    matched = true;
                }
                res.append(a.charAt(i - 1));
                --i;
                --j;
                continue;
            }
            if (matched) {
                matched = false;
                idxList.add(Arrays.asList(Arrays.asList(i, pos1 - 1), Arrays.asList(j, pos2 - 1), Arrays.asList(pos1 - i)));
            }
            if (dpTbl[i - 1][j] > dpTbl[i][j - 1]) {
                --i;
                continue;
            }
            --j;
        }
        if (matched) {
            idxList.add(Arrays.asList(Arrays.asList(i, pos1 - 1), Arrays.asList(j, pos2 - 1), Arrays.asList(pos1 - i)));
        }
        if (getIdx) {
            repliesList.add(new BulkReply("matches"));
            ArrayList<MultiBulkReply> matchesReply = new ArrayList<MultiBulkReply>();
            for (List list : idxList) {
                int matchedLen = (Integer)((List)list.get(2)).get(0);
                if (minMatchLen != 0L && (long)matchedLen < minMatchLen) continue;
                ArrayList<Object> matchReplyList = new ArrayList<Object>();
                matchReplyList.add(new MultiBulkReply(new Reply[]{new IntegerReply((long)((Integer)((List)list.get(0)).get(0)).intValue()), new IntegerReply((long)((Integer)((List)list.get(0)).get(1)).intValue())}));
                matchReplyList.add(new MultiBulkReply(new Reply[]{new IntegerReply((long)((Integer)((List)list.get(1)).get(0)).intValue()), new IntegerReply((long)((Integer)((List)list.get(1)).get(1)).intValue())}));
                if (withMatchLen) {
                    matchReplyList.add(new IntegerReply((long)matchedLen));
                }
                Reply[] matchReply = new Reply[matchReplyList.size()];
                matchReplyList.toArray(matchReply);
                matchesReply.add(new MultiBulkReply(matchReply));
            }
            Reply[] replies = new Reply[matchesReply.size()];
            matchesReply.toArray(replies);
            repliesList.add(new MultiBulkReply(replies));
            repliesList.add(new BulkReply("len"));
            repliesList.add(new IntegerReply((long)dpTbl[alen][blen]));
        } else if (getLen) {
            repliesList.add(new IntegerReply((long)dpTbl[alen][blen]));
        } else {
            repliesList.add(new BulkReply(res.toString()));
        }
        Reply[] replies = new Reply[repliesList.size()];
        repliesList.toArray(replies);
        return new MultiBulkReply(replies);
    }
}

