/*
 * Decompiled with CFR 0.152.
 */
package dev.keva.core.command.impl.string;

import dev.keva.core.command.annotation.CommandImpl;
import dev.keva.core.command.annotation.Execute;
import dev.keva.core.command.annotation.ParamLength;
import dev.keva.ioc.annotation.Autowired;
import dev.keva.ioc.annotation.Component;
import dev.keva.protocol.resp.reply.BulkReply;
import dev.keva.protocol.resp.reply.MultiBulkReply;
import dev.keva.protocol.resp.reply.Reply;
import dev.keva.storage.KevaDatabase;

@Component
@CommandImpl(value="mget")
@ParamLength(type=ParamLength.Type.AT_LEAST, value=1)
public class MGet {
    private final KevaDatabase database;

    @Autowired
    public MGet(KevaDatabase database) {
        this.database = database;
    }

    @Execute
    public MultiBulkReply execute(byte[] ... keys) {
        int i;
        BulkReply[] replies = new BulkReply[keys.length];
        byte[][] mget = new byte[keys.length][];
        for (i = 0; i < keys.length; ++i) {
            byte[] key = keys[i];
            byte[] got = this.database.get(key);
            mget[i] = got;
        }
        for (i = 0; i < mget.length; ++i) {
            replies[i] = mget[i] == null ? BulkReply.NIL_REPLY : new BulkReply(mget[i]);
        }
        return new MultiBulkReply((Reply[])replies);
    }
}

