/*
 * Decompiled with CFR 0.152.
 */
package dev.keva.core.command.impl.string;

import dev.keva.core.command.annotation.CommandImpl;
import dev.keva.core.command.annotation.Execute;
import dev.keva.core.command.annotation.ParamLength;
import dev.keva.core.exception.CommandException;
import dev.keva.ioc.annotation.Autowired;
import dev.keva.ioc.annotation.Component;
import dev.keva.protocol.resp.reply.StatusReply;
import dev.keva.storage.KevaDatabase;
import java.nio.charset.StandardCharsets;

@Component
@CommandImpl(value="psetex")
@ParamLength(type=ParamLength.Type.EXACT, value=3)
public class PSetEX {
    private final KevaDatabase database;

    @Autowired
    public PSetEX(KevaDatabase database) {
        this.database = database;
    }

    @Execute
    public StatusReply execute(byte[][] params) {
        long milliseconds;
        String key = new String(params[0], StandardCharsets.UTF_8);
        try {
            milliseconds = Long.parseLong(new String(params[1]));
        }
        catch (NumberFormatException e) {
            throw new CommandException("value is not an integer or out of range");
        }
        if (milliseconds < 1L) {
            throw new CommandException("invalid expire time in 'psetex' command");
        }
        this.database.put(params[0], params[2]);
        this.database.setExpiration(params[0], System.currentTimeMillis() + milliseconds);
        return StatusReply.OK;
    }
}

