/*
 * Decompiled with CFR 0.152.
 */
package dev.keva.core.command.impl.transaction.manager;

import dev.keva.core.command.mapping.CommandMapper;
import dev.keva.core.command.mapping.CommandWrapper;
import dev.keva.protocol.resp.Command;
import dev.keva.protocol.resp.reply.BulkReply;
import dev.keva.protocol.resp.reply.MultiBulkReply;
import dev.keva.protocol.resp.reply.Reply;
import dev.keva.storage.KevaDatabase;
import dev.keva.util.hashbytes.BytesKey;
import dev.keva.util.hashbytes.BytesValue;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import lombok.Generated;

public class TransactionContext {
    private final KevaDatabase database;
    private final CommandMapper commandMapper;
    private final Map<BytesKey, BytesValue> watchMap = new HashMap<BytesKey, BytesValue>();
    private final Deque<Command> commandDeque = new ArrayDeque<Command>();
    private boolean isQueuing = false;

    public TransactionContext(KevaDatabase database, CommandMapper commandMapper) {
        this.database = database;
        this.commandMapper = commandMapper;
    }

    public void multi() {
        this.isQueuing = true;
    }

    public void discard() {
        this.commandDeque.clear();
        this.watchMap.clear();
        this.isQueuing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reply<?> exec(ChannelHandlerContext ctx, Lock txLock) throws InterruptedException {
        txLock.lock();
        try {
            Object actualValue;
            for (Map.Entry<BytesKey, BytesValue> watch : this.watchMap.entrySet()) {
                BytesKey key = watch.getKey();
                byte[] value = watch.getValue().getBytes();
                actualValue = this.database.get(key.getBytes());
                if (Arrays.equals(actualValue, value)) continue;
                this.discard();
                BulkReply bulkReply = BulkReply.NIL_REPLY;
                return bulkReply;
            }
            this.isQueuing = false;
            Reply[] replies = new Reply[this.commandDeque.size()];
            int i = 0;
            while (this.commandDeque.size() > 0) {
                Reply<?> result;
                Command command = this.commandDeque.removeFirst();
                CommandWrapper commandWrapper = this.commandMapper.getMethods().get(new BytesKey(command.getName()));
                if (commandWrapper == null) {
                    actualValue = BulkReply.NIL_REPLY;
                    return actualValue;
                }
                replies[i] = result = commandWrapper.execute(ctx, command);
                ++i;
            }
            this.watchMap.clear();
            MultiBulkReply multiBulkReply = new MultiBulkReply(replies);
            return multiBulkReply;
        }
        finally {
            txLock.unlock();
        }
    }

    @Generated
    public Map<BytesKey, BytesValue> getWatchMap() {
        return this.watchMap;
    }

    @Generated
    public Deque<Command> getCommandDeque() {
        return this.commandDeque;
    }

    @Generated
    public boolean isQueuing() {
        return this.isQueuing;
    }
}

