/*
 * Decompiled with CFR 0.152.
 */
package dev.keva.core.command.impl.zset;

import dev.keva.core.command.annotation.CommandImpl;
import dev.keva.core.command.annotation.Execute;
import dev.keva.core.command.annotation.Mutate;
import dev.keva.core.command.annotation.ParamLength;
import dev.keva.core.command.impl.zset.ZBase;
import dev.keva.ioc.annotation.Autowired;
import dev.keva.ioc.annotation.Component;
import dev.keva.protocol.resp.reply.BulkReply;
import dev.keva.protocol.resp.reply.ErrorReply;
import dev.keva.protocol.resp.reply.IntegerReply;
import dev.keva.protocol.resp.reply.Reply;
import dev.keva.storage.KevaDatabase;
import dev.keva.util.DoubleUtil;
import dev.keva.util.hashbytes.BytesKey;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;

@Component
@CommandImpl(value="zadd")
@ParamLength(type=ParamLength.Type.AT_LEAST, value=3)
@Mutate
public final class ZAdd
extends ZBase {
    private static final String XX = "xx";
    private static final String NX = "nx";
    private static final String GT = "gt";
    private static final String LT = "lt";
    private static final String INCR = "incr";
    private static final String CH = "ch";
    private final KevaDatabase database;

    @Autowired
    public ZAdd(KevaDatabase database) {
        super(database);
        this.database = database;
    }

    @Execute
    public Reply<?> execute(byte[][] params) {
        int numMembers;
        int argPos;
        boolean xx = false;
        boolean nx = false;
        boolean gt = false;
        boolean lt = false;
        boolean incr = false;
        int flags = 0;
        for (argPos = 1; argPos < params.length; ++argPos) {
            String arg = new String(params[argPos], StandardCharsets.UTF_8);
            if (XX.equalsIgnoreCase(arg)) {
                xx = true;
                flags |= 1;
                continue;
            }
            if (NX.equalsIgnoreCase(arg)) {
                nx = true;
                flags |= 2;
                continue;
            }
            if (GT.equalsIgnoreCase(arg)) {
                gt = true;
                flags |= 4;
                continue;
            }
            if (LT.equalsIgnoreCase(arg)) {
                lt = true;
                flags |= 8;
                continue;
            }
            if (INCR.equalsIgnoreCase(arg)) {
                incr = true;
                flags |= 0x10;
                continue;
            }
            if (!CH.equalsIgnoreCase(arg)) break;
            flags |= 0x20;
        }
        if ((numMembers = params.length - argPos) % 2 != 0) {
            return ErrorReply.SYNTAX_ERROR;
        }
        numMembers /= 2;
        if (nx && xx) {
            return ErrorReply.ZADD_NX_XX_ERROR;
        }
        if (gt && nx || lt && nx || gt && lt) {
            return ErrorReply.ZADD_GT_LT_NX_ERROR;
        }
        if (incr && numMembers > 1) {
            return ErrorReply.ZADD_INCR_ERROR;
        }
        AbstractMap.SimpleEntry[] members = new AbstractMap.SimpleEntry[numMembers];
        for (int memberIndex = 0; memberIndex < numMembers; ++memberIndex) {
            double score;
            try {
                String rawScore = new String(params[argPos++], StandardCharsets.UTF_8);
                score = rawScore.equalsIgnoreCase("inf") || rawScore.equalsIgnoreCase("infinity") || rawScore.equalsIgnoreCase("+inf") || rawScore.equalsIgnoreCase("+infinity") ? Double.POSITIVE_INFINITY : (rawScore.equalsIgnoreCase("-inf") || rawScore.equalsIgnoreCase("-infinity") ? Double.NEGATIVE_INFINITY : Double.parseDouble(rawScore));
            }
            catch (NumberFormatException ignored) {
                return ErrorReply.ZADD_SCORE_FLOAT_ERROR;
            }
            members[memberIndex] = new AbstractMap.SimpleEntry<Double, BytesKey>(score, new BytesKey(params[argPos++]));
        }
        if (incr) {
            Double result = this.increaseBy(params[0], (Double)members[0].getKey(), (BytesKey)members[0].getValue(), flags);
            return result == null ? BulkReply.NIL_REPLY : new BulkReply(DoubleUtil.toString((Double)result));
        }
        int result = this.add(params[0], members, flags);
        return new IntegerReply((long)result);
    }
}

