/*
 * Decompiled with CFR 0.152.
 */
package dev.keva.core.command.impl.zset;

import dev.keva.core.command.impl.zset.ZSet;
import dev.keva.storage.KevaDatabase;
import dev.keva.util.hashbytes.BytesKey;
import java.io.Serializable;
import java.util.AbstractMap;
import lombok.NonNull;
import org.apache.commons.lang3.SerializationUtils;

public abstract class ZBase {
    private final KevaDatabase database;

    public ZBase(KevaDatabase database) {
        this.database = database;
    }

    protected Double increaseBy(byte[] key, Double incr, BytesKey e, int flags) {
        byte[] value = this.database.get(key);
        ZSet zSet = value == null ? new ZSet() : (ZSet)SerializationUtils.deserialize((byte[])value);
        Double currentScore = zSet.getScore(e);
        if (currentScore == null) {
            if ((flags & 1) != 0) {
                return null;
            }
            currentScore = incr;
            zSet.add(new AbstractMap.SimpleEntry<Double, BytesKey>(currentScore, e));
            this.database.put(key, SerializationUtils.serialize((Serializable)zSet));
            return currentScore;
        }
        if ((flags & 2) != 0) {
            return null;
        }
        if ((flags & 8) != 0 && (incr >= 0.0 || currentScore.isInfinite())) {
            return null;
        }
        if ((flags & 4) != 0 && (incr <= 0.0 || currentScore.isInfinite())) {
            return null;
        }
        zSet.remove(new AbstractMap.SimpleEntry<Double, BytesKey>(currentScore, e));
        currentScore = currentScore + incr;
        zSet.add(new AbstractMap.SimpleEntry<Double, BytesKey>(currentScore, e));
        this.database.put(key, SerializationUtils.serialize((Serializable)zSet));
        return currentScore;
    }

    protected int add(byte[] key, @NonNull AbstractMap.SimpleEntry<Double, BytesKey>[] members, int flags) {
        if (members == null) {
            throw new NullPointerException("members is marked non-null but is null");
        }
        boolean xx = (flags & 1) != 0;
        boolean nx = (flags & 2) != 0;
        boolean lt = (flags & 8) != 0;
        boolean gt = (flags & 4) != 0;
        boolean ch = (flags & 0x20) != 0;
        int added = 0;
        int changed = 0;
        byte[] value = this.database.get(key);
        ZSet zSet = value == null ? new ZSet() : (ZSet)SerializationUtils.deserialize((byte[])value);
        for (AbstractMap.SimpleEntry<Double, BytesKey> member : members) {
            Double currScore = zSet.getScore(member.getValue());
            if (currScore == null) {
                if (xx) continue;
                currScore = member.getKey();
                zSet.add(new AbstractMap.SimpleEntry<Double, BytesKey>(currScore, member.getValue()));
                ++added;
                ++changed;
                continue;
            }
            Double newScore = member.getKey();
            if (nx || lt && newScore >= currScore || gt && newScore <= currScore || newScore.equals(currScore)) continue;
            zSet.removeByKey(member.getValue());
            zSet.add(member);
            ++changed;
        }
        this.database.put(key, SerializationUtils.serialize((Serializable)zSet));
        return ch ? changed : added;
    }

    protected Double score(byte[] key, byte[] member) {
        byte[] value = this.database.get(key);
        if (value == null) {
            return null;
        }
        ZSet zset = (ZSet)SerializationUtils.deserialize((byte[])value);
        return zset.getScore(new BytesKey(member));
    }
}

