/*
 * Decompiled with CFR 0.152.
 */
package dev.keva.core.command.impl.zset;

import dev.keva.util.hashbytes.BytesKey;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.NonNull;

public class ZSet
extends AbstractSet<AbstractMap.SimpleEntry<Double, BytesKey>>
implements NavigableSet<AbstractMap.SimpleEntry<Double, BytesKey>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final HashMap<BytesKey, Double> keys = new HashMap();
    private final TreeSet<AbstractMap.SimpleEntry<Double, BytesKey>> scores = new TreeSet((Comparator & Serializable)(e1, e2) -> {
        int cmp = ((Double)e1.getKey()).compareTo((Double)e2.getKey());
        if (cmp != 0) {
            return cmp;
        }
        return ((BytesKey)e1.getValue()).compareTo((BytesKey)e2.getValue());
    });

    @Override
    public AbstractMap.SimpleEntry<Double, BytesKey> lower(AbstractMap.SimpleEntry<Double, BytesKey> entry) {
        return this.scores.lower(entry);
    }

    @Override
    public AbstractMap.SimpleEntry<Double, BytesKey> floor(AbstractMap.SimpleEntry<Double, BytesKey> entry) {
        return this.scores.floor(entry);
    }

    @Override
    public AbstractMap.SimpleEntry<Double, BytesKey> ceiling(AbstractMap.SimpleEntry<Double, BytesKey> entry) {
        return this.scores.ceiling(entry);
    }

    @Override
    public AbstractMap.SimpleEntry<Double, BytesKey> higher(AbstractMap.SimpleEntry<Double, BytesKey> entry) {
        return this.scores.higher(entry);
    }

    @Override
    public AbstractMap.SimpleEntry<Double, BytesKey> pollFirst() {
        return this.scores.pollFirst();
    }

    @Override
    public AbstractMap.SimpleEntry<Double, BytesKey> pollLast() {
        return this.scores.pollLast();
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.scores.contains(o);
    }

    @Override
    public Iterator<AbstractMap.SimpleEntry<Double, BytesKey>> iterator() {
        return this.scores.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.scores.toArray();
    }

    @Override
    public <T> T[] toArray(@NonNull T[] ts) {
        if (ts == null) {
            throw new NullPointerException("ts is marked non-null but is null");
        }
        return this.scores.toArray(ts);
    }

    @Override
    public boolean add(AbstractMap.SimpleEntry<Double, BytesKey> entry) {
        boolean result = true;
        if (this.keys.containsKey(entry.getValue())) {
            result = false;
            this.scores.remove(new AbstractMap.SimpleEntry<Double, BytesKey>(this.keys.get(entry.getValue()), entry.getValue()));
        }
        this.scores.add(new AbstractMap.SimpleEntry<Double, BytesKey>(entry.getKey(), entry.getValue()));
        this.keys.put(entry.getValue(), entry.getKey());
        return result;
    }

    @Override
    public boolean remove(@NonNull Object o) {
        if (o == null) {
            throw new NullPointerException("o is marked non-null but is null");
        }
        AbstractMap.SimpleEntry entry = (AbstractMap.SimpleEntry)o;
        if (this.keys.containsKey(entry.getValue())) {
            this.scores.remove(new AbstractMap.SimpleEntry(entry.getKey(), entry.getValue()));
            this.keys.remove(entry.getValue());
            return true;
        }
        return false;
    }

    public boolean removeByKey(@NonNull BytesKey key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (this.keys.containsKey(key)) {
            this.scores.remove(new AbstractMap.SimpleEntry<Double, BytesKey>(this.keys.get(key), key));
            this.keys.remove(key);
            return true;
        }
        return false;
    }

    @Override
    public synchronized void clear() {
        this.scores.clear();
        this.keys.clear();
    }

    @Override
    @NonNull
    public NavigableSet<AbstractMap.SimpleEntry<Double, BytesKey>> descendingSet() {
        return this.scores.descendingSet();
    }

    @Override
    @NonNull
    public Iterator<AbstractMap.SimpleEntry<Double, BytesKey>> descendingIterator() {
        return this.scores.descendingIterator();
    }

    @Override
    @NonNull
    public NavigableSet<AbstractMap.SimpleEntry<Double, BytesKey>> subSet(AbstractMap.SimpleEntry<Double, BytesKey> start, boolean b1, AbstractMap.SimpleEntry<Double, BytesKey> end, boolean b2) {
        return this.scores.subSet(start, b1, end, b2);
    }

    @Override
    @NonNull
    public NavigableSet<AbstractMap.SimpleEntry<Double, BytesKey>> headSet(AbstractMap.SimpleEntry<Double, BytesKey> entry, boolean b) {
        return this.scores.headSet(entry, b);
    }

    @Override
    @NonNull
    public NavigableSet<AbstractMap.SimpleEntry<Double, BytesKey>> tailSet(AbstractMap.SimpleEntry<Double, BytesKey> entry, boolean b) {
        return this.scores.tailSet(entry, b);
    }

    @Override
    public Comparator<? super AbstractMap.SimpleEntry<Double, BytesKey>> comparator() {
        return this.scores.comparator();
    }

    @Override
    @NonNull
    public SortedSet<AbstractMap.SimpleEntry<Double, BytesKey>> subSet(AbstractMap.SimpleEntry<Double, BytesKey> begin, AbstractMap.SimpleEntry<Double, BytesKey> end) {
        return this.scores.subSet(begin, end);
    }

    @Override
    @NonNull
    public SortedSet<AbstractMap.SimpleEntry<Double, BytesKey>> headSet(AbstractMap.SimpleEntry<Double, BytesKey> entry) {
        return this.scores.headSet(entry);
    }

    @Override
    @NonNull
    public SortedSet<AbstractMap.SimpleEntry<Double, BytesKey>> tailSet(AbstractMap.SimpleEntry<Double, BytesKey> entry) {
        return this.scores.tailSet(entry);
    }

    @Override
    public AbstractMap.SimpleEntry<Double, BytesKey> first() {
        return this.scores.first();
    }

    @Override
    public AbstractMap.SimpleEntry<Double, BytesKey> last() {
        return this.scores.last();
    }

    public Double getScore(BytesKey key) {
        return this.keys.get(key);
    }

    @Override
    public String toString() {
        return this.keys.toString();
    }
}

