/*
 * Decompiled with CFR 0.152.
 */
package dev.keva.core.server;

import com.google.common.base.Stopwatch;
import dev.keva.core.aof.AOFManager;
import dev.keva.core.command.mapping.CommandMapper;
import dev.keva.core.config.KevaConfig;
import dev.keva.core.exception.NettyNativeLoaderException;
import dev.keva.core.server.NettyChannelInitializer;
import dev.keva.core.server.NettyNativeTransportLoader;
import dev.keva.core.server.Server;
import dev.keva.ioc.KevaIoC;
import dev.keva.ioc.annotation.Autowired;
import dev.keva.ioc.annotation.Component;
import dev.keva.ioc.annotation.ComponentScan;
import dev.keva.storage.KevaDatabase;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.AbstractEventExecutorGroup;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@ComponentScan(value={"dev.keva.core"})
public class KevaServer
implements Server {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KevaServer.class);
    private final CompletableFuture<Void> ready = new CompletableFuture();
    private static final String KEVA_BANNER = "\n  _  __  ___  __   __    _   \n | |/ / | __| \\ \\ / /   /_\\  \n | ' <  | _|   \\ V /   / _ \\ \n |_|\\_\\ |___|   \\_/   /_/ \\_\\";
    private final KevaDatabase database;
    private final KevaConfig config;
    private final NettyChannelInitializer nettyChannelInitializer;
    private final CommandMapper commandMapper;
    private final AOFManager aofManager;
    private final Stopwatch stopwatch = Stopwatch.createUnstarted();
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private Channel channel;

    @Autowired
    private KevaServer(KevaDatabase database, KevaConfig config, NettyChannelInitializer nettyChannelInitializer, CommandMapper commandMapper, AOFManager aofManager) {
        this.database = database;
        this.config = config;
        this.nettyChannelInitializer = nettyChannelInitializer;
        this.commandMapper = commandMapper;
        this.aofManager = aofManager;
    }

    public static KevaServer ofDefaults() {
        KevaIoC context = KevaIoC.initBeans(KevaServer.class, (Object[])new Object[0]);
        return (KevaServer)context.getBean(KevaServer.class);
    }

    public static KevaServer of(KevaConfig config) {
        KevaIoC context = KevaIoC.initBeans(KevaServer.class, (Object[])new Object[]{config});
        return (KevaServer)context.getBean(KevaServer.class);
    }

    public static KevaServer ofCustomBeans(Object ... beans) {
        KevaIoC context = KevaIoC.initBeans(KevaServer.class, (Object[])beans);
        return (KevaServer)context.getBean(KevaServer.class);
    }

    public ServerBootstrap bootstrapServer() throws NettyNativeLoaderException {
        try {
            this.commandMapper.init();
            int ioThreads = Runtime.getRuntime().availableProcessors() * 2;
            if (this.config.getIoThreads() != null && this.config.getIoThreads() > 0) {
                ioThreads = this.config.getIoThreads();
            }
            Class<? extends AbstractEventExecutorGroup> executorGroupClazz = NettyNativeTransportLoader.getEventExecutorGroupClazz();
            this.bossGroup = (EventLoopGroup)executorGroupClazz.getDeclaredConstructor(Integer.TYPE).newInstance(1);
            this.workerGroup = (EventLoopGroup)executorGroupClazz.getDeclaredConstructor(Integer.TYPE).newInstance(ioThreads);
            return ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(NettyNativeTransportLoader.getServerSocketChannelClazz())).childHandler((ChannelHandler)this.nettyChannelInitializer).option(ChannelOption.SO_BACKLOG, (Object)100)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).childOption(ChannelOption.SO_RCVBUF, (Object)0x100000).childOption(ChannelOption.SO_SNDBUF, (Object)0x100000).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.TCP_NODELAY, (Object)true);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new NettyNativeLoaderException("Cannot load Netty classes");
        }
    }

    @Override
    public void shutdown() {
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        this.channel.close();
        log.info("Keva server at {} stopped", (Object)this.config.getPort());
        log.info("Bye bye!");
    }

    @Override
    public void run() {
        try {
            this.stopwatch.start();
            ServerBootstrap server = this.bootstrapServer();
            this.aofManager.init();
            ChannelFuture sync = server.bind(this.config.getPort().intValue()).sync();
            log.info("{} server started at {}:{}, in {} ms", new Object[]{KEVA_BANNER, this.config.getHostname(), this.config.getPort(), this.stopwatch.elapsed(TimeUnit.MILLISECONDS)});
            log.info("Ready to accept connections");
            this.ready.complete(null);
            this.channel = sync.channel();
            this.channel.closeFuture().sync();
        }
        catch (InterruptedException e) {
            log.error("Failed to start server: ", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            log.error("Failed to start server: ", (Throwable)e);
            this.ready.completeExceptionally(e);
        }
        finally {
            this.stopwatch.stop();
        }
    }

    @Override
    public void await() {
        this.ready.join();
    }

    @Override
    public void clear() {
        this.database.flush();
    }
}

