/*
 * Decompiled with CFR 0.152.
 */
package dev.keva.core.server;

import dev.keva.core.command.mapping.CommandMapper;
import dev.keva.core.command.mapping.CommandWrapper;
import dev.keva.ioc.annotation.Autowired;
import dev.keva.ioc.annotation.Component;
import dev.keva.protocol.resp.Command;
import dev.keva.protocol.resp.reply.ErrorReply;
import dev.keva.util.hashbytes.BytesKey;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleStateEvent;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
@Component
public class NettyChannelHandler
extends SimpleChannelInboundHandler<Command> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NettyChannelHandler.class);
    private final CommandMapper commandMapper;

    @Autowired
    public NettyChannelHandler(CommandMapper commandMapper) {
        this.commandMapper = commandMapper;
    }

    protected void channelRead0(ChannelHandlerContext ctx, Command command) throws InterruptedException {
        byte[] name = command.getName();
        CommandWrapper commandWrapper = this.commandMapper.getMethods().get(new BytesKey(name));
        ErrorReply reply = commandWrapper == null ? new ErrorReply("ERR unknown command `" + new String(name) + "`") : commandWrapper.execute(ctx, command);
        if (reply != null) {
            ctx.write(reply);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!cause.getMessage().equals("Connection reset by peer")) {
            log.error("Handler exception caught: ", cause);
        }
        ctx.close();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            log.info("IdleStateEvent triggered, close channel " + ctx.channel());
            this.channelUnregistered(ctx);
            ctx.close();
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }
}

